/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::extrudeModels::linearDirection

Description
    Extrudes by transforming points in a specified direction by the given
    distance.

    The linearDirectionCoeffs dictionary entries
    \table
        Property  | Description                             | Required | Default
        direction | The extrusion direction, normalized on input | yes |
        thickness | The extrusion thickness                 | yes |
    \endtable

\*---------------------------------------------------------------------------*/

#ifndef linearDirection_H
#define linearDirection_H

#include "point.H"
#include "extrudeModel.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace extrudeModels
{

/*---------------------------------------------------------------------------*\
                    Class linearDirection Declaration
\*---------------------------------------------------------------------------*/

class linearDirection
:
    public extrudeModel
{
    // Private data

        //- Extrude direction
        vector direction_;

        //- Layer thickness
        scalar thickness_;


public:

    //- Runtime type information
    TypeName("linearDirection");

    // Constructors

        //- Construct from dictionary
        explicit linearDirection(const dictionary& dict);


    //- Destructor
    virtual ~linearDirection() = default;


    // Member Operators

        point operator()
        (
            const point& surfacePoint,
            const vector& surfaceNormal,
            const label layer
        ) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace extrudeModels
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
