/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include "odil/registry.h"

#include <map>
#include <string>

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"
#include "odil/UIDsDictionary.h"

namespace odil
{

namespace registry
{

void update_0000(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0002(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0004(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0008(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0010(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0012(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0014(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0016(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0018(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0020(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_misc(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0022(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0024(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0028(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0032(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0034(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0038(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_003a(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0040(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0042(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0044(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0046(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0048(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0050(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0052(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0054(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0060(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0062(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0064(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0066(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0068(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_006a(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0070(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0072(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0074(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0076(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0078(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0080(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0082(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0088(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0100(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_0400(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2000(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2010(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2020(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2030(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2040(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2050(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2100(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2110(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2120(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2130(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_2200(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_3002(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_3004(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_3006(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_3008(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_300a(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_300c(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_300e(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_3010(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_4000(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_4008(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_4010(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_4ffe(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_5200(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_5400(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_5600(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_7fe0(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_fffa(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_fffc(ElementsDictionary &, std::map<std::string, odil::Tag> &);
void update_fffe(ElementsDictionary &, std::map<std::string, odil::Tag> &);

void update_uids_dictionary(UIDsDictionary & uids_dictionary)
{
    uids_dictionary.emplace("1.2.840.10008.1.1", UIDsDictionaryEntry("Verification SOP Class", "Verification",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.1", UIDsDictionaryEntry("Verification SOP Class", "VerificationSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.2", UIDsDictionaryEntry("Implicit VR Little Endian: Default Transfer Syntax for DICOM", "ImplicitVRLittleEndian",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.1", UIDsDictionaryEntry("Explicit VR Little Endian", "ExplicitVRLittleEndian",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.1.98", UIDsDictionaryEntry("Encapsulated Uncompressed Explicit VR Little Endian", "EncapsulatedUncompressedExplicitVRLittleEndian",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.1.99", UIDsDictionaryEntry("Deflated Explicit VR Little Endian", "DeflatedExplicitVRLittleEndian",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.2", UIDsDictionaryEntry("Explicit VR Big Endian (Retired)", "ExplicitVRBigEndian",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.2", UIDsDictionaryEntry("Explicit VR Big Endian (Retired)", "ExplicitVRBigEndian_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.50", UIDsDictionaryEntry("JPEG Baseline (Process 1): Default Transfer Syntax for Lossy JPEG 8 Bit Image Compression", "JPEGBaseline8Bit",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.50", UIDsDictionaryEntry("JPEG Baseline (Process 1): Default Transfer Syntax for Lossy JPEG 8 Bit Image Compression", "JPEGBaselineProcess1",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.51", UIDsDictionaryEntry("JPEG Extended (Process 2 & 4): Default Transfer Syntax for Lossy JPEG 12 Bit Image Compression (Process 4 only)", "JPEGExtended12Bit",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.51", UIDsDictionaryEntry("JPEG Extended (Process 2 & 4): Default Transfer Syntax for Lossy JPEG 12 Bit Image Compression (Process 4 only)", "JPEGExtendedProcess24",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.52", UIDsDictionaryEntry("JPEG Extended (Process 3 & 5) (Retired)", "JPEGExtended35",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.52", UIDsDictionaryEntry("JPEG Extended (Process 3 & 5) (Retired)", "JPEGExtendedProcess35_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.53", UIDsDictionaryEntry("JPEG Spectral Selection, Non-Hierarchical (Process 6 & 8) (Retired)", "JPEGSpectralSelectionNonHierarchical68",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.53", UIDsDictionaryEntry("JPEG Spectral Selection, Non-Hierarchical (Process 6 & 8) (Retired)", "JPEGSpectralSelectionNonHierarchicalProcess68_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.54", UIDsDictionaryEntry("JPEG Spectral Selection, Non-Hierarchical (Process 7 & 9) (Retired)", "JPEGSpectralSelectionNonHierarchical79",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.54", UIDsDictionaryEntry("JPEG Spectral Selection, Non-Hierarchical (Process 7 & 9) (Retired)", "JPEGSpectralSelectionNonHierarchicalProcess79_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.55", UIDsDictionaryEntry("JPEG Full Progression, Non-Hierarchical (Process 10 & 12) (Retired)", "JPEGFullProgressionNonHierarchical1012",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.55", UIDsDictionaryEntry("JPEG Full Progression, Non-Hierarchical (Process 10 & 12) (Retired)", "JPEGFullProgressionNonHierarchicalProcess1012_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.56", UIDsDictionaryEntry("JPEG Full Progression, Non-Hierarchical (Process 11 & 13) (Retired)", "JPEGFullProgressionNonHierarchical1113",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.56", UIDsDictionaryEntry("JPEG Full Progression, Non-Hierarchical (Process 11 & 13) (Retired)", "JPEGFullProgressionNonHierarchicalProcess1113_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.57", UIDsDictionaryEntry("JPEG Lossless, Non-Hierarchical (Process 14)", "JPEGLossless",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.57", UIDsDictionaryEntry("JPEG Lossless, Non-Hierarchical (Process 14)", "JPEGLosslessNonHierarchicalProcess14",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.58", UIDsDictionaryEntry("JPEG Lossless, Non-Hierarchical (Process 15) (Retired)", "JPEGLosslessNonHierarchical15",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.58", UIDsDictionaryEntry("JPEG Lossless, Non-Hierarchical (Process 15) (Retired)", "JPEGLosslessNonHierarchicalProcess15_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.59", UIDsDictionaryEntry("JPEG Extended, Hierarchical (Process 16 & 18) (Retired)", "JPEGExtendedHierarchical1618",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.59", UIDsDictionaryEntry("JPEG Extended, Hierarchical (Process 16 & 18) (Retired)", "JPEGExtendedHierarchicalProcess1618_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.60", UIDsDictionaryEntry("JPEG Extended, Hierarchical (Process 17 & 19) (Retired)", "JPEGExtendedHierarchical1719",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.60", UIDsDictionaryEntry("JPEG Extended, Hierarchical (Process 17 & 19) (Retired)", "JPEGExtendedHierarchicalProcess1719_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.61", UIDsDictionaryEntry("JPEG Spectral Selection, Hierarchical (Process 20 & 22) (Retired)", "JPEGSpectralSelectionHierarchical2022",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.61", UIDsDictionaryEntry("JPEG Spectral Selection, Hierarchical (Process 20 & 22) (Retired)", "JPEGSpectralSelectionHierarchicalProcess2022_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.62", UIDsDictionaryEntry("JPEG Spectral Selection, Hierarchical (Process 21 & 23) (Retired)", "JPEGSpectralSelectionHierarchical2123",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.62", UIDsDictionaryEntry("JPEG Spectral Selection, Hierarchical (Process 21 & 23) (Retired)", "JPEGSpectralSelectionHierarchicalProcess2123_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.63", UIDsDictionaryEntry("JPEG Full Progression, Hierarchical (Process 24 & 26) (Retired)", "JPEGFullProgressionHierarchical2426",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.63", UIDsDictionaryEntry("JPEG Full Progression, Hierarchical (Process 24 & 26) (Retired)", "JPEGFullProgressionHierarchicalProcess2426_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.64", UIDsDictionaryEntry("JPEG Full Progression, Hierarchical (Process 25 & 27) (Retired)", "JPEGFullProgressionHierarchical2527",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.64", UIDsDictionaryEntry("JPEG Full Progression, Hierarchical (Process 25 & 27) (Retired)", "JPEGFullProgressionHierarchicalProcess2527_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.65", UIDsDictionaryEntry("JPEG Lossless, Hierarchical (Process 28) (Retired)", "JPEGLosslessHierarchical28",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.65", UIDsDictionaryEntry("JPEG Lossless, Hierarchical (Process 28) (Retired)", "JPEGLosslessHierarchicalProcess28_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.66", UIDsDictionaryEntry("JPEG Lossless, Hierarchical (Process 29) (Retired)", "JPEGLosslessHierarchical29",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.66", UIDsDictionaryEntry("JPEG Lossless, Hierarchical (Process 29) (Retired)", "JPEGLosslessHierarchicalProcess29_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.70", UIDsDictionaryEntry("JPEG Lossless, Non-Hierarchical, First-Order Prediction (Process 14 [Selection Value 1]): Default Transfer Syntax for Lossless JPEG Image Compression", "JPEGLosslessSV1",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.70", UIDsDictionaryEntry("JPEG Lossless, Non-Hierarchical, First-Order Prediction (Process 14 [Selection Value 1]): Default Transfer Syntax for Lossless JPEG Image Compression", "JPEGLosslessNonHierarchicalFirstOrderPredictionProcess14SelectionValue1",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.80", UIDsDictionaryEntry("JPEG-LS Lossless Image Compression", "JPEGLSLossless",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.80", UIDsDictionaryEntry("JPEG-LS Lossless Image Compression", "JPEGLSLosslessImageCompression",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.81", UIDsDictionaryEntry("JPEG-LS Lossy (Near-Lossless) Image Compression", "JPEGLSNearLossless",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.81", UIDsDictionaryEntry("JPEG-LS Lossy (Near-Lossless) Image Compression", "JPEGLSLossyNearLosslessImageCompression",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.90", UIDsDictionaryEntry("JPEG 2000 Image Compression (Lossless Only)", "JPEG2000Lossless",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.90", UIDsDictionaryEntry("JPEG 2000 Image Compression (Lossless Only)", "JPEG2000ImageCompressionLosslessOnly",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.91", UIDsDictionaryEntry("JPEG 2000 Image Compression", "JPEG2000",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.91", UIDsDictionaryEntry("JPEG 2000 Image Compression", "JPEG2000ImageCompression",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.92", UIDsDictionaryEntry("JPEG 2000 Part 2 Multi-component Image Compression (Lossless Only)", "JPEG2000MCLossless",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.92", UIDsDictionaryEntry("JPEG 2000 Part 2 Multi-component Image Compression (Lossless Only)", "JPEG2000Part2MulticomponentImageCompressionLosslessOnly",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.93", UIDsDictionaryEntry("JPEG 2000 Part 2 Multi-component Image Compression", "JPEG2000MC",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.93", UIDsDictionaryEntry("JPEG 2000 Part 2 Multi-component Image Compression", "JPEG2000Part2MulticomponentImageCompression",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.94", UIDsDictionaryEntry("JPIP Referenced", "JPIPReferenced",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.95", UIDsDictionaryEntry("JPIP Referenced Deflate", "JPIPReferencedDeflate",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.100", UIDsDictionaryEntry("MPEG2 Main Profile / Main Level", "MPEG2MPML",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.100", UIDsDictionaryEntry("MPEG2 Main Profile / Main Level", "MPEG2MainProfileMainLevel",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.100.1", UIDsDictionaryEntry("Fragmentable MPEG2 Main Profile / Main Level", "MPEG2MPMLF",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.100.1", UIDsDictionaryEntry("Fragmentable MPEG2 Main Profile / Main Level", "FragmentableMPEG2MainProfileMainLevel",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.101", UIDsDictionaryEntry("MPEG2 Main Profile / High Level", "MPEG2MPHL",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.101", UIDsDictionaryEntry("MPEG2 Main Profile / High Level", "MPEG2MainProfileHighLevel",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.101.1", UIDsDictionaryEntry("Fragmentable MPEG2 Main Profile / High Level", "MPEG2MPHLF",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.101.1", UIDsDictionaryEntry("Fragmentable MPEG2 Main Profile / High Level", "FragmentableMPEG2MainProfileHighLevel",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.102", UIDsDictionaryEntry("MPEG-4 AVC/H.264 High Profile / Level 4.1", "MPEG4HP41",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.102", UIDsDictionaryEntry("MPEG-4 AVC/H.264 High Profile / Level 4.1", "MPEG4AVCH264HighProfileLevel41",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.102.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 High Profile / Level 4.1", "MPEG4HP41F",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.102.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 High Profile / Level 4.1", "FragmentableMPEG4AVCH264HighProfileLevel41",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.103", UIDsDictionaryEntry("MPEG-4 AVC/H.264 BD-compatible High Profile / Level 4.1", "MPEG4HP41BD",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.103", UIDsDictionaryEntry("MPEG-4 AVC/H.264 BD-compatible High Profile / Level 4.1", "MPEG4AVCH264BDcompatibleHighProfileLevel41",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.103.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 BD-compatible High Profile / Level 4.1", "MPEG4HP41BDF",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.103.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 BD-compatible High Profile / Level 4.1", "FragmentableMPEG4AVCH264BDcompatibleHighProfileLevel41",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.104", UIDsDictionaryEntry("MPEG-4 AVC/H.264 High Profile / Level 4.2 For 2D Video", "MPEG4HP422D",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.104", UIDsDictionaryEntry("MPEG-4 AVC/H.264 High Profile / Level 4.2 For 2D Video", "MPEG4AVCH264HighProfileLevel42For2DVideo",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.104.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 High Profile / Level 4.2 For 2D Video", "MPEG4HP422DF",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.104.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 High Profile / Level 4.2 For 2D Video", "FragmentableMPEG4AVCH264HighProfileLevel42For2DVideo",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.105", UIDsDictionaryEntry("MPEG-4 AVC/H.264 High Profile / Level 4.2 For 3D Video", "MPEG4HP423D",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.105", UIDsDictionaryEntry("MPEG-4 AVC/H.264 High Profile / Level 4.2 For 3D Video", "MPEG4AVCH264HighProfileLevel42For3DVideo",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.105.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 High Profile / Level 4.2 For 3D Video", "MPEG4HP423DF",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.105.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 High Profile / Level 4.2 For 3D Video", "FragmentableMPEG4AVCH264HighProfileLevel42For3DVideo",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.106", UIDsDictionaryEntry("MPEG-4 AVC/H.264 Stereo High Profile / Level 4.2", "MPEG4HP42STEREO",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.106", UIDsDictionaryEntry("MPEG-4 AVC/H.264 Stereo High Profile / Level 4.2", "MPEG4AVCH264StereoHighProfileLevel42",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.106.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 Stereo High Profile / Level 4.2", "MPEG4HP42STEREOF",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.106.1", UIDsDictionaryEntry("Fragmentable MPEG-4 AVC/H.264 Stereo High Profile / Level 4.2", "FragmentableMPEG4AVCH264StereoHighProfileLevel42",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.107", UIDsDictionaryEntry("HEVC/H.265 Main Profile / Level 5.1", "HEVCMP51",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.107", UIDsDictionaryEntry("HEVC/H.265 Main Profile / Level 5.1", "HEVCH265MainProfileLevel51",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.108", UIDsDictionaryEntry("HEVC/H.265 Main 10 Profile / Level 5.1", "HEVCM10P51",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.108", UIDsDictionaryEntry("HEVC/H.265 Main 10 Profile / Level 5.1", "HEVCH265Main10ProfileLevel51",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.201", UIDsDictionaryEntry("High-Throughput JPEG 2000 Image Compression (Lossless Only)", "HTJ2KLossless",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.201", UIDsDictionaryEntry("High-Throughput JPEG 2000 Image Compression (Lossless Only)", "HighThroughputJPEG2000ImageCompressionLosslessOnly",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.202", UIDsDictionaryEntry("High-Throughput JPEG 2000 with RPCL Options Image Compression (Lossless Only)", "HTJ2KLosslessRPCL",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.202", UIDsDictionaryEntry("High-Throughput JPEG 2000 with RPCL Options Image Compression (Lossless Only)", "HighThroughputJPEG2000withRPCLOptionsImageCompressionLosslessOnly",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.203", UIDsDictionaryEntry("High-Throughput JPEG 2000 Image Compression", "HTJ2K",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.203", UIDsDictionaryEntry("High-Throughput JPEG 2000 Image Compression", "HighThroughputJPEG2000ImageCompression",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.204", UIDsDictionaryEntry("JPIP HTJ2K Referenced", "JPIPHTJ2KReferenced",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.4.205", UIDsDictionaryEntry("JPIP HTJ2K Referenced Deflate", "JPIPHTJ2KReferencedDeflate",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.5", UIDsDictionaryEntry("RLE Lossless", "RLELossless",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.6.1", UIDsDictionaryEntry("RFC 2557 MIME encapsulation (Retired)", "RFC2557MIMEEncapsulation",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.6.1", UIDsDictionaryEntry("RFC 2557 MIME encapsulation (Retired)", "RFC2557MIMEencapsulation_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.6.2", UIDsDictionaryEntry("XML Encoding (Retired)", "XMLEncoding",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.6.2", UIDsDictionaryEntry("XML Encoding (Retired)", "XMLEncoding_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.7.1", UIDsDictionaryEntry("SMPTE ST 2110-20 Uncompressed Progressive Active Video", "SMPTEST211020UncompressedProgressiveActiveVideo",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.7.2", UIDsDictionaryEntry("SMPTE ST 2110-20 Uncompressed Interlaced Active Video", "SMPTEST211020UncompressedInterlacedActiveVideo",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.2.7.3", UIDsDictionaryEntry("SMPTE ST 2110-30 PCM Digital Audio", "SMPTEST211030PCMDigitalAudio",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.3.10", UIDsDictionaryEntry("Media Storage Directory Storage", "MediaStorageDirectoryStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.5.1", UIDsDictionaryEntry("Hot Iron Color Palette SOP Instance", "HotIronPalette",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.1", UIDsDictionaryEntry("Hot Iron Color Palette SOP Instance", "HotIronColorPaletteSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.2", UIDsDictionaryEntry("PET Color Palette SOP Instance", "PETPalette",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.2", UIDsDictionaryEntry("PET Color Palette SOP Instance", "PETColorPaletteSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.3", UIDsDictionaryEntry("Hot Metal Blue Color Palette SOP Instance", "HotMetalBluePalette",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.3", UIDsDictionaryEntry("Hot Metal Blue Color Palette SOP Instance", "HotMetalBlueColorPaletteSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.4", UIDsDictionaryEntry("PET 20 Step Color Palette SOP Instance", "PET20StepPalette",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.4", UIDsDictionaryEntry("PET 20 Step Color Palette SOP Instance", "PET20StepColorPaletteSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.5", UIDsDictionaryEntry("Spring Color Palette SOP Instance", "SpringPalette",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.5", UIDsDictionaryEntry("Spring Color Palette SOP Instance", "SpringColorPaletteSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.6", UIDsDictionaryEntry("Summer Color Palette SOP Instance", "SummerPalette",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.6", UIDsDictionaryEntry("Summer Color Palette SOP Instance", "SummerColorPaletteSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.7", UIDsDictionaryEntry("Fall Color Palette SOP Instance", "FallPalette",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.7", UIDsDictionaryEntry("Fall Color Palette SOP Instance", "FallColorPaletteSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.8", UIDsDictionaryEntry("Winter Color Palette SOP Instance", "WinterPalette",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.5.8", UIDsDictionaryEntry("Winter Color Palette SOP Instance", "WinterColorPaletteSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.9", UIDsDictionaryEntry("Basic Study Content Notification SOP Class (Retired)", "BasicStudyContentNotification",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.9", UIDsDictionaryEntry("Basic Study Content Notification SOP Class (Retired)", "BasicStudyContentNotificationSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.20", UIDsDictionaryEntry("Papyrus 3 Implicit VR Little Endian (Retired)", "Papyrus3ImplicitVRLittleEndian",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.20", UIDsDictionaryEntry("Papyrus 3 Implicit VR Little Endian (Retired)", "Papyrus3ImplicitVRLittleEndian_Retired",  "Transfer Syntax"));
    uids_dictionary.emplace("1.2.840.10008.1.20.1", UIDsDictionaryEntry("Storage Commitment Push Model SOP Class", "StorageCommitmentPushModel",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.20.1", UIDsDictionaryEntry("Storage Commitment Push Model SOP Class", "StorageCommitmentPushModelSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.20.1.1", UIDsDictionaryEntry("Storage Commitment Push Model SOP Instance", "StorageCommitmentPushModelInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.20.1.1", UIDsDictionaryEntry("Storage Commitment Push Model SOP Instance", "StorageCommitmentPushModelSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.20.2", UIDsDictionaryEntry("Storage Commitment Pull Model SOP Class (Retired)", "StorageCommitmentPullModel",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.20.2", UIDsDictionaryEntry("Storage Commitment Pull Model SOP Class (Retired)", "StorageCommitmentPullModelSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.20.2.1", UIDsDictionaryEntry("Storage Commitment Pull Model SOP Instance (Retired)", "StorageCommitmentPullModelInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.20.2.1", UIDsDictionaryEntry("Storage Commitment Pull Model SOP Instance (Retired)", "StorageCommitmentPullModelSOPInstance_Retired",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.40", UIDsDictionaryEntry("Procedural Event Logging SOP Class", "ProceduralEventLogging",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.40", UIDsDictionaryEntry("Procedural Event Logging SOP Class", "ProceduralEventLoggingSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.40.1", UIDsDictionaryEntry("Procedural Event Logging SOP Instance", "ProceduralEventLoggingInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.40.1", UIDsDictionaryEntry("Procedural Event Logging SOP Instance", "ProceduralEventLoggingSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.42", UIDsDictionaryEntry("Substance Administration Logging SOP Class", "SubstanceAdministrationLogging",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.42", UIDsDictionaryEntry("Substance Administration Logging SOP Class", "SubstanceAdministrationLoggingSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.1.42.1", UIDsDictionaryEntry("Substance Administration Logging SOP Instance", "SubstanceAdministrationLoggingInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.1.42.1", UIDsDictionaryEntry("Substance Administration Logging SOP Instance", "SubstanceAdministrationLoggingSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.2.6.1", UIDsDictionaryEntry("DICOM UID Registry", "DCMUID",  "DICOM UIDs as a Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.6.1", UIDsDictionaryEntry("DICOM UID Registry", "DICOMUIDRegistry",  "DICOM UIDs as a Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.4", UIDsDictionaryEntry("DICOM Controlled Terminology", "DCM",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.4", UIDsDictionaryEntry("DICOM Controlled Terminology", "DICOMControlledTerminology",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.5", UIDsDictionaryEntry("Adult Mouse Anatomy Ontology", "MA",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.5", UIDsDictionaryEntry("Adult Mouse Anatomy Ontology", "AdultMouseAnatomyOntology",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.6", UIDsDictionaryEntry("Uberon Ontology", "UBERON",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.6", UIDsDictionaryEntry("Uberon Ontology", "UberonOntology",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.7", UIDsDictionaryEntry("Integrated Taxonomic Information System (ITIS) Taxonomic Serial Number (TSN)", "ITIS_TSN",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.7", UIDsDictionaryEntry("Integrated Taxonomic Information System (ITIS) Taxonomic Serial Number (TSN)", "IntegratedTaxonomicInformationSystemITISTaxonomicSerialNumberTSN",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.8", UIDsDictionaryEntry("Mouse Genome Initiative (MGI)", "MGI",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.8", UIDsDictionaryEntry("Mouse Genome Initiative (MGI)", "MouseGenomeInitiativeMGI",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.9", UIDsDictionaryEntry("PubChem Compound CID", "PUBCHEM_CID",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.9", UIDsDictionaryEntry("PubChem Compound CID", "PubChemCompoundCID",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.10", UIDsDictionaryEntry("Dublin Core", "DC",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.10", UIDsDictionaryEntry("Dublin Core", "DublinCore",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.11", UIDsDictionaryEntry("New York University Melanoma Clinical Cooperative Group", "NYUMCCG",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.11", UIDsDictionaryEntry("New York University Melanoma Clinical Cooperative Group", "NewYorkUniversityMelanomaClinicalCooperativeGroup",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.12", UIDsDictionaryEntry("Mayo Clinic Non-radiological Images Specific Body Structure Anatomical Surface Region Guide", "MAYONRISBSASRG",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.12", UIDsDictionaryEntry("Mayo Clinic Non-radiological Images Specific Body Structure Anatomical Surface Region Guide", "MayoClinicNonradiologicalImagesSpecificBodyStructureAnatomicalSurfaceRegionGuide",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.13", UIDsDictionaryEntry("Image Biomarker Standardisation Initiative", "IBSI",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.13", UIDsDictionaryEntry("Image Biomarker Standardisation Initiative", "ImageBiomarkerStandardisationInitiative",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.14", UIDsDictionaryEntry("Radiomics Ontology", "RO",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.14", UIDsDictionaryEntry("Radiomics Ontology", "RadiomicsOntology",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.15", UIDsDictionaryEntry("RadElement", "RADELEMENT",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.15", UIDsDictionaryEntry("RadElement", "RadElement",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.16", UIDsDictionaryEntry("ICD-11", "I11",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.16", UIDsDictionaryEntry("ICD-11", "ICD11",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.17", UIDsDictionaryEntry("Unified numbering system (UNS) for metals and alloys", "UNS",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.17", UIDsDictionaryEntry("Unified numbering system (UNS) for metals and alloys", "UnifiednumberingsystemUNSformetalsandalloys",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.18", UIDsDictionaryEntry("Research Resource Identification", "RRID",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.2.16.18", UIDsDictionaryEntry("Research Resource Identification", "ResearchResourceIdentification",  "Coding Scheme"));
    uids_dictionary.emplace("1.2.840.10008.3.1.1.1", UIDsDictionaryEntry("DICOM Application Context Name", "DICOMApplicationContext",  "Application Context Name"));
    uids_dictionary.emplace("1.2.840.10008.3.1.1.1", UIDsDictionaryEntry("DICOM Application Context Name", "DICOMApplicationContextName",  "Application Context Name"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.1.1", UIDsDictionaryEntry("Detached Patient Management SOP Class (Retired)", "DetachedPatientManagement",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.1.1", UIDsDictionaryEntry("Detached Patient Management SOP Class (Retired)", "DetachedPatientManagementSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.1.4", UIDsDictionaryEntry("Detached Patient Management Meta SOP Class (Retired)", "DetachedPatientManagementMeta",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.1.4", UIDsDictionaryEntry("Detached Patient Management Meta SOP Class (Retired)", "DetachedPatientManagementMetaSOPClass_Retired",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.2.1", UIDsDictionaryEntry("Detached Visit Management SOP Class (Retired)", "DetachedVisitManagement",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.2.1", UIDsDictionaryEntry("Detached Visit Management SOP Class (Retired)", "DetachedVisitManagementSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.1", UIDsDictionaryEntry("Detached Study Management SOP Class (Retired)", "DetachedStudyManagement",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.1", UIDsDictionaryEntry("Detached Study Management SOP Class (Retired)", "DetachedStudyManagementSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.2", UIDsDictionaryEntry("Study Component Management SOP Class (Retired)", "StudyComponentManagement",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.2", UIDsDictionaryEntry("Study Component Management SOP Class (Retired)", "StudyComponentManagementSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.3", UIDsDictionaryEntry("Modality Performed Procedure Step SOP Class", "ModalityPerformedProcedureStep",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.3", UIDsDictionaryEntry("Modality Performed Procedure Step SOP Class", "ModalityPerformedProcedureStepSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.4", UIDsDictionaryEntry("Modality Performed Procedure Step Retrieve SOP Class", "ModalityPerformedProcedureStepRetrieve",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.4", UIDsDictionaryEntry("Modality Performed Procedure Step Retrieve SOP Class", "ModalityPerformedProcedureStepRetrieveSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.5", UIDsDictionaryEntry("Modality Performed Procedure Step Notification SOP Class", "ModalityPerformedProcedureStepNotification",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.3.5", UIDsDictionaryEntry("Modality Performed Procedure Step Notification SOP Class", "ModalityPerformedProcedureStepNotificationSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.5.1", UIDsDictionaryEntry("Detached Results Management SOP Class (Retired)", "DetachedResultsManagement",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.5.1", UIDsDictionaryEntry("Detached Results Management SOP Class (Retired)", "DetachedResultsManagementSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.5.4", UIDsDictionaryEntry("Detached Results Management Meta SOP Class (Retired)", "DetachedResultsManagementMeta",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.5.4", UIDsDictionaryEntry("Detached Results Management Meta SOP Class (Retired)", "DetachedResultsManagementMetaSOPClass_Retired",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.5.5", UIDsDictionaryEntry("Detached Study Management Meta SOP Class (Retired)", "DetachedStudyManagementMeta",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.5.5", UIDsDictionaryEntry("Detached Study Management Meta SOP Class (Retired)", "DetachedStudyManagementMetaSOPClass_Retired",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.6.1", UIDsDictionaryEntry("Detached Interpretation Management SOP Class (Retired)", "DetachedInterpretationManagement",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.3.1.2.6.1", UIDsDictionaryEntry("Detached Interpretation Management SOP Class (Retired)", "DetachedInterpretationManagementSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.4.2", UIDsDictionaryEntry("Storage Service Class", "Storage",  "Service Class"));
    uids_dictionary.emplace("1.2.840.10008.4.2", UIDsDictionaryEntry("Storage Service Class", "StorageServiceClass",  "Service Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.1", UIDsDictionaryEntry("Basic Film Session SOP Class", "BasicFilmSession",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.1", UIDsDictionaryEntry("Basic Film Session SOP Class", "BasicFilmSessionSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.2", UIDsDictionaryEntry("Basic Film Box SOP Class", "BasicFilmBox",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.2", UIDsDictionaryEntry("Basic Film Box SOP Class", "BasicFilmBoxSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.4", UIDsDictionaryEntry("Basic Grayscale Image Box SOP Class", "BasicGrayscaleImageBox",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.4", UIDsDictionaryEntry("Basic Grayscale Image Box SOP Class", "BasicGrayscaleImageBoxSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.4.1", UIDsDictionaryEntry("Basic Color Image Box SOP Class", "BasicColorImageBox",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.4.1", UIDsDictionaryEntry("Basic Color Image Box SOP Class", "BasicColorImageBoxSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.4.2", UIDsDictionaryEntry("Referenced Image Box SOP Class (Retired)", "ReferencedImageBox",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.4.2", UIDsDictionaryEntry("Referenced Image Box SOP Class (Retired)", "ReferencedImageBoxSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.9", UIDsDictionaryEntry("Basic Grayscale Print Management Meta SOP Class", "BasicGrayscalePrintManagementMeta",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.9", UIDsDictionaryEntry("Basic Grayscale Print Management Meta SOP Class", "BasicGrayscalePrintManagementMetaSOPClass",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.9.1", UIDsDictionaryEntry("Referenced Grayscale Print Management Meta SOP Class (Retired)", "ReferencedGrayscalePrintManagementMeta",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.9.1", UIDsDictionaryEntry("Referenced Grayscale Print Management Meta SOP Class (Retired)", "ReferencedGrayscalePrintManagementMetaSOPClass_Retired",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.14", UIDsDictionaryEntry("Print Job SOP Class", "PrintJob",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.14", UIDsDictionaryEntry("Print Job SOP Class", "PrintJobSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.15", UIDsDictionaryEntry("Basic Annotation Box SOP Class", "BasicAnnotationBox",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.15", UIDsDictionaryEntry("Basic Annotation Box SOP Class", "BasicAnnotationBoxSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.16", UIDsDictionaryEntry("Printer SOP Class", "Printer",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.16", UIDsDictionaryEntry("Printer SOP Class", "PrinterSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.16.376", UIDsDictionaryEntry("Printer Configuration Retrieval SOP Class", "PrinterConfigurationRetrieval",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.16.376", UIDsDictionaryEntry("Printer Configuration Retrieval SOP Class", "PrinterConfigurationRetrievalSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.17", UIDsDictionaryEntry("Printer SOP Instance", "PrinterInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.17", UIDsDictionaryEntry("Printer SOP Instance", "PrinterSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.17.376", UIDsDictionaryEntry("Printer Configuration Retrieval SOP Instance", "PrinterConfigurationRetrievalInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.17.376", UIDsDictionaryEntry("Printer Configuration Retrieval SOP Instance", "PrinterConfigurationRetrievalSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.18", UIDsDictionaryEntry("Basic Color Print Management Meta SOP Class", "BasicColorPrintManagementMeta",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.18", UIDsDictionaryEntry("Basic Color Print Management Meta SOP Class", "BasicColorPrintManagementMetaSOPClass",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.18.1", UIDsDictionaryEntry("Referenced Color Print Management Meta SOP Class (Retired)", "ReferencedColorPrintManagementMeta",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.18.1", UIDsDictionaryEntry("Referenced Color Print Management Meta SOP Class (Retired)", "ReferencedColorPrintManagementMetaSOPClass_Retired",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.22", UIDsDictionaryEntry("VOI LUT Box SOP Class", "VOILUTBox",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.22", UIDsDictionaryEntry("VOI LUT Box SOP Class", "VOILUTBoxSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.23", UIDsDictionaryEntry("Presentation LUT SOP Class", "PresentationLUT",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.23", UIDsDictionaryEntry("Presentation LUT SOP Class", "PresentationLUTSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.24", UIDsDictionaryEntry("Image Overlay Box SOP Class (Retired)", "ImageOverlayBox",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.24", UIDsDictionaryEntry("Image Overlay Box SOP Class (Retired)", "ImageOverlayBoxSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.24.1", UIDsDictionaryEntry("Basic Print Image Overlay Box SOP Class (Retired)", "BasicPrintImageOverlayBox",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.24.1", UIDsDictionaryEntry("Basic Print Image Overlay Box SOP Class (Retired)", "BasicPrintImageOverlayBoxSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.25", UIDsDictionaryEntry("Print Queue SOP Instance (Retired)", "PrintQueueInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.25", UIDsDictionaryEntry("Print Queue SOP Instance (Retired)", "PrintQueueSOPInstance_Retired",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.26", UIDsDictionaryEntry("Print Queue Management SOP Class (Retired)", "PrintQueueManagement",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.26", UIDsDictionaryEntry("Print Queue Management SOP Class (Retired)", "PrintQueueManagementSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.27", UIDsDictionaryEntry("Stored Print Storage SOP Class (Retired)", "StoredPrintStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.27", UIDsDictionaryEntry("Stored Print Storage SOP Class (Retired)", "StoredPrintStorageSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.29", UIDsDictionaryEntry("Hardcopy Grayscale Image Storage SOP Class (Retired)", "HardcopyGrayscaleImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.29", UIDsDictionaryEntry("Hardcopy Grayscale Image Storage SOP Class (Retired)", "HardcopyGrayscaleImageStorageSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.30", UIDsDictionaryEntry("Hardcopy Color Image Storage SOP Class (Retired)", "HardcopyColorImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.30", UIDsDictionaryEntry("Hardcopy Color Image Storage SOP Class (Retired)", "HardcopyColorImageStorageSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.31", UIDsDictionaryEntry("Pull Print Request SOP Class (Retired)", "PullPrintRequest",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.31", UIDsDictionaryEntry("Pull Print Request SOP Class (Retired)", "PullPrintRequestSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.32", UIDsDictionaryEntry("Pull Stored Print Management Meta SOP Class (Retired)", "PullStoredPrintManagementMeta",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.32", UIDsDictionaryEntry("Pull Stored Print Management Meta SOP Class (Retired)", "PullStoredPrintManagementMetaSOPClass_Retired",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.33", UIDsDictionaryEntry("Media Creation Management SOP Class UID", "MediaCreationManagement",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.33", UIDsDictionaryEntry("Media Creation Management SOP Class UID", "MediaCreationManagementSOPClassUID",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.40", UIDsDictionaryEntry("Display System SOP Class", "DisplaySystem",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.40", UIDsDictionaryEntry("Display System SOP Class", "DisplaySystemSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.40.1", UIDsDictionaryEntry("Display System SOP Instance", "DisplaySystemInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.1.40.1", UIDsDictionaryEntry("Display System SOP Instance", "DisplaySystemSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.1", UIDsDictionaryEntry("Computed Radiography Image Storage", "ComputedRadiographyImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.1.1", UIDsDictionaryEntry("Digital X-Ray Image Storage - For Presentation", "DigitalXRayImageStorageForPresentation",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.1.1.1", UIDsDictionaryEntry("Digital X-Ray Image Storage - For Processing", "DigitalXRayImageStorageForProcessing",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.1.2", UIDsDictionaryEntry("Digital Mammography X-Ray Image Storage - For Presentation", "DigitalMammographyXRayImageStorageForPresentation",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.1.2.1", UIDsDictionaryEntry("Digital Mammography X-Ray Image Storage - For Processing", "DigitalMammographyXRayImageStorageForProcessing",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.1.3", UIDsDictionaryEntry("Digital Intra-Oral X-Ray Image Storage - For Presentation", "DigitalIntraOralXRayImageStorageForPresentation",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.1.3.1", UIDsDictionaryEntry("Digital Intra-Oral X-Ray Image Storage - For Processing", "DigitalIntraOralXRayImageStorageForProcessing",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.2", UIDsDictionaryEntry("CT Image Storage", "CTImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.2.1", UIDsDictionaryEntry("Enhanced CT Image Storage", "EnhancedCTImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.2.2", UIDsDictionaryEntry("Legacy Converted Enhanced CT Image Storage", "LegacyConvertedEnhancedCTImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.3", UIDsDictionaryEntry("Ultrasound Multi-frame Image Storage (Retired)", "UltrasoundMultiFrameImageStorageRetired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.3", UIDsDictionaryEntry("Ultrasound Multi-frame Image Storage (Retired)", "UltrasoundMultiframeImageStorage_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.3.1", UIDsDictionaryEntry("Ultrasound Multi-frame Image Storage", "UltrasoundMultiFrameImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.3.1", UIDsDictionaryEntry("Ultrasound Multi-frame Image Storage", "UltrasoundMultiframeImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.4", UIDsDictionaryEntry("MR Image Storage", "MRImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.4.1", UIDsDictionaryEntry("Enhanced MR Image Storage", "EnhancedMRImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.4.2", UIDsDictionaryEntry("MR Spectroscopy Storage", "MRSpectroscopyStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.4.3", UIDsDictionaryEntry("Enhanced MR Color Image Storage", "EnhancedMRColorImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.4.4", UIDsDictionaryEntry("Legacy Converted Enhanced MR Image Storage", "LegacyConvertedEnhancedMRImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.5", UIDsDictionaryEntry("Nuclear Medicine Image Storage (Retired)", "NuclearMedicineImageStorageRetired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.5", UIDsDictionaryEntry("Nuclear Medicine Image Storage (Retired)", "NuclearMedicineImageStorage_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.6", UIDsDictionaryEntry("Ultrasound Image Storage (Retired)", "UltrasoundImageStorageRetired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.6", UIDsDictionaryEntry("Ultrasound Image Storage (Retired)", "UltrasoundImageStorage_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.6.1", UIDsDictionaryEntry("Ultrasound Image Storage", "UltrasoundImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.6.2", UIDsDictionaryEntry("Enhanced US Volume Storage", "EnhancedUSVolumeStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.6.3", UIDsDictionaryEntry("Photoacoustic Image Storage", "PhotoacousticImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.7", UIDsDictionaryEntry("Secondary Capture Image Storage", "SecondaryCaptureImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.7.1", UIDsDictionaryEntry("Multi-frame Single Bit Secondary Capture Image Storage", "MultiFrameSingleBitSecondaryCaptureImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.7.1", UIDsDictionaryEntry("Multi-frame Single Bit Secondary Capture Image Storage", "MultiframeSingleBitSecondaryCaptureImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.7.2", UIDsDictionaryEntry("Multi-frame Grayscale Byte Secondary Capture Image Storage", "MultiFrameGrayscaleByteSecondaryCaptureImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.7.2", UIDsDictionaryEntry("Multi-frame Grayscale Byte Secondary Capture Image Storage", "MultiframeGrayscaleByteSecondaryCaptureImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.7.3", UIDsDictionaryEntry("Multi-frame Grayscale Word Secondary Capture Image Storage", "MultiFrameGrayscaleWordSecondaryCaptureImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.7.3", UIDsDictionaryEntry("Multi-frame Grayscale Word Secondary Capture Image Storage", "MultiframeGrayscaleWordSecondaryCaptureImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.7.4", UIDsDictionaryEntry("Multi-frame True Color Secondary Capture Image Storage", "MultiFrameTrueColorSecondaryCaptureImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.7.4", UIDsDictionaryEntry("Multi-frame True Color Secondary Capture Image Storage", "MultiframeTrueColorSecondaryCaptureImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.8", UIDsDictionaryEntry("Standalone Overlay Storage (Retired)", "StandaloneOverlayStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.8", UIDsDictionaryEntry("Standalone Overlay Storage (Retired)", "StandaloneOverlayStorage_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9", UIDsDictionaryEntry("Standalone Curve Storage (Retired)", "StandaloneCurveStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9", UIDsDictionaryEntry("Standalone Curve Storage (Retired)", "StandaloneCurveStorage_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.1", UIDsDictionaryEntry("Waveform Storage - Trial (Retired)", "WaveformStorageTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.1", UIDsDictionaryEntry("Waveform Storage - Trial (Retired)", "WaveformStorageTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.1.1", UIDsDictionaryEntry("12-lead ECG Waveform Storage", "TwelveLeadECGWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.1.2", UIDsDictionaryEntry("General ECG Waveform Storage", "GeneralECGWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.1.3", UIDsDictionaryEntry("Ambulatory ECG Waveform Storage", "AmbulatoryECGWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.1.4", UIDsDictionaryEntry("General 32-bit ECG Waveform Storage", "General32bitECGWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.2.1", UIDsDictionaryEntry("Hemodynamic Waveform Storage", "HemodynamicWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.3.1", UIDsDictionaryEntry("Cardiac Electrophysiology Waveform Storage", "CardiacElectrophysiologyWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.4.1", UIDsDictionaryEntry("Basic Voice Audio Waveform Storage", "BasicVoiceAudioWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.4.2", UIDsDictionaryEntry("General Audio Waveform Storage", "GeneralAudioWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.5.1", UIDsDictionaryEntry("Arterial Pulse Waveform Storage", "ArterialPulseWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.6.1", UIDsDictionaryEntry("Respiratory Waveform Storage", "RespiratoryWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.6.2", UIDsDictionaryEntry("Multi-channel Respiratory Waveform Storage", "MultichannelRespiratoryWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.7.1", UIDsDictionaryEntry("Routine Scalp Electroencephalogram Waveform Storage", "RoutineScalpElectroencephalogramWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.7.2", UIDsDictionaryEntry("Electromyogram Waveform Storage", "ElectromyogramWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.7.3", UIDsDictionaryEntry("Electrooculogram Waveform Storage", "ElectrooculogramWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.7.4", UIDsDictionaryEntry("Sleep Electroencephalogram Waveform Storage", "SleepElectroencephalogramWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.9.8.1", UIDsDictionaryEntry("Body Position Waveform Storage", "BodyPositionWaveformStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.10", UIDsDictionaryEntry("Standalone Modality LUT Storage (Retired)", "StandaloneModalityLUTStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.10", UIDsDictionaryEntry("Standalone Modality LUT Storage (Retired)", "StandaloneModalityLUTStorage_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11", UIDsDictionaryEntry("Standalone VOI LUT Storage (Retired)", "StandaloneVOILUTStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11", UIDsDictionaryEntry("Standalone VOI LUT Storage (Retired)", "StandaloneVOILUTStorage_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.1", UIDsDictionaryEntry("Grayscale Softcopy Presentation State Storage", "GrayscaleSoftcopyPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.2", UIDsDictionaryEntry("Color Softcopy Presentation State Storage", "ColorSoftcopyPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.3", UIDsDictionaryEntry("Pseudo-Color Softcopy Presentation State Storage", "PseudoColorSoftcopyPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.4", UIDsDictionaryEntry("Blending Softcopy Presentation State Storage", "BlendingSoftcopyPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.5", UIDsDictionaryEntry("XA/XRF Grayscale Softcopy Presentation State Storage", "XAXRFGrayscaleSoftcopyPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.6", UIDsDictionaryEntry("Grayscale Planar MPR Volumetric Presentation State Storage", "GrayscalePlanarMPRVolumetricPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.7", UIDsDictionaryEntry("Compositing Planar MPR Volumetric Presentation State Storage", "CompositingPlanarMPRVolumetricPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.8", UIDsDictionaryEntry("Advanced Blending Presentation State Storage", "AdvancedBlendingPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.9", UIDsDictionaryEntry("Volume Rendering Volumetric Presentation State Storage", "VolumeRenderingVolumetricPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.10", UIDsDictionaryEntry("Segmented Volume Rendering Volumetric Presentation State Storage", "SegmentedVolumeRenderingVolumetricPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.11", UIDsDictionaryEntry("Multiple Volume Rendering Volumetric Presentation State Storage", "MultipleVolumeRenderingVolumetricPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.11.12", UIDsDictionaryEntry("Variable Modality LUT Softcopy Presentation State Storage", "VariableModalityLUTSoftcopyPresentationStateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.12.1", UIDsDictionaryEntry("X-Ray Angiographic Image Storage", "XRayAngiographicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.12.1.1", UIDsDictionaryEntry("Enhanced XA Image Storage", "EnhancedXAImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.12.2", UIDsDictionaryEntry("X-Ray Radiofluoroscopic Image Storage", "XRayRadiofluoroscopicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.12.2.1", UIDsDictionaryEntry("Enhanced XRF Image Storage", "EnhancedXRFImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.12.3", UIDsDictionaryEntry("X-Ray Angiographic Bi-Plane Image Storage (Retired)", "XRayAngiographicBiPlaneImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.12.3", UIDsDictionaryEntry("X-Ray Angiographic Bi-Plane Image Storage (Retired)", "XRayAngiographicBiPlaneImageStorage_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.13.1.1", UIDsDictionaryEntry("X-Ray 3D Angiographic Image Storage", "XRay3DAngiographicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.13.1.2", UIDsDictionaryEntry("X-Ray 3D Craniofacial Image Storage", "XRay3DCraniofacialImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.13.1.3", UIDsDictionaryEntry("Breast Tomosynthesis Image Storage", "BreastTomosynthesisImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.13.1.4", UIDsDictionaryEntry("Breast Projection X-Ray Image Storage - For Presentation", "BreastProjectionXRayImageStorageForPresentation",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.13.1.5", UIDsDictionaryEntry("Breast Projection X-Ray Image Storage - For Processing", "BreastProjectionXRayImageStorageForProcessing",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.14.1", UIDsDictionaryEntry("Intravascular Optical Coherence Tomography Image Storage - For Presentation", "IntravascularOpticalCoherenceTomographyImageStorageForPresentation",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.14.2", UIDsDictionaryEntry("Intravascular Optical Coherence Tomography Image Storage - For Processing", "IntravascularOpticalCoherenceTomographyImageStorageForProcessing",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.20", UIDsDictionaryEntry("Nuclear Medicine Image Storage", "NuclearMedicineImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.30", UIDsDictionaryEntry("Parametric Map Storage", "ParametricMapStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.66", UIDsDictionaryEntry("Raw Data Storage", "RawDataStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.66.1", UIDsDictionaryEntry("Spatial Registration Storage", "SpatialRegistrationStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.66.2", UIDsDictionaryEntry("Spatial Fiducials Storage", "SpatialFiducialsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.66.3", UIDsDictionaryEntry("Deformable Spatial Registration Storage", "DeformableSpatialRegistrationStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.66.4", UIDsDictionaryEntry("Segmentation Storage", "SegmentationStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.66.5", UIDsDictionaryEntry("Surface Segmentation Storage", "SurfaceSegmentationStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.66.6", UIDsDictionaryEntry("Tractography Results Storage", "TractographyResultsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.67", UIDsDictionaryEntry("Real World Value Mapping Storage", "RealWorldValueMappingStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.68.1", UIDsDictionaryEntry("Surface Scan Mesh Storage", "SurfaceScanMeshStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.68.2", UIDsDictionaryEntry("Surface Scan Point Cloud Storage", "SurfaceScanPointCloudStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1", UIDsDictionaryEntry("VL Image Storage - Trial (Retired)", "VLImageStorageTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1", UIDsDictionaryEntry("VL Image Storage - Trial (Retired)", "VLImageStorageTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.2", UIDsDictionaryEntry("VL Multi-frame Image Storage - Trial (Retired)", "VLMultiFrameImageStorageTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.2", UIDsDictionaryEntry("VL Multi-frame Image Storage - Trial (Retired)", "VLMultiframeImageStorageTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.1", UIDsDictionaryEntry("VL Endoscopic Image Storage", "VLEndoscopicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.1.1", UIDsDictionaryEntry("Video Endoscopic Image Storage", "VideoEndoscopicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.2", UIDsDictionaryEntry("VL Microscopic Image Storage", "VLMicroscopicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.2.1", UIDsDictionaryEntry("Video Microscopic Image Storage", "VideoMicroscopicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.3", UIDsDictionaryEntry("VL Slide-Coordinates Microscopic Image Storage", "VLSlideCoordinatesMicroscopicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.4", UIDsDictionaryEntry("VL Photographic Image Storage", "VLPhotographicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.4.1", UIDsDictionaryEntry("Video Photographic Image Storage", "VideoPhotographicImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.5.1", UIDsDictionaryEntry("Ophthalmic Photography 8 Bit Image Storage", "OphthalmicPhotography8BitImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.5.2", UIDsDictionaryEntry("Ophthalmic Photography 16 Bit Image Storage", "OphthalmicPhotography16BitImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.5.3", UIDsDictionaryEntry("Stereometric Relationship Storage", "StereometricRelationshipStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.5.4", UIDsDictionaryEntry("Ophthalmic Tomography Image Storage", "OphthalmicTomographyImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.5.5", UIDsDictionaryEntry("Wide Field Ophthalmic Photography Stereographic Projection Image Storage", "WideFieldOphthalmicPhotographyStereographicProjectionImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.5.6", UIDsDictionaryEntry("Wide Field Ophthalmic Photography 3D Coordinates Image Storage", "WideFieldOphthalmicPhotography3DCoordinatesImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.5.7", UIDsDictionaryEntry("Ophthalmic Optical Coherence Tomography En Face Image Storage", "OphthalmicOpticalCoherenceTomographyEnFaceImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.5.8", UIDsDictionaryEntry("Ophthalmic Optical Coherence Tomography B-scan Volume Analysis Storage", "OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.6", UIDsDictionaryEntry("VL Whole Slide Microscopy Image Storage", "VLWholeSlideMicroscopyImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.7", UIDsDictionaryEntry("Dermoscopic Photography Image Storage", "DermoscopicPhotographyImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.8", UIDsDictionaryEntry("Confocal Microscopy Image Storage", "ConfocalMicroscopyImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.77.1.9", UIDsDictionaryEntry("Confocal Microscopy Tiled Pyramidal Image Storage", "ConfocalMicroscopyTiledPyramidalImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.78.1", UIDsDictionaryEntry("Lensometry Measurements Storage", "LensometryMeasurementsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.78.2", UIDsDictionaryEntry("Autorefraction Measurements Storage", "AutorefractionMeasurementsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.78.3", UIDsDictionaryEntry("Keratometry Measurements Storage", "KeratometryMeasurementsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.78.4", UIDsDictionaryEntry("Subjective Refraction Measurements Storage", "SubjectiveRefractionMeasurementsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.78.5", UIDsDictionaryEntry("Visual Acuity Measurements Storage", "VisualAcuityMeasurementsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.78.6", UIDsDictionaryEntry("Spectacle Prescription Report Storage", "SpectaclePrescriptionReportStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.78.7", UIDsDictionaryEntry("Ophthalmic Axial Measurements Storage", "OphthalmicAxialMeasurementsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.78.8", UIDsDictionaryEntry("Intraocular Lens Calculations Storage", "IntraocularLensCalculationsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.79.1", UIDsDictionaryEntry("Macular Grid Thickness and Volume Report Storage", "MacularGridThicknessAndVolumeReportStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.79.1", UIDsDictionaryEntry("Macular Grid Thickness and Volume Report Storage", "MacularGridThicknessandVolumeReportStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.80.1", UIDsDictionaryEntry("Ophthalmic Visual Field Static Perimetry Measurements Storage", "OphthalmicVisualFieldStaticPerimetryMeasurementsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.81.1", UIDsDictionaryEntry("Ophthalmic Thickness Map Storage", "OphthalmicThicknessMapStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.82.1", UIDsDictionaryEntry("Corneal Topography Map Storage", "CornealTopographyMapStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.1", UIDsDictionaryEntry("Text SR Storage - Trial (Retired)", "TextSRStorageTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.1", UIDsDictionaryEntry("Text SR Storage - Trial (Retired)", "TextSRStorageTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.2", UIDsDictionaryEntry("Audio SR Storage - Trial (Retired)", "AudioSRStorageTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.2", UIDsDictionaryEntry("Audio SR Storage - Trial (Retired)", "AudioSRStorageTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.3", UIDsDictionaryEntry("Detail SR Storage - Trial (Retired)", "DetailSRStorageTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.3", UIDsDictionaryEntry("Detail SR Storage - Trial (Retired)", "DetailSRStorageTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.4", UIDsDictionaryEntry("Comprehensive SR Storage - Trial (Retired)", "ComprehensiveSRStorageTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.4", UIDsDictionaryEntry("Comprehensive SR Storage - Trial (Retired)", "ComprehensiveSRStorageTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.11", UIDsDictionaryEntry("Basic Text SR Storage", "BasicTextSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.22", UIDsDictionaryEntry("Enhanced SR Storage", "EnhancedSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.33", UIDsDictionaryEntry("Comprehensive SR Storage", "ComprehensiveSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.34", UIDsDictionaryEntry("Comprehensive 3D SR Storage", "Comprehensive3DSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.35", UIDsDictionaryEntry("Extensible SR Storage", "ExtensibleSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.40", UIDsDictionaryEntry("Procedure Log Storage", "ProcedureLogStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.50", UIDsDictionaryEntry("Mammography CAD SR Storage", "MammographyCADSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.59", UIDsDictionaryEntry("Key Object Selection Document Storage", "KeyObjectSelectionDocumentStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.65", UIDsDictionaryEntry("Chest CAD SR Storage", "ChestCADSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.67", UIDsDictionaryEntry("X-Ray Radiation Dose SR Storage", "XRayRadiationDoseSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.68", UIDsDictionaryEntry("Radiopharmaceutical Radiation Dose SR Storage", "RadiopharmaceuticalRadiationDoseSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.69", UIDsDictionaryEntry("Colon CAD SR Storage", "ColonCADSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.70", UIDsDictionaryEntry("Implantation Plan SR Storage", "ImplantationPlanSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.71", UIDsDictionaryEntry("Acquisition Context SR Storage", "AcquisitionContextSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.72", UIDsDictionaryEntry("Simplified Adult Echo SR Storage", "SimplifiedAdultEchoSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.73", UIDsDictionaryEntry("Patient Radiation Dose SR Storage", "PatientRadiationDoseSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.74", UIDsDictionaryEntry("Planned Imaging Agent Administration SR Storage", "PlannedImagingAgentAdministrationSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.75", UIDsDictionaryEntry("Performed Imaging Agent Administration SR Storage", "PerformedImagingAgentAdministrationSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.88.76", UIDsDictionaryEntry("Enhanced X-Ray Radiation Dose SR Storage", "EnhancedXRayRadiationDoseSRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.90.1", UIDsDictionaryEntry("Content Assessment Results Storage", "ContentAssessmentResultsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.91.1", UIDsDictionaryEntry("Microscopy Bulk Simple Annotations Storage", "MicroscopyBulkSimpleAnnotationsStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.104.1", UIDsDictionaryEntry("Encapsulated PDF Storage", "EncapsulatedPDFStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.104.2", UIDsDictionaryEntry("Encapsulated CDA Storage", "EncapsulatedCDAStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.104.3", UIDsDictionaryEntry("Encapsulated STL Storage", "EncapsulatedSTLStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.104.4", UIDsDictionaryEntry("Encapsulated OBJ Storage", "EncapsulatedOBJStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.104.5", UIDsDictionaryEntry("Encapsulated MTL Storage", "EncapsulatedMTLStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.128", UIDsDictionaryEntry("Positron Emission Tomography Image Storage", "PositronEmissionTomographyImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.128.1", UIDsDictionaryEntry("Legacy Converted Enhanced PET Image Storage", "LegacyConvertedEnhancedPETImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.129", UIDsDictionaryEntry("Standalone PET Curve Storage (Retired)", "StandalonePETCurveStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.129", UIDsDictionaryEntry("Standalone PET Curve Storage (Retired)", "StandalonePETCurveStorage_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.130", UIDsDictionaryEntry("Enhanced PET Image Storage", "EnhancedPETImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.131", UIDsDictionaryEntry("Basic Structured Display Storage", "BasicStructuredDisplayStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.1", UIDsDictionaryEntry("CT Defined Procedure Protocol Storage", "CTDefinedProcedureProtocolStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.2", UIDsDictionaryEntry("CT Performed Procedure Protocol Storage", "CTPerformedProcedureProtocolStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.3", UIDsDictionaryEntry("Protocol Approval Storage", "ProtocolApprovalStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.4", UIDsDictionaryEntry("Protocol Approval Information Model - FIND", "ProtocolApprovalInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.4", UIDsDictionaryEntry("Protocol Approval Information Model - FIND", "ProtocolApprovalInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.5", UIDsDictionaryEntry("Protocol Approval Information Model - MOVE", "ProtocolApprovalInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.5", UIDsDictionaryEntry("Protocol Approval Information Model - MOVE", "ProtocolApprovalInformationModelMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.6", UIDsDictionaryEntry("Protocol Approval Information Model - GET", "ProtocolApprovalInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.6", UIDsDictionaryEntry("Protocol Approval Information Model - GET", "ProtocolApprovalInformationModelGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.7", UIDsDictionaryEntry("XA Defined Procedure Protocol Storage", "XADefinedProcedureProtocolStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.200.8", UIDsDictionaryEntry("XA Performed Procedure Protocol Storage", "XAPerformedProcedureProtocolStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.1", UIDsDictionaryEntry("Inventory Storage", "InventoryStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.2", UIDsDictionaryEntry("Inventory - FIND", "InventoryFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.2", UIDsDictionaryEntry("Inventory - FIND", "InventoryFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.3", UIDsDictionaryEntry("Inventory - MOVE", "InventoryMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.3", UIDsDictionaryEntry("Inventory - MOVE", "InventoryMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.4", UIDsDictionaryEntry("Inventory - GET", "InventoryGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.4", UIDsDictionaryEntry("Inventory - GET", "InventoryGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.5", UIDsDictionaryEntry("Inventory Creation", "InventoryCreation",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.6", UIDsDictionaryEntry("Repository Query", "RepositoryQuery",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.1.1", UIDsDictionaryEntry("Storage Management SOP Instance", "StorageManagementInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.201.1.1", UIDsDictionaryEntry("Storage Management SOP Instance", "StorageManagementSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.1", UIDsDictionaryEntry("RT Image Storage", "RTImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.2", UIDsDictionaryEntry("RT Dose Storage", "RTDoseStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.3", UIDsDictionaryEntry("RT Structure Set Storage", "RTStructureSetStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.4", UIDsDictionaryEntry("RT Beams Treatment Record Storage", "RTBeamsTreatmentRecordStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.5", UIDsDictionaryEntry("RT Plan Storage", "RTPlanStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.6", UIDsDictionaryEntry("RT Brachy Treatment Record Storage", "RTBrachyTreatmentRecordStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.7", UIDsDictionaryEntry("RT Treatment Summary Record Storage", "RTTreatmentSummaryRecordStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.8", UIDsDictionaryEntry("RT Ion Plan Storage", "RTIonPlanStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.9", UIDsDictionaryEntry("RT Ion Beams Treatment Record Storage", "RTIonBeamsTreatmentRecordStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.10", UIDsDictionaryEntry("RT Physician Intent Storage", "RTPhysicianIntentStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.11", UIDsDictionaryEntry("RT Segment Annotation Storage", "RTSegmentAnnotationStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.12", UIDsDictionaryEntry("RT Radiation Set Storage", "RTRadiationSetStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.13", UIDsDictionaryEntry("C-Arm Photon-Electron Radiation Storage", "CArmPhotonElectronRadiationStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.14", UIDsDictionaryEntry("Tomotherapeutic Radiation Storage", "TomotherapeuticRadiationStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.15", UIDsDictionaryEntry("Robotic-Arm Radiation Storage", "RoboticArmRadiationStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.16", UIDsDictionaryEntry("RT Radiation Record Set Storage", "RTRadiationRecordSetStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.17", UIDsDictionaryEntry("RT Radiation Salvage Record Storage", "RTRadiationSalvageRecordStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.18", UIDsDictionaryEntry("Tomotherapeutic Radiation Record Storage", "TomotherapeuticRadiationRecordStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.19", UIDsDictionaryEntry("C-Arm Photon-Electron Radiation Record Storage", "CArmPhotonElectronRadiationRecordStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.20", UIDsDictionaryEntry("Robotic Radiation Record Storage", "RoboticRadiationRecordStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.21", UIDsDictionaryEntry("RT Radiation Set Delivery Instruction Storage", "RTRadiationSetDeliveryInstructionStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.22", UIDsDictionaryEntry("RT Treatment Preparation Storage", "RTTreatmentPreparationStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.23", UIDsDictionaryEntry("Enhanced RT Image Storage", "EnhancedRTImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.24", UIDsDictionaryEntry("Enhanced Continuous RT Image Storage", "EnhancedContinuousRTImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.481.25", UIDsDictionaryEntry("RT Patient Position Acquisition Instruction Storage", "RTPatientPositionAcquisitionInstructionStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.501.1", UIDsDictionaryEntry("DICOS CT Image Storage", "DICOSCTImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.501.2.1", UIDsDictionaryEntry("DICOS Digital X-Ray Image Storage - For Presentation", "DICOSDigitalXRayImageStorageForPresentation",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.501.2.2", UIDsDictionaryEntry("DICOS Digital X-Ray Image Storage - For Processing", "DICOSDigitalXRayImageStorageForProcessing",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.501.3", UIDsDictionaryEntry("DICOS Threat Detection Report Storage", "DICOSThreatDetectionReportStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.501.4", UIDsDictionaryEntry("DICOS 2D AIT Storage", "DICOS2DAITStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.501.5", UIDsDictionaryEntry("DICOS 3D AIT Storage", "DICOS3DAITStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.501.6", UIDsDictionaryEntry("DICOS Quadrupole Resonance (QR) Storage", "DICOSQuadrupoleResonanceStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.501.6", UIDsDictionaryEntry("DICOS Quadrupole Resonance (QR) Storage", "DICOSQuadrupoleResonanceQRStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.601.1", UIDsDictionaryEntry("Eddy Current Image Storage", "EddyCurrentImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.601.2", UIDsDictionaryEntry("Eddy Current Multi-frame Image Storage", "EddyCurrentMultiFrameImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.1.601.2", UIDsDictionaryEntry("Eddy Current Multi-frame Image Storage", "EddyCurrentMultiframeImageStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.1.1", UIDsDictionaryEntry("Patient Root Query/Retrieve Information Model - FIND", "PatientRootQueryRetrieveInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.1.1", UIDsDictionaryEntry("Patient Root Query/Retrieve Information Model - FIND", "PatientRootQueryRetrieveInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.1.2", UIDsDictionaryEntry("Patient Root Query/Retrieve Information Model - MOVE", "PatientRootQueryRetrieveInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.1.2", UIDsDictionaryEntry("Patient Root Query/Retrieve Information Model - MOVE", "PatientRootQueryRetrieveInformationModelMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.1.3", UIDsDictionaryEntry("Patient Root Query/Retrieve Information Model - GET", "PatientRootQueryRetrieveInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.1.3", UIDsDictionaryEntry("Patient Root Query/Retrieve Information Model - GET", "PatientRootQueryRetrieveInformationModelGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.2.1", UIDsDictionaryEntry("Study Root Query/Retrieve Information Model - FIND", "StudyRootQueryRetrieveInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.2.1", UIDsDictionaryEntry("Study Root Query/Retrieve Information Model - FIND", "StudyRootQueryRetrieveInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.2.2", UIDsDictionaryEntry("Study Root Query/Retrieve Information Model - MOVE", "StudyRootQueryRetrieveInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.2.2", UIDsDictionaryEntry("Study Root Query/Retrieve Information Model - MOVE", "StudyRootQueryRetrieveInformationModelMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.2.3", UIDsDictionaryEntry("Study Root Query/Retrieve Information Model - GET", "StudyRootQueryRetrieveInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.2.3", UIDsDictionaryEntry("Study Root Query/Retrieve Information Model - GET", "StudyRootQueryRetrieveInformationModelGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.3.1", UIDsDictionaryEntry("Patient/Study Only Query/Retrieve Information Model - FIND (Retired)", "PatientStudyOnlyQueryRetrieveInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.3.1", UIDsDictionaryEntry("Patient/Study Only Query/Retrieve Information Model - FIND (Retired)", "PatientStudyOnlyQueryRetrieveInformationModelFIND_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.3.2", UIDsDictionaryEntry("Patient/Study Only Query/Retrieve Information Model - MOVE (Retired)", "PatientStudyOnlyQueryRetrieveInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.3.2", UIDsDictionaryEntry("Patient/Study Only Query/Retrieve Information Model - MOVE (Retired)", "PatientStudyOnlyQueryRetrieveInformationModelMOVE_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.3.3", UIDsDictionaryEntry("Patient/Study Only Query/Retrieve Information Model - GET (Retired)", "PatientStudyOnlyQueryRetrieveInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.3.3", UIDsDictionaryEntry("Patient/Study Only Query/Retrieve Information Model - GET (Retired)", "PatientStudyOnlyQueryRetrieveInformationModelGET_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.4.2", UIDsDictionaryEntry("Composite Instance Root Retrieve - MOVE", "CompositeInstanceRootRetrieveMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.4.2", UIDsDictionaryEntry("Composite Instance Root Retrieve - MOVE", "CompositeInstanceRootRetrieveMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.4.3", UIDsDictionaryEntry("Composite Instance Root Retrieve - GET", "CompositeInstanceRootRetrieveGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.4.3", UIDsDictionaryEntry("Composite Instance Root Retrieve - GET", "CompositeInstanceRootRetrieveGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.5.3", UIDsDictionaryEntry("Composite Instance Retrieve Without Bulk Data - GET", "CompositeInstanceRetrieveWithoutBulkDataGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.1.2.5.3", UIDsDictionaryEntry("Composite Instance Retrieve Without Bulk Data - GET", "CompositeInstanceRetrieveWithoutBulkDataGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.20.1", UIDsDictionaryEntry("Defined Procedure Protocol Information Model - FIND", "DefinedProcedureProtocolInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.20.1", UIDsDictionaryEntry("Defined Procedure Protocol Information Model - FIND", "DefinedProcedureProtocolInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.20.2", UIDsDictionaryEntry("Defined Procedure Protocol Information Model - MOVE", "DefinedProcedureProtocolInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.20.2", UIDsDictionaryEntry("Defined Procedure Protocol Information Model - MOVE", "DefinedProcedureProtocolInformationModelMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.20.3", UIDsDictionaryEntry("Defined Procedure Protocol Information Model - GET", "DefinedProcedureProtocolInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.20.3", UIDsDictionaryEntry("Defined Procedure Protocol Information Model - GET", "DefinedProcedureProtocolInformationModelGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.31", UIDsDictionaryEntry("Modality Worklist Information Model - FIND", "ModalityWorklistInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.31", UIDsDictionaryEntry("Modality Worklist Information Model - FIND", "ModalityWorklistInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.32", UIDsDictionaryEntry("General Purpose Worklist Management Meta SOP Class (Retired)", "GeneralPurposeWorklistManagementMeta",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.32", UIDsDictionaryEntry("General Purpose Worklist Management Meta SOP Class (Retired)", "GeneralPurposeWorklistManagementMetaSOPClass_Retired",  "Meta SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.32.1", UIDsDictionaryEntry("General Purpose Worklist Information Model - FIND (Retired)", "GeneralPurposeWorklistInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.32.1", UIDsDictionaryEntry("General Purpose Worklist Information Model - FIND (Retired)", "GeneralPurposeWorklistInformationModelFIND_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.32.2", UIDsDictionaryEntry("General Purpose Scheduled Procedure Step SOP Class (Retired)", "GeneralPurposeScheduledProcedureStep",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.32.2", UIDsDictionaryEntry("General Purpose Scheduled Procedure Step SOP Class (Retired)", "GeneralPurposeScheduledProcedureStepSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.32.3", UIDsDictionaryEntry("General Purpose Performed Procedure Step SOP Class (Retired)", "GeneralPurposePerformedProcedureStep",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.32.3", UIDsDictionaryEntry("General Purpose Performed Procedure Step SOP Class (Retired)", "GeneralPurposePerformedProcedureStepSOPClass_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.33", UIDsDictionaryEntry("Instance Availability Notification SOP Class", "InstanceAvailabilityNotification",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.33", UIDsDictionaryEntry("Instance Availability Notification SOP Class", "InstanceAvailabilityNotificationSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.1", UIDsDictionaryEntry("RT Beams Delivery Instruction Storage - Trial (Retired)", "RTBeamsDeliveryInstructionStorageTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.1", UIDsDictionaryEntry("RT Beams Delivery Instruction Storage - Trial (Retired)", "RTBeamsDeliveryInstructionStorageTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.2", UIDsDictionaryEntry("RT Conventional Machine Verification - Trial (Retired)", "RTConventionalMachineVerificationTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.2", UIDsDictionaryEntry("RT Conventional Machine Verification - Trial (Retired)", "RTConventionalMachineVerificationTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.3", UIDsDictionaryEntry("RT Ion Machine Verification - Trial (Retired)", "RTIonMachineVerificationTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.3", UIDsDictionaryEntry("RT Ion Machine Verification - Trial (Retired)", "RTIonMachineVerificationTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4", UIDsDictionaryEntry("Unified Worklist and Procedure Step Service Class - Trial (Retired)", "UnifiedWorklistAndProcedureStepTrial",  "Service Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4", UIDsDictionaryEntry("Unified Worklist and Procedure Step Service Class - Trial (Retired)", "UnifiedWorklistandProcedureStepServiceClassTrial_Retired",  "Service Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4.1", UIDsDictionaryEntry("Unified Procedure Step - Push SOP Class - Trial (Retired)", "UnifiedProcedureStepPushTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4.1", UIDsDictionaryEntry("Unified Procedure Step - Push SOP Class - Trial (Retired)", "UnifiedProcedureStepPushSOPClassTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4.2", UIDsDictionaryEntry("Unified Procedure Step - Watch SOP Class - Trial (Retired)", "UnifiedProcedureStepWatchTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4.2", UIDsDictionaryEntry("Unified Procedure Step - Watch SOP Class - Trial (Retired)", "UnifiedProcedureStepWatchSOPClassTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4.3", UIDsDictionaryEntry("Unified Procedure Step - Pull SOP Class - Trial (Retired)", "UnifiedProcedureStepPullTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4.3", UIDsDictionaryEntry("Unified Procedure Step - Pull SOP Class - Trial (Retired)", "UnifiedProcedureStepPullSOPClassTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4.4", UIDsDictionaryEntry("Unified Procedure Step - Event SOP Class - Trial (Retired)", "UnifiedProcedureStepEventTrial",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.4.4", UIDsDictionaryEntry("Unified Procedure Step - Event SOP Class - Trial (Retired)", "UnifiedProcedureStepEventSOPClassTrial_Retired",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.5", UIDsDictionaryEntry("UPS Global Subscription SOP Instance", "UPSGlobalSubscriptionInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.5", UIDsDictionaryEntry("UPS Global Subscription SOP Instance", "UPSGlobalSubscriptionSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.5.1", UIDsDictionaryEntry("UPS Filtered Global Subscription SOP Instance", "UPSFilteredGlobalSubscriptionInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.5.1", UIDsDictionaryEntry("UPS Filtered Global Subscription SOP Instance", "UPSFilteredGlobalSubscriptionSOPInstance",  "Well-known SOP Instance"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6", UIDsDictionaryEntry("Unified Worklist and Procedure Step Service Class", "UnifiedWorklistAndProcedureStep",  "Service Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6", UIDsDictionaryEntry("Unified Worklist and Procedure Step Service Class", "UnifiedWorklistandProcedureStepServiceClass",  "Service Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.1", UIDsDictionaryEntry("Unified Procedure Step - Push SOP Class", "UnifiedProcedureStepPush",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.1", UIDsDictionaryEntry("Unified Procedure Step - Push SOP Class", "UnifiedProcedureStepPushSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.2", UIDsDictionaryEntry("Unified Procedure Step - Watch SOP Class", "UnifiedProcedureStepWatch",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.2", UIDsDictionaryEntry("Unified Procedure Step - Watch SOP Class", "UnifiedProcedureStepWatchSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.3", UIDsDictionaryEntry("Unified Procedure Step - Pull SOP Class", "UnifiedProcedureStepPull",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.3", UIDsDictionaryEntry("Unified Procedure Step - Pull SOP Class", "UnifiedProcedureStepPullSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.4", UIDsDictionaryEntry("Unified Procedure Step - Event SOP Class", "UnifiedProcedureStepEvent",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.4", UIDsDictionaryEntry("Unified Procedure Step - Event SOP Class", "UnifiedProcedureStepEventSOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.5", UIDsDictionaryEntry("Unified Procedure Step - Query SOP Class", "UnifiedProcedureStepQuery",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.6.5", UIDsDictionaryEntry("Unified Procedure Step - Query SOP Class", "UnifiedProcedureStepQuerySOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.7", UIDsDictionaryEntry("RT Beams Delivery Instruction Storage", "RTBeamsDeliveryInstructionStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.8", UIDsDictionaryEntry("RT Conventional Machine Verification", "RTConventionalMachineVerification",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.9", UIDsDictionaryEntry("RT Ion Machine Verification", "RTIonMachineVerification",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.34.10", UIDsDictionaryEntry("RT Brachy Application Setup Delivery Instruction Storage", "RTBrachyApplicationSetupDeliveryInstructionStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.37.1", UIDsDictionaryEntry("General Relevant Patient Information Query", "GeneralRelevantPatientInformationQuery",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.37.2", UIDsDictionaryEntry("Breast Imaging Relevant Patient Information Query", "BreastImagingRelevantPatientInformationQuery",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.37.3", UIDsDictionaryEntry("Cardiac Relevant Patient Information Query", "CardiacRelevantPatientInformationQuery",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.38.1", UIDsDictionaryEntry("Hanging Protocol Storage", "HangingProtocolStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.38.2", UIDsDictionaryEntry("Hanging Protocol Information Model - FIND", "HangingProtocolInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.38.2", UIDsDictionaryEntry("Hanging Protocol Information Model - FIND", "HangingProtocolInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.38.3", UIDsDictionaryEntry("Hanging Protocol Information Model - MOVE", "HangingProtocolInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.38.3", UIDsDictionaryEntry("Hanging Protocol Information Model - MOVE", "HangingProtocolInformationModelMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.38.4", UIDsDictionaryEntry("Hanging Protocol Information Model - GET", "HangingProtocolInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.38.4", UIDsDictionaryEntry("Hanging Protocol Information Model - GET", "HangingProtocolInformationModelGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.39.1", UIDsDictionaryEntry("Color Palette Storage", "ColorPaletteStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.39.2", UIDsDictionaryEntry("Color Palette Query/Retrieve Information Model - FIND", "ColorPaletteQueryRetrieveInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.39.2", UIDsDictionaryEntry("Color Palette Query/Retrieve Information Model - FIND", "ColorPaletteQueryRetrieveInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.39.3", UIDsDictionaryEntry("Color Palette Query/Retrieve Information Model - MOVE", "ColorPaletteQueryRetrieveInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.39.3", UIDsDictionaryEntry("Color Palette Query/Retrieve Information Model - MOVE", "ColorPaletteQueryRetrieveInformationModelMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.39.4", UIDsDictionaryEntry("Color Palette Query/Retrieve Information Model - GET", "ColorPaletteQueryRetrieveInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.39.4", UIDsDictionaryEntry("Color Palette Query/Retrieve Information Model - GET", "ColorPaletteQueryRetrieveInformationModelGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.41", UIDsDictionaryEntry("Product Characteristics Query SOP Class", "ProductCharacteristicsQuery",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.41", UIDsDictionaryEntry("Product Characteristics Query SOP Class", "ProductCharacteristicsQuerySOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.42", UIDsDictionaryEntry("Substance Approval Query SOP Class", "SubstanceApprovalQuery",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.42", UIDsDictionaryEntry("Substance Approval Query SOP Class", "SubstanceApprovalQuerySOPClass",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.43.1", UIDsDictionaryEntry("Generic Implant Template Storage", "GenericImplantTemplateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.43.2", UIDsDictionaryEntry("Generic Implant Template Information Model - FIND", "GenericImplantTemplateInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.43.2", UIDsDictionaryEntry("Generic Implant Template Information Model - FIND", "GenericImplantTemplateInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.43.3", UIDsDictionaryEntry("Generic Implant Template Information Model - MOVE", "GenericImplantTemplateInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.43.3", UIDsDictionaryEntry("Generic Implant Template Information Model - MOVE", "GenericImplantTemplateInformationModelMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.43.4", UIDsDictionaryEntry("Generic Implant Template Information Model - GET", "GenericImplantTemplateInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.43.4", UIDsDictionaryEntry("Generic Implant Template Information Model - GET", "GenericImplantTemplateInformationModelGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.44.1", UIDsDictionaryEntry("Implant Assembly Template Storage", "ImplantAssemblyTemplateStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.44.2", UIDsDictionaryEntry("Implant Assembly Template Information Model - FIND", "ImplantAssemblyTemplateInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.44.2", UIDsDictionaryEntry("Implant Assembly Template Information Model - FIND", "ImplantAssemblyTemplateInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.44.3", UIDsDictionaryEntry("Implant Assembly Template Information Model - MOVE", "ImplantAssemblyTemplateInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.44.3", UIDsDictionaryEntry("Implant Assembly Template Information Model - MOVE", "ImplantAssemblyTemplateInformationModelMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.44.4", UIDsDictionaryEntry("Implant Assembly Template Information Model - GET", "ImplantAssemblyTemplateInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.44.4", UIDsDictionaryEntry("Implant Assembly Template Information Model - GET", "ImplantAssemblyTemplateInformationModelGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.45.1", UIDsDictionaryEntry("Implant Template Group Storage", "ImplantTemplateGroupStorage",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.45.2", UIDsDictionaryEntry("Implant Template Group Information Model - FIND", "ImplantTemplateGroupInformationModelFind",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.45.2", UIDsDictionaryEntry("Implant Template Group Information Model - FIND", "ImplantTemplateGroupInformationModelFIND",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.45.3", UIDsDictionaryEntry("Implant Template Group Information Model - MOVE", "ImplantTemplateGroupInformationModelMove",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.45.3", UIDsDictionaryEntry("Implant Template Group Information Model - MOVE", "ImplantTemplateGroupInformationModelMOVE",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.45.4", UIDsDictionaryEntry("Implant Template Group Information Model - GET", "ImplantTemplateGroupInformationModelGet",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.5.1.4.45.4", UIDsDictionaryEntry("Implant Template Group Information Model - GET", "ImplantTemplateGroupInformationModelGET",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.7.1.1", UIDsDictionaryEntry("Native DICOM Model", "NativeDICOMModel",  "Application Hosting Model"));
    uids_dictionary.emplace("1.2.840.10008.7.1.2", UIDsDictionaryEntry("Abstract Multi-Dimensional Image Model", "AbstractMultiDimensionalImageModel",  "Application Hosting Model"));
    uids_dictionary.emplace("1.2.840.10008.8.1.1", UIDsDictionaryEntry("DICOM Content Mapping Resource", "DICOMContentMappingResource",  "Mapping Resource"));
    uids_dictionary.emplace("1.2.840.10008.10.1", UIDsDictionaryEntry("Video Endoscopic Image Real-Time Communication", "VideoEndoscopicImageRealTimeCommunication",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.10.2", UIDsDictionaryEntry("Video Photographic Image Real-Time Communication", "VideoPhotographicImageRealTimeCommunication",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.10.3", UIDsDictionaryEntry("Audio Waveform Real-Time Communication", "AudioWaveformRealTimeCommunication",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.10.4", UIDsDictionaryEntry("Rendition Selection Document Real-Time Communication", "RenditionSelectionDocumentRealTimeCommunication",  "SOP Class"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.1", UIDsDictionaryEntry("dicomDeviceName", "dicomDeviceName",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.2", UIDsDictionaryEntry("dicomDescription", "dicomDescription",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.3", UIDsDictionaryEntry("dicomManufacturer", "dicomManufacturer",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.4", UIDsDictionaryEntry("dicomManufacturerModelName", "dicomManufacturerModelName",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.5", UIDsDictionaryEntry("dicomSoftwareVersion", "dicomSoftwareVersion",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.6", UIDsDictionaryEntry("dicomVendorData", "dicomVendorData",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.7", UIDsDictionaryEntry("dicomAETitle", "dicomAETitle",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.8", UIDsDictionaryEntry("dicomNetworkConnectionReference", "dicomNetworkConnectionReference",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.9", UIDsDictionaryEntry("dicomApplicationCluster", "dicomApplicationCluster",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.10", UIDsDictionaryEntry("dicomAssociationInitiator", "dicomAssociationInitiator",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.11", UIDsDictionaryEntry("dicomAssociationAcceptor", "dicomAssociationAcceptor",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.12", UIDsDictionaryEntry("dicomHostname", "dicomHostname",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.13", UIDsDictionaryEntry("dicomPort", "dicomPort",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.14", UIDsDictionaryEntry("dicomSOPClass", "dicomSOPClass",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.15", UIDsDictionaryEntry("dicomTransferRole", "dicomTransferRole",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.16", UIDsDictionaryEntry("dicomTransferSyntax", "dicomTransferSyntax",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.17", UIDsDictionaryEntry("dicomPrimaryDeviceType", "dicomPrimaryDeviceType",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.18", UIDsDictionaryEntry("dicomRelatedDeviceReference", "dicomRelatedDeviceReference",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.19", UIDsDictionaryEntry("dicomPreferredCalledAETitle", "dicomPreferredCalledAETitle",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.20", UIDsDictionaryEntry("dicomTLSCyphersuite", "dicomTLSCyphersuite",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.21", UIDsDictionaryEntry("dicomAuthorizedNodeCertificateReference", "dicomAuthorizedNodeCertificateReference",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.22", UIDsDictionaryEntry("dicomThisNodeCertificateReference", "dicomThisNodeCertificateReference",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.23", UIDsDictionaryEntry("dicomInstalled", "dicomInstalled",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.24", UIDsDictionaryEntry("dicomStationName", "dicomStationName",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.25", UIDsDictionaryEntry("dicomDeviceSerialNumber", "dicomDeviceSerialNumber",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.26", UIDsDictionaryEntry("dicomInstitutionName", "dicomInstitutionName",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.27", UIDsDictionaryEntry("dicomInstitutionAddress", "dicomInstitutionAddress",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.28", UIDsDictionaryEntry("dicomInstitutionDepartmentName", "dicomInstitutionDepartmentName",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.29", UIDsDictionaryEntry("dicomIssuerOfPatientID", "dicomIssuerOfPatientID",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.30", UIDsDictionaryEntry("dicomPreferredCallingAETitle", "dicomPreferredCallingAETitle",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.3.31", UIDsDictionaryEntry("dicomSupportedCharacterSet", "dicomSupportedCharacterSet",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.4.1", UIDsDictionaryEntry("dicomConfigurationRoot", "dicomConfigurationRoot",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.4.2", UIDsDictionaryEntry("dicomDevicesRoot", "dicomDevicesRoot",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.4.3", UIDsDictionaryEntry("dicomUniqueAETitlesRegistryRoot", "dicomUniqueAETitlesRegistryRoot",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.4.4", UIDsDictionaryEntry("dicomDevice", "dicomDevice",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.4.5", UIDsDictionaryEntry("dicomNetworkAE", "dicomNetworkAE",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.4.6", UIDsDictionaryEntry("dicomNetworkConnection", "dicomNetworkConnection",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.4.7", UIDsDictionaryEntry("dicomUniqueAETitle", "dicomUniqueAETitle",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.0.4.8", UIDsDictionaryEntry("dicomTransferCapability", "dicomTransferCapability",  "LDAP OID"));
    uids_dictionary.emplace("1.2.840.10008.15.1.1", UIDsDictionaryEntry("Universal Coordinated Time", "UTC",  "Synchronization Frame of Reference"));
    uids_dictionary.emplace("1.2.840.10008.15.1.1", UIDsDictionaryEntry("Universal Coordinated Time", "UniversalCoordinatedTime",  "Synchronization Frame of Reference"));
}

bool update(
    odil::ElementsDictionary & public_dictionary,
    std::map<std::string, odil::Tag> & public_tags,
    odil::UIDsDictionary & uids_dictionary)
{
    update_0000(public_dictionary, public_tags);
    update_0002(public_dictionary, public_tags);
    update_0004(public_dictionary, public_tags);
    update_0008(public_dictionary, public_tags);
    update_0010(public_dictionary, public_tags);
    update_0012(public_dictionary, public_tags);
    update_0014(public_dictionary, public_tags);
    update_0016(public_dictionary, public_tags);
    update_0018(public_dictionary, public_tags);
    update_0020(public_dictionary, public_tags);
    update_misc(public_dictionary, public_tags);
    update_0022(public_dictionary, public_tags);
    update_0024(public_dictionary, public_tags);
    update_0028(public_dictionary, public_tags);
    update_0032(public_dictionary, public_tags);
    update_0034(public_dictionary, public_tags);
    update_0038(public_dictionary, public_tags);
    update_003a(public_dictionary, public_tags);
    update_0040(public_dictionary, public_tags);
    update_0042(public_dictionary, public_tags);
    update_0044(public_dictionary, public_tags);
    update_0046(public_dictionary, public_tags);
    update_0048(public_dictionary, public_tags);
    update_0050(public_dictionary, public_tags);
    update_0052(public_dictionary, public_tags);
    update_0054(public_dictionary, public_tags);
    update_0060(public_dictionary, public_tags);
    update_0062(public_dictionary, public_tags);
    update_0064(public_dictionary, public_tags);
    update_0066(public_dictionary, public_tags);
    update_0068(public_dictionary, public_tags);
    update_006a(public_dictionary, public_tags);
    update_0070(public_dictionary, public_tags);
    update_0072(public_dictionary, public_tags);
    update_0074(public_dictionary, public_tags);
    update_0076(public_dictionary, public_tags);
    update_0078(public_dictionary, public_tags);
    update_0080(public_dictionary, public_tags);
    update_0082(public_dictionary, public_tags);
    update_0088(public_dictionary, public_tags);
    update_0100(public_dictionary, public_tags);
    update_0400(public_dictionary, public_tags);
    update_2000(public_dictionary, public_tags);
    update_2010(public_dictionary, public_tags);
    update_2020(public_dictionary, public_tags);
    update_2030(public_dictionary, public_tags);
    update_2040(public_dictionary, public_tags);
    update_2050(public_dictionary, public_tags);
    update_2100(public_dictionary, public_tags);
    update_2110(public_dictionary, public_tags);
    update_2120(public_dictionary, public_tags);
    update_2130(public_dictionary, public_tags);
    update_2200(public_dictionary, public_tags);
    update_3002(public_dictionary, public_tags);
    update_3004(public_dictionary, public_tags);
    update_3006(public_dictionary, public_tags);
    update_3008(public_dictionary, public_tags);
    update_300a(public_dictionary, public_tags);
    update_300c(public_dictionary, public_tags);
    update_300e(public_dictionary, public_tags);
    update_3010(public_dictionary, public_tags);
    update_4000(public_dictionary, public_tags);
    update_4008(public_dictionary, public_tags);
    update_4010(public_dictionary, public_tags);
    update_4ffe(public_dictionary, public_tags);
    update_5200(public_dictionary, public_tags);
    update_5400(public_dictionary, public_tags);
    update_5600(public_dictionary, public_tags);
    update_7fe0(public_dictionary, public_tags);
    update_fffa(public_dictionary, public_tags);
    update_fffc(public_dictionary, public_tags);
    update_fffe(public_dictionary, public_tags);

    update_uids_dictionary(uids_dictionary);

    return true;
}

}

}

odil::ElementsDictionary odil::registry::public_dictionary = {};
std::map<std::string, odil::Tag> odil::registry::public_tags = {};
odil::UIDsDictionary odil::registry::uids_dictionary = {};
bool const odil::registry::dummy = odil::registry::update(
    odil::registry::public_dictionary,
    odil::registry::public_tags,
    odil::registry::uids_dictionary);