/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.planner.spi;

import java.io.Serializable;
import org.neo4j.cypher.internal.planner.spi.CardinalityByLabelsAndRelationshipType;
import org.neo4j.cypher.internal.planner.spi.DivergenceState;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.GraphStatisticsSnapshot$;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexPropertyExistsSelectivity;
import org.neo4j.cypher.internal.planner.spi.IndexSelectivity;
import org.neo4j.cypher.internal.planner.spi.InstrumentedGraphStatistics;
import org.neo4j.cypher.internal.planner.spi.MutableGraphStatisticsSnapshot;
import org.neo4j.cypher.internal.planner.spi.MutableGraphStatisticsSnapshot$;
import org.neo4j.cypher.internal.planner.spi.NodesAllCardinality$;
import org.neo4j.cypher.internal.planner.spi.NodesWithLabelCardinality;
import org.neo4j.cypher.internal.planner.spi.StatisticsKey;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.Selectivity;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u000e\u0001\u0003\u0016\u0004%\t!\u000e\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005m!)\u0011\n\u0001C\u0001\u0015\")Q\n\u0001C\u0001\u001d\")A\u000b\u0001C\u0001+\"91\fAA\u0001\n\u0003a\u0006b\u00020\u0001#\u0003%\ta\u0018\u0005\bU\u0002\t\t\u0011\"\u0011l\u0011\u001d!\b!!A\u0005\u0002UDq!\u001f\u0001\u0002\u0002\u0013\u0005!\u0010C\u0005\u0002\u0002\u0001\t\t\u0011\"\u0011\u0002\u0004!I\u0011\u0011\u0003\u0001\u0002\u0002\u0013\u0005\u00111\u0003\u0005\n\u0003;\u0001\u0011\u0011!C!\u0003?A\u0011\"!\t\u0001\u0003\u0003%\t%a\t\t\u0013\u0005\u0015\u0002!!A\u0005B\u0005\u001dr!CA\u00165\u0005\u0005\t\u0012AA\u0017\r!I\"$!A\t\u0002\u0005=\u0002BB%\u0012\t\u0003\ti\u0004C\u0005\u0002\"E\t\t\u0011\"\u0012\u0002$!I\u0011qH\t\u0002\u0002\u0013\u0005\u0015\u0011\t\u0005\t\u0003\u000b\n\u0012\u0013!C\u0001?\"I\u0011qI\t\u0002\u0002\u0013\u0005\u0015\u0011\n\u0005\t\u0003+\n\u0012\u0013!C\u0001?\"I\u0011qK\t\u0002\u0002\u0013%\u0011\u0011\f\u0002\u0018\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dgNs\u0017\r]:i_RT!a\u0007\u000f\u0002\u0007M\u0004\u0018N\u0003\u0002\u001e=\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0010!\u0003!Ig\u000e^3s]\u0006d'BA\u0011#\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u00111\u0005J\u0001\u0006]\u0016|GG\u001b\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u000b\u00182!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fMB\u0011\u0011fL\u0005\u0003a)\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002*e%\u00111G\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\fgR\fGo\u001d,bYV,7/F\u00017!\u00119d(Q#\u000f\u0005ab\u0004CA\u001d+\u001b\u0005Q$BA\u001e'\u0003\u0019a$o\\8u}%\u0011QHK\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%aA'ba*\u0011QH\u000b\t\u0003\u0005\u000ek\u0011AG\u0005\u0003\tj\u0011Qb\u0015;bi&\u001cH/[2t\u0017\u0016L\bCA\u0015G\u0013\t9%F\u0001\u0004E_V\u0014G.Z\u0001\rgR\fGo\u001d,bYV,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-c\u0005C\u0001\"\u0001\u0011\u001d!4\u0001%AA\u0002Y\n\u0011B]3d_6\u0004X\u000f^3\u0015\u0005-{\u0005\"\u0002)\u0005\u0001\u0004\t\u0016AC:uCRL7\u000f^5dgB\u0011!IU\u0005\u0003'j\u0011qb\u0012:ba\"\u001cF/\u0019;jgRL7m]\u0001\tI&4XM]4fgR\u0011a+\u0017\t\u0003\u0005^K!\u0001\u0017\u000e\u0003\u001f\u0011Kg/\u001a:hK:\u001cWm\u0015;bi\u0016DQAW\u0003A\u0002-\u000b\u0001b\u001d8baNDw\u000e^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002L;\"9AG\u0002I\u0001\u0002\u00041\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002A*\u0012a'Y\u0016\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u001a\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002jI\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005a\u0007CA7s\u001b\u0005q'BA8q\u0003\u0011a\u0017M\\4\u000b\u0003E\fAA[1wC&\u00111O\u001c\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003Y\u0004\"!K<\n\u0005aT#aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HCA>\u007f!\tIC0\u0003\u0002~U\t\u0019\u0011I\\=\t\u000f}T\u0011\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0002\u0011\u000b\u0005\u001d\u0011QB>\u000e\u0005\u0005%!bAA\u0006U\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0011\u0011\u0002\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0016\u0005m\u0001cA\u0015\u0002\u0018%\u0019\u0011\u0011\u0004\u0016\u0003\u000f\t{w\u000e\\3b]\"9q\u0010DA\u0001\u0002\u0004Y\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003Y\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002Y\u00061Q-];bYN$B!!\u0006\u0002*!9qpDA\u0001\u0002\u0004Y\u0018aF$sCBD7\u000b^1uSN$\u0018nY:T]\u0006\u00048\u000f[8u!\t\u0011\u0015c\u0005\u0003\u0012\u0003c\t\u0004CBA\u001a\u0003s14*\u0004\u0002\u00026)\u0019\u0011q\u0007\u0016\u0002\u000fI,h\u000e^5nK&!\u00111HA\u001b\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003[\tQ!\u00199qYf$2aSA\"\u0011\u001d!D\u0003%AA\u0002Y\nq\"\u00199qYf$C-\u001a4bk2$H%M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY%!\u0015\u0011\t%\niEN\u0005\u0004\u0003\u001fR#AB(qi&|g\u000e\u0003\u0005\u0002TY\t\t\u00111\u0001L\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00037\u00022!\\A/\u0013\r\tyF\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class GraphStatisticsSnapshot
implements Product,
scala.Serializable {
    private final Map<StatisticsKey, Object> statsValues;

    public static Map<StatisticsKey, Object> $lessinit$greater$default$1() {
        return GraphStatisticsSnapshot$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Map<StatisticsKey, Object>> unapply(GraphStatisticsSnapshot graphStatisticsSnapshot) {
        return GraphStatisticsSnapshot$.MODULE$.unapply(graphStatisticsSnapshot);
    }

    public static Map<StatisticsKey, Object> apply$default$1() {
        return GraphStatisticsSnapshot$.MODULE$.apply$default$1();
    }

    public static GraphStatisticsSnapshot apply(Map<StatisticsKey, Object> map) {
        return GraphStatisticsSnapshot$.MODULE$.apply(map);
    }

    public static <A> Function1<Map<StatisticsKey, Object>, A> andThen(Function1<GraphStatisticsSnapshot, A> function1) {
        return GraphStatisticsSnapshot$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, GraphStatisticsSnapshot> compose(Function1<A, Map<StatisticsKey, Object>> function1) {
        return GraphStatisticsSnapshot$.MODULE$.compose(function1);
    }

    public Map<StatisticsKey, Object> statsValues() {
        return this.statsValues;
    }

    public GraphStatisticsSnapshot recompute(GraphStatistics statistics) {
        MutableGraphStatisticsSnapshot snapshot = new MutableGraphStatisticsSnapshot(MutableGraphStatisticsSnapshot$.MODULE$.$lessinit$greater$default$1());
        InstrumentedGraphStatistics instrumented = new InstrumentedGraphStatistics(statistics, snapshot);
        this.statsValues().keys().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Option<Selectivity> option;
            StatisticsKey statisticsKey = x0$1;
            if (statisticsKey instanceof NodesWithLabelCardinality) {
                NodesWithLabelCardinality nodesWithLabelCardinality = (NodesWithLabelCardinality)statisticsKey;
                Option<LabelId> labelId = nodesWithLabelCardinality.labelId();
                option = instrumented.nodesWithLabelCardinality(labelId);
            } else if (NodesAllCardinality$.MODULE$.equals(statisticsKey)) {
                option = instrumented.nodesAllCardinality();
            } else if (statisticsKey instanceof CardinalityByLabelsAndRelationshipType) {
                CardinalityByLabelsAndRelationshipType cardinalityByLabelsAndRelationshipType = (CardinalityByLabelsAndRelationshipType)statisticsKey;
                Option<LabelId> lhs = cardinalityByLabelsAndRelationshipType.lhs();
                Option<RelTypeId> relType = cardinalityByLabelsAndRelationshipType.relType();
                Option<LabelId> rhs = cardinalityByLabelsAndRelationshipType.rhs();
                option = instrumented.patternStepCardinality(lhs, relType, rhs);
            } else if (statisticsKey instanceof IndexSelectivity) {
                IndexSelectivity indexSelectivity = (IndexSelectivity)statisticsKey;
                IndexDescriptor index = indexSelectivity.index();
                option = instrumented.uniqueValueSelectivity(index);
            } else if (statisticsKey instanceof IndexPropertyExistsSelectivity) {
                IndexPropertyExistsSelectivity indexPropertyExistsSelectivity = (IndexPropertyExistsSelectivity)statisticsKey;
                IndexDescriptor index = indexPropertyExistsSelectivity.index();
                option = instrumented.indexPropertyIsNotNullSelectivity(index);
            } else {
                throw new MatchError((Object)statisticsKey);
            }
            return option;
        });
        return snapshot.freeze();
    }

    public DivergenceState diverges(GraphStatisticsSnapshot snapshot) {
        Set set = this.statsValues().keySet();
        Set set2 = snapshot.statsValues().keySet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null));
        Tuple4 tuple4 = (Tuple4)((TraversableOnce)this.statsValues().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double e2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StatisticsKey k = (StatisticsKey)tuple2._1();
            double e1 = tuple2._2$mcD$sp();
            double divergence = Math.abs(e1 - (e2 = BoxesRunTime.unboxToDouble((Object)snapshot.statsValues().apply((Object)k)))) / Math.max(e1, e2);
            Tuple4 tuple4 = Double.isNaN(divergence) ? new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)k, (Object)BoxesRunTime.boxToDouble((double)e1), (Object)BoxesRunTime.boxToDouble((double)e2)) : new Tuple4((Object)BoxesRunTime.boxToDouble((double)divergence), (Object)k, (Object)BoxesRunTime.boxToDouble((double)e1), (Object)BoxesRunTime.boxToDouble((double)e2));
            return tuple4;
        }, Iterable$.MODULE$.canBuildFrom())).maxBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)GraphStatisticsSnapshot.$anonfun$diverges$2(x$1)), (Ordering)Ordering.Double$.MODULE$);
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        double divergedStats = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        StatisticsKey divergedStatKey = (StatisticsKey)tuple4._2();
        double before = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double after = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)divergedStats), (Object)divergedStatKey, (Object)BoxesRunTime.boxToDouble((double)before), (Object)BoxesRunTime.boxToDouble((double)after));
        Tuple4 tuple43 = tuple42;
        double divergedStats2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        StatisticsKey divergedStatKey2 = (StatisticsKey)tuple43._2();
        double before2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double after2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        return new DivergenceState(divergedStatKey2, divergedStats2, before2, after2);
    }

    public GraphStatisticsSnapshot copy(Map<StatisticsKey, Object> statsValues) {
        return new GraphStatisticsSnapshot(statsValues);
    }

    public Map<StatisticsKey, Object> copy$default$1() {
        return this.statsValues();
    }

    public String productPrefix() {
        return "GraphStatisticsSnapshot";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.statsValues();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GraphStatisticsSnapshot;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GraphStatisticsSnapshot)) return false;
        boolean bl = true;
        if (!bl) return false;
        GraphStatisticsSnapshot graphStatisticsSnapshot = (GraphStatisticsSnapshot)x$1;
        Map<StatisticsKey, Object> map = this.statsValues();
        Map<StatisticsKey, Object> map2 = graphStatisticsSnapshot.statsValues();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!graphStatisticsSnapshot.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ double $anonfun$diverges$2(Tuple4 x$1) {
        return BoxesRunTime.unboxToDouble((Object)x$1._1());
    }

    public GraphStatisticsSnapshot(Map<StatisticsKey, Object> statsValues) {
        this.statsValues = statsValues;
        Product.$init$((Product)this);
    }
}

