/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.load_csv;

import inet.ipaddr.IPAddressString;
import java.io.Serializable;
import java.net.URL;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.QueryStatistics;
import org.neo4j.cypher.internal.runtime.QueryStatistics$;
import org.neo4j.cypher.internal.runtime.ResourceManagedCursorPool;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.interpreted.load_csv.LoadCsvIteratorWithPeriodicCommit;
import org.neo4j.cypher.internal.runtime.interpreted.load_csv.UpdateCounter;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.Cursor;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001\u0002\n\u0014\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tg\u0001\u0011\t\u0011)A\u0005S!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u0003:\u0001\u0011\u0005!\bC\u0004A\u0001\t\u0007I\u0011A!\t\r\u0015\u0003\u0001\u0015!\u0003C\u0011\u001d1\u0005\u00011A\u0005\u0002\u001dCqA\u0014\u0001A\u0002\u0013\u0005q\n\u0003\u0004V\u0001\u0001\u0006K\u0001\u0013\u0005\u0006-\u0002!\te\u0016\u0005\n\u0003K\u0001\u0011\u0013!C\u0001\u0003OAq!!\u0010\u0001\t\u0013\ty\u0004C\u0004\u0002B\u0001!I!a\u0010\t\u0013\u0005\r\u0003\u00011A\u0005\n\u0005\u0015\u0003\"CA-\u0001\u0001\u0007I\u0011BA.\u0011!\ty\u0006\u0001Q!\n\u0005\u001d\u0003bBA1\u0001\u0011\u0005\u00131\r\u0002\u001e\u0019>\fGmQ:w!\u0016\u0014\u0018n\u001c3jG\u000e{W.\\5u\u001f\n\u001cXM\u001d<fe*\u0011A#F\u0001\tY>\fGmX2tm*\u0011acF\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002\u00193\u00059!/\u001e8uS6,'B\u0001\u000e\u001c\u0003!Ig\u000e^3s]\u0006d'B\u0001\u000f\u001e\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011adH\u0001\u0006]\u0016|GG\u001b\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g!\tQS&D\u0001,\u0015\taS#A\u0003qSB,7/\u0003\u0002/W\t\u0019R\t\u001f;fe:\fGnQ*W%\u0016\u001cx.\u001e:dK\u0006i!-\u0019;dQJ{woQ8v]R\u0004\"\u0001J\u0019\n\u0005I*#\u0001\u0002'p]\u001e\f\u0011B]3t_V\u00148-Z:\u0002\u0019E,XM]=D_:$X\r\u001f;\u0011\u0005Y:T\"A\f\n\u0005a:\"\u0001D)vKJL8i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\u0003<{yz\u0004C\u0001\u001f\u0001\u001b\u0005\u0019\u0002\"B\u0018\u0005\u0001\u0004\u0001\u0004\"B\u001a\u0005\u0001\u0004I\u0003\"\u0002\u001b\u0005\u0001\u0004)\u0014!D;qI\u0006$XmQ8v]R,'/F\u0001C!\ta4)\u0003\u0002E'\tiQ\u000b\u001d3bi\u0016\u001cu.\u001e8uKJ\fa\"\u001e9eCR,7i\\;oi\u0016\u0014\b%\u0001\u000bpkR,'\u000fT8bI\u000e\u001bf+\u0013;fe\u0006$xN]\u000b\u0002\u0011B\u0019A%S&\n\u0005)+#AB(qi&|g\u000e\u0005\u0002=\u0019&\u0011Qj\u0005\u0002\"\u0019>\fGmQ:w\u0013R,'/\u0019;pe^KG\u000f\u001b)fe&|G-[2D_6l\u0017\u000e^\u0001\u0019_V$XM\u001d'pC\u0012\u001c5KV%uKJ\fGo\u001c:`I\u0015\fHC\u0001)T!\t!\u0013+\u0003\u0002SK\t!QK\\5u\u0011\u001d!\u0006\"!AA\u0002!\u000b1\u0001\u001f\u00132\u0003UyW\u000f^3s\u0019>\fGmQ*W\u0013R,'/\u0019;pe\u0002\nabZ3u\u0007N4\u0018\n^3sCR|'\u000f\u0006\u0006Y7\u0016\\\u0018QBA\f\u0003C\u0001\"AK-\n\u0005i[#a\u0004'pC\u0012\u001c5O^%uKJ\fGo\u001c:\t\u000bqS\u0001\u0019A/\u0002\u0007U\u0014H\u000e\u0005\u0002_G6\tqL\u0003\u0002aC\u0006\u0019a.\u001a;\u000b\u0003\t\fAA[1wC&\u0011Am\u0018\u0002\u0004+Jc\u0005\"\u00024\u000b\u0001\u00049\u0017aC5q\u00052|7m\u001b7jgR\u00042\u0001\u001b9t\u001d\tIgN\u0004\u0002k[6\t1N\u0003\u0002mC\u00051AH]8pizJ\u0011AJ\u0005\u0003_\u0016\nq\u0001]1dW\u0006<W-\u0003\u0002re\n!A*[:u\u0015\tyW\u0005\u0005\u0002us6\tQO\u0003\u0002wo\u00061\u0011\u000e]1eIJT\u0011\u0001_\u0001\u0005S:,G/\u0003\u0002{k\ny\u0011\nU!eIJ,7o]*ue&tw\rC\u0003}\u0015\u0001\u0007Q0A\bgS\u0016dG\rV3s[&t\u0017\r^8s!\r!\u0013J \t\u0004\u007f\u0006\u001da\u0002BA\u0001\u0003\u0007\u0001\"A[\u0013\n\u0007\u0005\u0015Q%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000b)\u0003bBA\b\u0015\u0001\u0007\u0011\u0011C\u0001\u0017Y\u0016<\u0017mY=DgZ\fVo\u001c;f\u000bN\u001c\u0017\r]5oOB\u0019A%a\u0005\n\u0007\u0005UQEA\u0004C_>dW-\u00198\t\u000f\u0005e!\u00021\u0001\u0002\u001c\u0005Q!-\u001e4gKJ\u001c\u0016N_3\u0011\u0007\u0011\ni\"C\u0002\u0002 \u0015\u00121!\u00138u\u0011%\t\u0019C\u0003I\u0001\u0002\u0004\t\t\"A\u0004iK\u0006$WM]:\u00021\u001d,GoQ:w\u0013R,'/\u0019;pe\u0012\"WMZ1vYR$c'\u0006\u0002\u0002*)\"\u0011\u0011CA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001cK\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AB8o\u001d\u0016DH\u000fF\u0001Q\u0003I\u0019w.\\7ji\u0006sGMU3ti\u0006\u0014H\u000f\u0016=\u0002!=t7i\\7nSRD\u0015M\u001c3mKJ\u001cXCAA$!\u0019\tI%a\u0014\u0002T5\u0011\u00111\n\u0006\u0004\u0003\u001b*\u0013AC2pY2,7\r^5p]&!\u0011\u0011KA&\u0005\r\u0019V-\u001d\t\u0005I\u0005U\u0003+C\u0002\u0002X\u0015\u0012\u0011BR;oGRLwN\u001c\u0019\u0002)=t7i\\7nSRD\u0015M\u001c3mKJ\u001cx\fJ3r)\r\u0001\u0016Q\f\u0005\t)>\t\t\u00111\u0001\u0002H\u0005\trN\\\"p[6LG\u000fS1oI2,'o\u001d\u0011\u0002%M,(m]2sS\n,7i\\7nSR$X\r\u001a\u000b\u0004!\u0006\u0015\u0004bBA4#\u0001\u0007\u00111K\u0001\t_:\u001cu.\\7ji\u0002")
public class LoadCsvPeriodicCommitObserver
implements ExternalCSVResource {
    private final long batchRowCount;
    private final ExternalCSVResource resources;
    private final QueryContext queryContext;
    private final UpdateCounter updateCounter;
    private Option<LoadCsvIteratorWithPeriodicCommit> outerLoadCSVIterator;
    private Seq<Function0<BoxedUnit>> onCommitHandlers;

    public UpdateCounter updateCounter() {
        return this.updateCounter;
    }

    public Option<LoadCsvIteratorWithPeriodicCommit> outerLoadCSVIterator() {
        return this.outerLoadCSVIterator;
    }

    public void outerLoadCSVIterator_$eq(Option<LoadCsvIteratorWithPeriodicCommit> x$1) {
        this.outerLoadCSVIterator = x$1;
    }

    @Override
    public LoadCsvIterator getCsvIterator(URL url, List<IPAddressString> ipBlocklist, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize, boolean headers) {
        LoadCsvIterator loadCsvIterator;
        LoadCsvIterator innerIterator = this.resources.getCsvIterator(url, ipBlocklist, fieldTerminator, legacyCsvQuoteEscaping, bufferSize, headers);
        if (this.outerLoadCSVIterator().isEmpty()) {
            if (headers) {
                this.updateCounter().offsetForHeaders();
            }
            LoadCsvIteratorWithPeriodicCommit iterator = new LoadCsvIteratorWithPeriodicCommit(innerIterator, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.onNext());
            this.outerLoadCSVIterator_$eq((Option<LoadCsvIteratorWithPeriodicCommit>)new Some((Object)iterator));
            loadCsvIterator = iterator;
        } else {
            loadCsvIterator = innerIterator;
        }
        return loadCsvIterator;
    }

    @Override
    public boolean getCsvIterator$default$6() {
        return false;
    }

    private void onNext() {
        this.updateCounter().resetIfPastLimit(this.batchRowCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.commitAndRestartTx());
        this.updateCounter().$plus$eq(1L);
    }

    private void commitAndRestartTx() {
        ArrayBuffer trackedResources = new ArrayBuffer();
        ArrayBuffer cursorPools = new ArrayBuffer();
        this.queryContext.resources().allResources().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            AutoCloseablePlus autoCloseablePlus = x0$1;
            if (autoCloseablePlus instanceof Cursor) {
                Cursor cursor = (Cursor)autoCloseablePlus;
                cursor.closeInternal();
                boxedUnit = BoxedUnit.UNIT;
            } else if (autoCloseablePlus instanceof ResourceManagedCursorPool) {
                ResourceManagedCursorPool resourceManagedCursorPool = (ResourceManagedCursorPool)autoCloseablePlus;
                cursorPools.$plus$eq((Object)resourceManagedCursorPool);
                resourceManagedCursorPool.closeCursors();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = trackedResources.$plus$eq((Object)autoCloseablePlus);
            }
            return boxedUnit;
        });
        trackedResources.$plus$plus$eq((TraversableOnce)cursorPools);
        ResourceManager resourceManager = this.queryContext.resources();
        trackedResources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            resourceManager.untrace(resource);
            return BoxedUnit.UNIT;
        });
        this.queryContext.transactionalContext().commitAndRestartTx();
        int x$12 = 1;
        int x$22 = QueryStatistics$.MODULE$.apply$default$1();
        int x$32 = QueryStatistics$.MODULE$.apply$default$2();
        int x$4 = QueryStatistics$.MODULE$.apply$default$3();
        int x$5 = QueryStatistics$.MODULE$.apply$default$4();
        int x$6 = QueryStatistics$.MODULE$.apply$default$5();
        int x$7 = QueryStatistics$.MODULE$.apply$default$6();
        int x$8 = QueryStatistics$.MODULE$.apply$default$7();
        int x$9 = QueryStatistics$.MODULE$.apply$default$8();
        int x$10 = QueryStatistics$.MODULE$.apply$default$9();
        int x$11 = QueryStatistics$.MODULE$.apply$default$10();
        int x$122 = QueryStatistics$.MODULE$.apply$default$11();
        int x$13 = QueryStatistics$.MODULE$.apply$default$12();
        int x$14 = QueryStatistics$.MODULE$.apply$default$13();
        int x$15 = QueryStatistics$.MODULE$.apply$default$14();
        int x$16 = QueryStatistics$.MODULE$.apply$default$15();
        int x$17 = QueryStatistics$.MODULE$.apply$default$16();
        int x$18 = QueryStatistics$.MODULE$.apply$default$18();
        QueryStatistics statistics = new QueryStatistics(x$22, x$32, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$12, x$18);
        this.queryContext.addStatistics(statistics);
        cursorPools.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.setCursorFactoryAndContext(this.queryContext.transactionalContext().cursors(), this.queryContext.transactionalContext().cursorContext());
            return BoxedUnit.UNIT;
        });
        ResourceManager resourceManager2 = this.queryContext.resources();
        trackedResources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            resourceManager2.trace(resource);
            return BoxedUnit.UNIT;
        });
        this.outerLoadCSVIterator().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.notifyCommit();
            return BoxedUnit.UNIT;
        });
        this.onCommitHandlers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
    }

    private Seq<Function0<BoxedUnit>> onCommitHandlers() {
        return this.onCommitHandlers;
    }

    private void onCommitHandlers_$eq(Seq<Function0<BoxedUnit>> x$1) {
        this.onCommitHandlers = x$1;
    }

    @Override
    public void subscribeCommitted(Function0<BoxedUnit> onCommit) {
        Function0<BoxedUnit> function0 = onCommit;
        this.onCommitHandlers_$eq((Seq<Function0<BoxedUnit>>)((Seq)this.onCommitHandlers().$plus$colon(function0, Seq$.MODULE$.canBuildFrom())));
    }

    public LoadCsvPeriodicCommitObserver(long batchRowCount, ExternalCSVResource resources, QueryContext queryContext) {
        this.batchRowCount = batchRowCount;
        this.resources = resources;
        this.queryContext = queryContext;
        ExternalCSVResource.$init$(this);
        this.updateCounter = new UpdateCounter();
        this.outerLoadCSVIterator = None$.MODULE$;
        this.onCommitHandlers = (Seq)Nil$.MODULE$;
    }
}

