/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class MovingAverage {
    private final AtomicLongArray values;
    private final AtomicLong total = new AtomicLong();
    private final AtomicLong valueCursor = new AtomicLong();

    MovingAverage(int numberOfTrackedValues) {
        this.values = new AtomicLongArray(numberOfTrackedValues);
    }

    public void add(long value) {
        long cursor = this.valueCursor.getAndIncrement();
        long prevValue = this.values.getAndSet((int)(cursor % (long)this.values.length()), value);
        this.total.addAndGet(value - prevValue);
    }

    private int numberOfCurrentlyTrackedValues() {
        return (int)Math.min(this.valueCursor.get(), (long)this.values.length());
    }

    public long total() {
        return this.total.get();
    }

    public long average() {
        int trackedValues = this.numberOfCurrentlyTrackedValues();
        return trackedValues > 0 ? this.total.get() / (long)trackedValues : 0L;
    }

    public void reset() {
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.set(i, 0L);
        }
        this.total.set(0L);
        this.valueCursor.set(0L);
    }
}

