/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.RecordIdIterator;
import org.neo4j.internal.batchimport.staging.ProcessContext;
import org.neo4j.internal.batchimport.staging.PullingProducerStep;
import org.neo4j.internal.batchimport.staging.StageControl;

public class BatchFeedStep
extends PullingProducerStep<ProcessContext> {
    private final RecordIdIterator ids;
    private final int recordSize;
    private final AtomicLong count = new AtomicLong();

    public BatchFeedStep(StageControl control, Configuration config, RecordIdIterator ids, int recordSize) {
        super(control, config);
        this.ids = ids;
        this.recordSize = recordSize;
    }

    @Override
    protected Object nextBatchOrNull(long ticket, int batchSize, ProcessContext processContext) {
        this.count.getAndAdd(batchSize);
        return this.ids.nextBatch();
    }

    @Override
    protected long position() {
        return this.count.get() * (long)this.recordSize;
    }
}

