/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import org.neo4j.shell.cli.Encryption;

public class ConnectionConfig {
    public static final String USERNAME_ENV_VAR = "NEO4J_USERNAME";
    public static final String PASSWORD_ENV_VAR = "NEO4J_PASSWORD";
    public static final String DATABASE_ENV_VAR = "NEO4J_DATABASE";
    private final String scheme;
    private final String host;
    private final int port;
    private final Encryption encryption;
    private String username;
    private String password;
    private String database;

    public ConnectionConfig(String scheme, String host, int port, String username, String password, Encryption encryption, String database) {
        this.host = host;
        this.port = port;
        this.username = ConnectionConfig.fallbackToEnvVariable(username, USERNAME_ENV_VAR);
        this.password = ConnectionConfig.fallbackToEnvVariable(password, PASSWORD_ENV_VAR);
        this.encryption = encryption;
        this.scheme = scheme;
        this.database = ConnectionConfig.fallbackToEnvVariable(database, DATABASE_ENV_VAR);
    }

    private static String fallbackToEnvVariable(String preferredValue, String fallbackEnvVar) {
        String result = System.getenv(fallbackEnvVar);
        if (result == null || !preferredValue.isEmpty()) {
            result = preferredValue;
        }
        return result;
    }

    public String scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String driverUrl() {
        return String.format("%s://%s:%d", this.scheme(), this.host(), this.port());
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public String database() {
        return this.database;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = ConnectionConfig.fallbackToEnvVariable(database, DATABASE_ENV_VAR);
    }
}

