/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.unsafe;

import org.neo4j.io.os.OsBeanUtil;

public class NativeMemoryAllocationRefusedError
extends Error {
    private final long attemptedAllocationSizeBytes;
    private final long alreadyAllocatedBytes;

    NativeMemoryAllocationRefusedError(long size, long alreadyAllocatedBytes) {
        this.attemptedAllocationSizeBytes = size;
        this.alreadyAllocatedBytes = alreadyAllocatedBytes;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to allocate ").append(this.attemptedAllocationSizeBytes).append(" bytes. ");
        sb.append("So far ").append(this.alreadyAllocatedBytes);
        sb.append(" bytes have already been successfully allocated. ");
        sb.append("The system currently has ");
        NativeMemoryAllocationRefusedError.appendBytes(sb, OsBeanUtil.getTotalPhysicalMemory()).append(" total physical memory, ");
        NativeMemoryAllocationRefusedError.appendBytes(sb, OsBeanUtil.getCommittedVirtualMemory()).append(" committed virtual memory, and ");
        NativeMemoryAllocationRefusedError.appendBytes(sb, OsBeanUtil.getFreePhysicalMemory()).append(" free physical memory. ");
        sb.append("Relevant system properties: ");
        NativeMemoryAllocationRefusedError.appendSysProp(sb, "java.vm.name");
        NativeMemoryAllocationRefusedError.appendSysProp(sb.append(", "), "java.vm.vendor");
        NativeMemoryAllocationRefusedError.appendSysProp(sb.append(", "), "os.arch");
        if (this.getCause() instanceof OutOfMemoryError) {
            sb.append(". The allocation was refused by the operating system");
        }
        if (message != null) {
            sb.append(": ").append(message);
        } else {
            sb.append('.');
        }
        return sb.toString();
    }

    private static StringBuilder appendBytes(StringBuilder sb, long bytes) {
        if (bytes == -1L) {
            sb.append("(?) bytes");
        } else {
            sb.append(bytes).append(" bytes");
        }
        return sb;
    }

    private static void appendSysProp(StringBuilder sb, String sysProp) {
        sb.append('\"').append(sysProp).append("\" = \"").append(System.getProperty(sysProp)).append('\"');
    }
}

