/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnReadPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnWritePageCursor;

final class CursorFactory {
    private final MuninnPagedFile pagedFile;
    private final long victimPage;

    CursorFactory(MuninnPagedFile pagedFile) {
        this.pagedFile = pagedFile;
        this.victimPage = pagedFile.pageCache.victimPage;
    }

    MuninnReadPageCursor takeReadCursor(long pageId, int pf_flags, CursorContext cursorContext) {
        MuninnReadPageCursor cursor = new MuninnReadPageCursor(this.victimPage, cursorContext);
        cursor.initialise(this.pagedFile, pageId, pf_flags);
        return cursor;
    }

    MuninnWritePageCursor takeWriteCursor(long pageId, int pf_flags, CursorContext cursorContext) {
        MuninnWritePageCursor cursor = new MuninnWritePageCursor(this.victimPage, cursorContext);
        cursor.initialise(this.pagedFile, pageId, pf_flags);
        return cursor;
    }
}

