/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;

public final class IntValue
extends IntegralValue {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(IntValue.class);
    private final int value;

    IntValue(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        throw new IllegalStateException("A 32 bit integer doesn't fit in a 16 bit value");
    }

    @Override
    public byte byteValue() {
        throw new IllegalStateException("A 32 bit integer doesn't fit in a 8 bit value");
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeInteger(this.value);
    }

    @Override
    public Integer asObjectCopy() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Integer.toString(this.value);
    }

    public String toString() {
        return String.format("Int(%d)", this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapInt(this);
    }

    @Override
    public String getTypeName() {
        return "Integer";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE;
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.INT32;
    }
}

