/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.Log4jPluginLoadingWorkaround;
import org.neo4j.logging.log4j.Neo4jConfiguration;
import org.neo4j.logging.log4j.Neo4jJsonLogLayout;
import org.neo4j.logging.log4j.Neo4jLogLayout;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.logging.shaded.log4j.core.Appender;
import org.neo4j.logging.shaded.log4j.core.Layout;
import org.neo4j.logging.shaded.log4j.core.LoggerContext;
import org.neo4j.logging.shaded.log4j.core.appender.AbstractAppender;
import org.neo4j.logging.shaded.log4j.core.appender.ConsoleAppender;
import org.neo4j.logging.shaded.log4j.core.appender.OutputStreamAppender;
import org.neo4j.logging.shaded.log4j.core.appender.RollingFileAppender;
import org.neo4j.logging.shaded.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.neo4j.logging.shaded.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.neo4j.logging.shaded.log4j.core.config.Configuration;
import org.neo4j.logging.shaded.log4j.core.config.LoggerConfig;
import org.neo4j.util.Preconditions;

public final class LogConfig {
    private static final String APPENDER_NAME = "neo4jLog";

    private LogConfig() {
    }

    public static void updateLogLevel(Level level, Neo4jLoggerContext context) {
        LoggerContext log4jContext = context.getLoggerContext();
        Configuration config = log4jContext.getConfiguration();
        org.neo4j.logging.shaded.log4j.Level newLevel = LogConfig.convertNeo4jLevelToLevel(level);
        LoggerConfig loggerConfig = config.getRootLogger();
        loggerConfig.setLevel(newLevel);
        log4jContext.updateLoggers();
    }

    public static void reconfigureLogging(Neo4jLoggerContext ctx, Builder builder) {
        Preconditions.checkArgument((!ctx.haveExternalResources() ? 1 : 0) != 0, (String)"Can not reconfigure logging that is using output stream");
        LoggerContext log4jContext = ctx.getLoggerContext();
        LogConfig.configureLogging(log4jContext, builder);
    }

    public static Builder createBuilder(FileSystemAbstraction fs, Path logPath, Level level) {
        return new Builder(fs, logPath, level);
    }

    public static Builder createBuilder(OutputStream outputStream, Level level) {
        return new Builder(outputStream, level);
    }

    private static void configureLogging(LoggerContext context, Builder builder) {
        Neo4jConfiguration configuration = new Neo4jConfiguration();
        Neo4jLogLayout layout = LogConfig.getLayout(builder);
        Appender appender = LogConfig.getAppender(builder, layout);
        appender.start();
        configuration.addAppender(appender);
        if (builder.headerLogger != null) {
            layout.setHeaderLogger(builder.headerLogger, builder.headerClassName);
        }
        LoggerConfig rootLogger = configuration.getRootLogger();
        rootLogger.addAppender(appender, null, null);
        rootLogger.setLevel(builder.level);
        context.setConfiguration(configuration);
    }

    private static Neo4jLogLayout getLayout(Builder builder) {
        String datePattern = "yyyy-MM-dd HH:mm:ss.SSSZ";
        if (builder.format == FormattedLogFormat.PLAIN) {
            String date = "%d{" + datePattern + "}" + (builder.timezone == LogTimeZone.UTC ? "{GMT+0}" : "");
            return Neo4jLogLayout.createLayout(builder.includeCategory ? date + " %-5p [%c{1.}] %m%n" : date + " %-5p %m%n");
        }
        return Neo4jJsonLogLayout.createLayout(datePattern, builder.timezone == LogTimeZone.UTC ? "GMT+0" : null, builder.includeCategory);
    }

    private static Appender getAppender(Builder builder, Layout<String> layout) {
        if (builder.logToSystemOut) {
            return ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)((AbstractAppender.Builder)ConsoleAppender.newBuilder()).setName("neo4jLog.system.out")).setLayout(layout)).setTarget(ConsoleAppender.Target.SYSTEM_OUT)).build();
        }
        if (builder.fileSystemAbstraction instanceof DefaultFileSystemAbstraction) {
            return LogConfig.createRollingFileAppender(builder, layout);
        }
        return ((OutputStreamAppender.Builder)((OutputStreamAppender.Builder)((OutputStreamAppender.Builder)((AbstractAppender.Builder)OutputStreamAppender.newBuilder()).setName("neo4jLog.stream")).setLayout(layout)).setTarget(builder.outputStream)).build();
    }

    private static Appender createRollingFileAppender(Builder builder, Layout<String> layout) {
        long rotationThreshold = builder.rotationThreshold;
        int maxArchives = builder.maxArchives;
        if (builder.rotationThreshold == 0L || builder.maxArchives == 0) {
            rotationThreshold = Long.MAX_VALUE;
            maxArchives = 1;
        }
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy(String.valueOf(rotationThreshold));
        DefaultRolloverStrategy rolloverStrategy = DefaultRolloverStrategy.newBuilder().withMax(String.valueOf(maxArchives)).withFileIndex("min").build();
        return ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)RollingFileAppender.newBuilder()).setName("neo4jLog." + builder.logPath.getFileName().toString())).setLayout(layout)).withCreateOnDemand(builder.createOnDemand)).withFileName(builder.logPath.toString())).withFilePattern(builder.logPath + ".%i")).withPolicy(policy)).withStrategy(rolloverStrategy)).build();
    }

    private static org.neo4j.logging.shaded.log4j.Level convertNeo4jLevelToLevel(Level level) {
        switch (level) {
            case ERROR: {
                return org.neo4j.logging.shaded.log4j.Level.ERROR;
            }
            case WARN: {
                return org.neo4j.logging.shaded.log4j.Level.WARN;
            }
            case INFO: {
                return org.neo4j.logging.shaded.log4j.Level.INFO;
            }
            case DEBUG: {
                return org.neo4j.logging.shaded.log4j.Level.DEBUG;
            }
            case NONE: {
                return org.neo4j.logging.shaded.log4j.Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unknown Log level: " + level);
    }

    static {
        Log4jPluginLoadingWorkaround.doLog4jPluginLoadingWorkaround();
    }

    public static class Builder {
        private final Path logPath;
        private final org.neo4j.logging.shaded.log4j.Level level;
        private OutputStream outputStream;
        private long rotationThreshold;
        private int maxArchives;
        private FormattedLogFormat format = FormattedLogFormat.PLAIN;
        private LogTimeZone timezone = LogTimeZone.UTC;
        private boolean includeCategory = true;
        private Consumer<Log> headerLogger;
        private String headerClassName;
        private boolean logToSystemOut;
        private boolean createOnDemand;
        private FileSystemAbstraction fileSystemAbstraction;

        private Builder(FileSystemAbstraction fileSystemAbstraction, Path logPath, Level level) {
            this.fileSystemAbstraction = fileSystemAbstraction;
            this.logPath = logPath;
            this.outputStream = null;
            this.level = LogConfig.convertNeo4jLevelToLevel(level);
        }

        private Builder(OutputStream outputStream, Level level) {
            this.logPath = null;
            this.outputStream = outputStream;
            this.level = LogConfig.convertNeo4jLevelToLevel(level);
        }

        public Builder withRotation(long rotationThreshold, int maxArchives) {
            this.rotationThreshold = rotationThreshold;
            this.maxArchives = maxArchives;
            return this;
        }

        public Builder withTimezone(LogTimeZone timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder withFormat(FormattedLogFormat format) {
            this.format = format;
            return this;
        }

        public Builder withCategory(boolean includeCategory) {
            this.includeCategory = includeCategory;
            return this;
        }

        public Builder withHeaderLogger(Consumer<Log> headerLogger, String headerClassName) {
            this.headerLogger = headerLogger;
            this.headerClassName = headerClassName;
            return this;
        }

        public Builder logToSystemOut() {
            this.logToSystemOut = true;
            return this;
        }

        public Builder createOnDemand() {
            this.createOnDemand = true;
            return this;
        }

        public Neo4jLoggerContext build() {
            try {
                LoggerContext context = new LoggerContext("loggercontext");
                if (this.fileSystemAbstraction instanceof DefaultFileSystemAbstraction) {
                    if (this.outputStream != null) {
                        throw new IllegalStateException("When using filesystem abstraction you cannot provide a stream since we cant rotate that");
                    }
                    LogConfig.configureLogging(context, this);
                    return new Neo4jLoggerContext(context, null);
                }
                if (this.outputStream == null) {
                    this.fileSystemAbstraction.mkdirs(this.logPath.getParent());
                    this.outputStream = this.fileSystemAbstraction.openAsOutputStream(this.logPath, true);
                    LogConfig.configureLogging(context, this);
                    return new Neo4jLoggerContext(context, this.outputStream);
                }
                LogConfig.configureLogging(context, this);
                return new Neo4jLoggerContext(context, null);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

