/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.logging.shaded.log4j.core.config.plugins.util.PluginManager;
import org.neo4j.logging.shaded.log4j.core.config.plugins.util.PluginRegistry;
import org.neo4j.util.VisibleForTesting;

class Log4jPluginLoadingWorkaround {
    static final String PKG_SHADED_LOG4J = "org.neo4j.logging.shaded.log4j";
    static final String PKG_OUR_PLUGINS = "org.neo4j.logging.log4j";
    static final String PKG_UNSHADED_LOG4J = "org.neo4j.logging.shaded.log4j.core";
    private static boolean hasLoadedLog4j;

    Log4jPluginLoadingWorkaround() {
    }

    static synchronized void doLog4jPluginLoadingWorkaround() {
        if (!hasLoadedLog4j) {
            Log4jPluginLoadingWorkaround.internalDoLog4jPluginLoadingWorkaround(PluginRegistry.getInstance(), registry -> registry.getClass().getPackage().getName().contains("shaded"), PluginManager::addPackage, Log4jPluginLoadingWorkaround::trickLog4jThatThereAreNoFiles);
            hasLoadedLog4j = true;
        }
    }

    @VisibleForTesting
    static synchronized void internalDoLog4jPluginLoadingWorkaround(PluginRegistry pluginRegistry, Function<PluginRegistry, Boolean> checkIsShaded, Consumer<String> addPackageToPluginManager, Consumer<PluginRegistry> trickLog4j) {
        if (checkIsShaded.apply(pluginRegistry).booleanValue()) {
            if (!pluginRegistry.loadFromMainClassLoader().isEmpty() || !pluginRegistry.loadFromPackage(PKG_UNSHADED_LOG4J).isEmpty()) {
                pluginRegistry.clear();
                trickLog4j.accept(pluginRegistry);
            }
            pluginRegistry.loadFromPackage(PKG_SHADED_LOG4J);
            pluginRegistry.loadFromPackage(PKG_OUR_PLUGINS);
            addPackageToPluginManager.accept(PKG_SHADED_LOG4J);
            addPackageToPluginManager.accept(PKG_OUR_PLUGINS);
        }
    }

    private static void trickLog4jThatThereAreNoFiles(PluginRegistry pluginRegistry) {
        try {
            PrivilegedExceptionAction<Void> fakeLookedAtFiles = () -> {
                Field plugins = PluginRegistry.class.getDeclaredField("pluginsByCategoryRef");
                plugins.setAccessible(true);
                AtomicReference pluginsByCategoryRef = new AtomicReference();
                HashMap map = new HashMap();
                map.put("dummy", new ArrayList());
                pluginsByCategoryRef.set(map);
                plugins.set(pluginRegistry, pluginsByCategoryRef);
                return null;
            };
            AccessController.doPrivileged(fakeLookedAtFiles);
        }
        catch (Exception e) {
            throw new LinkageError("Cannot access org.neo4j.logging.shaded.log4j", e);
        }
    }
}

