/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.nio.file.Path;
import java.util.function.Predicate;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public class NativeIndexFileFilter
implements Predicate<Path> {
    private final Path indexRoot;

    public NativeIndexFileFilter(Path storeDir) {
        this.indexRoot = IndexDirectoryStructure.baseSchemaIndexFolder((Path)storeDir).toAbsolutePath();
    }

    @Override
    public boolean test(Path path) {
        if (!path.toAbsolutePath().startsWith(this.indexRoot)) {
            return false;
        }
        Path schemaPath = this.indexRoot.relativize(path);
        int nameCount = schemaPath.getNameCount();
        boolean isDeprecatedProviderFile = nameCount >= 1 && (schemaPath.getName(0).toString().equals("lucene") || schemaPath.getName(0).toString().equals("lucene_native-1.0") || schemaPath.getName(0).toString().equals("lucene_native-2.0"));
        boolean isFusionLuceneProviderFile = nameCount >= 3 && schemaPath.getName(2).toString().startsWith("lucene-");
        return !isDeprecatedProviderFile && !isFusionLuceneProviderFile;
    }
}

