/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DefaultNodePropertyAccessor
implements NodePropertyAccessor {
    private final StorageReader reader;
    private final StoreCursors storeCursors;
    private final StorageNodeCursor nodeCursor;
    private final StoragePropertyCursor propertyCursor;

    public DefaultNodePropertyAccessor(StorageReader reader, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        this.reader = reader;
        this.storeCursors = storeCursors;
        this.nodeCursor = reader.allocateNodeCursor(cursorContext, storeCursors);
        this.propertyCursor = reader.allocatePropertyCursor(cursorContext, storeCursors, memoryTracker);
    }

    public Value getNodePropertyValue(long nodeId, int propertyKeyId, CursorContext cursorContext) {
        this.nodeCursor.single(nodeId);
        if (this.nodeCursor.next() && this.nodeCursor.hasProperties()) {
            this.nodeCursor.properties(this.propertyCursor, PropertySelection.selection((int[])new int[]{propertyKeyId}));
            if (this.propertyCursor.next()) {
                return this.propertyCursor.propertyValue();
            }
        }
        return Values.NO_VALUE;
    }

    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.nodeCursor, this.propertyCursor, this.reader, this.storeCursors});
    }
}

