/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.storemigration.FulltextConfigExtractor;
import org.neo4j.kernel.impl.storemigration.GenericConfigExtractor;
import org.neo4j.kernel.impl.storemigration.SpatialConfigExtractor;
import org.neo4j.kernel.impl.storemigration.SpatialFile;
import org.neo4j.logging.Log;
import org.neo4j.values.storable.CoordinateReferenceSystem;

enum IndexMigration {
    LUCENE("lucene", "1.0", IndexMigration.asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE30), true){

        @Override
        Path[] providerRootDirectories(DatabaseLayout layout) {
            Path luceneDir = IndexMigration.directoryRootByProviderKey(layout.databaseDirectory(), this.providerKey);
            Path lucene10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new Path[]{luceneDir, lucene10Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, CursorContext cursorContext, Log log) throws IOException {
            Path lucene10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            Path spatialDirectory = IndexMigration.getSpatialSubDirectory(indexId, lucene10Dir);
            List<SpatialFile> spatialFiles = 1.getSpatialFiles(fs, spatialDirectory);
            return SpatialConfigExtractor.indexConfigFromSpatialFile(pageCache, spatialFiles, cursorContext, log, layout.getDatabaseName());
        }
    }
    ,
    NATIVE10("lucene+native", "1.0", IndexMigration.asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE30), true){

        @Override
        Path[] providerRootDirectories(DatabaseLayout layout) {
            Path luceneNative10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new Path[]{luceneNative10Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, CursorContext cursorContext, Log log) throws IOException {
            Path providerRootDirectory = this.providerRootDirectories(layout)[0];
            Path spatialDirectory = IndexMigration.getSpatialSubDirectory(indexId, providerRootDirectory);
            List<SpatialFile> spatialFiles = 2.getSpatialFiles(fs, spatialDirectory);
            return SpatialConfigExtractor.indexConfigFromSpatialFile(pageCache, spatialFiles, cursorContext, log, layout.getDatabaseName());
        }
    }
    ,
    NATIVE20("lucene+native", "2.0", IndexMigration.asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10), true){

        @Override
        Path[] providerRootDirectories(DatabaseLayout layout) {
            Path luceneNative20Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new Path[]{luceneNative20Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, CursorContext cursorContext, Log log) throws IOException {
            Path providerRootDirectory = this.providerRootDirectories(layout)[0];
            Path spatialDirectory = IndexMigration.getSpatialSubDirectory(indexId, providerRootDirectory);
            List<SpatialFile> spatialFiles = 3.getSpatialFiles(fs, spatialDirectory);
            return SpatialConfigExtractor.indexConfigFromSpatialFile(pageCache, spatialFiles, cursorContext, log, layout.getDatabaseName());
        }
    }
    ,
    NATIVE_BTREE10(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerKey(), GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion(), IndexMigration.asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10), false){

        @Override
        Path[] providerRootDirectories(DatabaseLayout layout) {
            Path nativeBtree10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new Path[]{nativeBtree10Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, CursorContext cursorContext, Log log) throws IOException {
            Path rootDir = this.providerRootDirectories(layout)[0];
            Path genericFile = rootDir.resolve(String.valueOf(indexId)).resolve("index-" + indexId);
            return GenericConfigExtractor.indexConfigFromGenericFile(fs, pageCache, genericFile, cursorContext, log, layout.getDatabaseName());
        }
    }
    ,
    FULLTEXT10("fulltext", "1.0", new IndexProviderDescriptor("fulltext", "1.0"), false){

        @Override
        Path[] providerRootDirectories(DatabaseLayout layout) {
            Path fulltext10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new Path[]{fulltext10Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, CursorContext cursorContext, Log log) {
            Path fulltext10Dir = this.providerRootDirectories(layout)[0];
            Path directoryForIndex = fulltext10Dir.resolve(String.valueOf(indexId));
            Path fulltextIndexDirectory = IndexMigration.directoryBySubProvider(directoryForIndex, this.providerKey, this.providerVersion);
            return FulltextConfigExtractor.indexConfigFromFulltextDirectory(fs, fulltextIndexDirectory);
        }
    };

    private static final Pattern CRS_FILE_PATTERN;
    private static final String SPATIAL_DIRECTORY_NAME = "spatial-1.0";
    final String providerKey;
    final String providerVersion;
    final IndexProviderDescriptor desiredAlternativeProvider;
    private final boolean retired;

    private IndexMigration(String providerKey, String providerVersion, IndexProviderDescriptor desiredAlternativeProvider, boolean retired) {
        this.providerKey = providerKey;
        this.providerVersion = providerVersion;
        this.desiredAlternativeProvider = desiredAlternativeProvider;
        this.retired = retired;
    }

    abstract Path[] providerRootDirectories(DatabaseLayout var1);

    abstract IndexConfig extractIndexConfig(FileSystemAbstraction var1, PageCache var2, DatabaseLayout var3, long var4, CursorContext var6, Log var7) throws IOException;

    private static Path baseSchemaIndexFolder(Path databaseStoreDir) {
        return databaseStoreDir.resolve("schema").resolve("index");
    }

    private static Path directoryRootByProviderKey(Path databaseStoreDir, String providerKey) {
        return IndexMigration.baseSchemaIndexFolder(databaseStoreDir).resolve(IndexMigration.fileNameFriendly(providerKey));
    }

    private static Path directoryRootByProviderKeyAndVersion(Path databaseStoreDir, String providerKey, String providerVersion) {
        return IndexMigration.baseSchemaIndexFolder(databaseStoreDir).resolve(IndexMigration.fileNameFriendly(providerKey + "-" + providerVersion));
    }

    private static Path directoryBySubProvider(Path parentProviderDir, String providerKey, String providerVersion) {
        return parentProviderDir.resolve(IndexMigration.fileNameFriendly(providerKey + "-" + providerVersion));
    }

    private static String fileNameFriendly(String name) {
        return name.replaceAll("\\+", "_");
    }

    public static IndexMigration migrationFromOldProvider(String providerKey, String providerVersion) {
        for (IndexMigration provider : IndexMigration.values()) {
            if (!provider.providerKey.equals(providerKey) || !provider.providerVersion.equals(providerVersion)) continue;
            return provider;
        }
        throw new IllegalArgumentException("Can not find old index provider " + providerKey + "-" + providerVersion);
    }

    public static IndexMigration[] retired() {
        return (IndexMigration[])Arrays.stream(IndexMigration.values()).filter(p -> p.retired).toArray(IndexMigration[]::new);
    }

    public static IndexMigration[] nonRetired() {
        return (IndexMigration[])Arrays.stream(IndexMigration.values()).filter(p -> !p.retired).toArray(IndexMigration[]::new);
    }

    private static Path getSpatialSubDirectory(long indexId, Path baseProviderDir) {
        return baseProviderDir.resolve(String.valueOf(indexId)).resolve(SPATIAL_DIRECTORY_NAME);
    }

    public static List<SpatialFile> getSpatialFiles(FileSystemAbstraction fs, Path spatialDirectory) throws IOException {
        ArrayList<SpatialFile> spatialFiles = new ArrayList<SpatialFile>();
        if (fs.fileExists(spatialDirectory)) {
            Path[] files;
            for (Path file : files = fs.listFiles(spatialDirectory)) {
                String name = file.getFileName().toString();
                Matcher matcher = CRS_FILE_PATTERN.matcher(name);
                if (!matcher.matches()) continue;
                int tableId = Integer.parseInt(matcher.group(1));
                int code = Integer.parseInt(matcher.group(2));
                CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)tableId, (int)code);
                spatialFiles.add(new SpatialFile(crs, file));
            }
        }
        return spatialFiles;
    }

    private static IndexProviderDescriptor asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        return new IndexProviderDescriptor(schemaIndex.providerKey(), schemaIndex.providerVersion());
    }

    static {
        CRS_FILE_PATTERN = Pattern.compile("(\\d+)-(\\d+)");
    }
}

