/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve2D;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve3D;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;

public class SpaceFillingCurveSettings {
    private static final int NBR_OF_BITS = 60;
    private final int dimensions;
    private final int maxLevels;
    private final Envelope extents;

    public SpaceFillingCurveSettings(int dimensions, Envelope extents) {
        this.dimensions = dimensions;
        this.extents = extents;
        this.maxLevels = 60 / dimensions;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Envelope indexExtents() {
        return this.extents;
    }

    public SpaceFillingCurve curve() {
        if (this.dimensions == 2) {
            return new HilbertSpaceFillingCurve2D(this.extents, this.maxLevels);
        }
        if (this.dimensions == 3) {
            return new HilbertSpaceFillingCurve3D(this.extents, this.maxLevels);
        }
        throw new IllegalArgumentException("Cannot create spatial index with other than 2D or 3D coordinate reference system: " + this.dimensions + "D");
    }

    public int hashCode() {
        return 31 * this.extents.hashCode() + this.maxLevels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceFillingCurveSettings that = (SpaceFillingCurveSettings)o;
        return this.dimensions == that.dimensions && this.maxLevels == that.maxLevels && Objects.equals(this.extents, that.extents);
    }

    public String toString() {
        return String.format("Space filling curves settings: dimensions=%d, maxLevels=%d, min=%s, max=%s", this.dimensions, this.maxLevels, Arrays.toString(this.extents.getMin()), Arrays.toString(this.extents.getMax()));
    }
}

