/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GeometryType2;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class GeometryArrayType2
extends AbstractArrayType<PointValue> {
    GeometryArrayType2(byte typeId) {
        super(ValueGroup.GEOMETRY_ARRAY, typeId, (o1, o2, i) -> GeometryType2.compare(o1.long0, o1.long1, o1.long2, o1.long0Array, (int)o1.long2 * i, o2.long0, o2.long1, o2.long2, o2.long0Array, (int)o2.long2 * i), null, null, null, null, null);
    }

    @Override
    int valueSize(GenericKey<?> state) {
        return 3 + GeometryArrayType2.arrayKeySize(state, GeometryType2.dimensions(state) * 8);
    }

    @Override
    void copyValue(GenericKey<?> to, GenericKey<?> from, int arrayLength) {
        this.initializeArray(to, arrayLength, null);
        to.long0 = from.long0;
        to.long1 = from.long1;
        to.long2 = from.long2;
        int dimensions = GeometryType2.dimensions(from);
        to.long0Array = GeometryArrayType2.ensureBigEnough(to.long0Array, dimensions * arrayLength);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, dimensions * arrayLength);
    }

    @Override
    void initializeArray(GenericKey<?> key, int length, ValueWriter.ArrayType arrayType) {
        if (length == 0 && key.long0Array == null) {
            key.long0Array = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
        }
    }

    @Override
    Value asValue(GenericKey<?> state) {
        Point[] points = new Point[state.arrayLength];
        if (points.length > 0) {
            CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)((int)state.long0), (int)((int)state.long1));
            int dimensions = GeometryType2.dimensions(state);
            for (int i = 0; i < points.length; ++i) {
                points[i] = GeometryType2.asValue(state, crs, dimensions * i);
            }
        }
        return Values.pointArray((Point[])points);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey<?> state) {
        GeometryType2.putCrs(cursor, state.long0, state.long1, state.long2);
        int dimensions = GeometryType2.dimensions(state);
        GeometryArrayType2.putArray(cursor, state, (c, k, i) -> GeometryType2.putPoint(c, k.long2, k.long0Array, i * dimensions));
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey<?> into) {
        GeometryType2.readCrs(cursor, into);
        return GeometryArrayType2.readArray(cursor, ValueWriter.ArrayType.POINT, GeometryArrayType2::readGeometryArrayItem, into);
    }

    @Override
    String toString(GenericKey<?> state) {
        return String.format("GeometryArray2[tableId:%d, code:%d, value:%s]", state.long0, state.long1, this.asValue(state).toString());
    }

    private static boolean readGeometryArrayItem(PageCursor cursor, GenericKey<?> into) {
        int dimensions = GeometryType2.dimensions(into);
        if (into.currentArrayOffset == 0) {
            into.long0Array = GeometryArrayType2.ensureBigEnough(into.long0Array, dimensions * into.arrayLength);
        }
        int offset = into.currentArrayOffset * dimensions;
        for (int i = 0; i < dimensions; ++i) {
            into.long0Array[offset + i] = cursor.getLong();
        }
        ++into.currentArrayOffset;
        return true;
    }

    static void write(RangeKey state, int tableId, int code, int offset, double[] coordinates) {
        if (offset == 0) {
            int dimensions = coordinates.length;
            state.long0Array = GeometryArrayType2.ensureBigEnough(state.long0Array, dimensions * state.arrayLength);
            state.long2 = dimensions;
            state.long0 = tableId;
            state.long1 = code;
        }
        int base = GeometryType2.dimensions(state) * offset;
        for (int i = 0; i < coordinates.length; ++i) {
            state.long0Array[base + i] = Double.doubleToLongBits(coordinates[i]);
        }
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey<?> state) {
        joiner.add("long0=" + state.long0);
        joiner.add("long1=" + state.long1);
        joiner.add("long2=" + state.long2);
        joiner.add("long0Array=" + Arrays.toString(state.long0Array));
        super.addTypeSpecificDetails(joiner, state);
    }
}

