/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJob;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.LogProvider;

public class OnlineIndexSamplingJobFactory
implements IndexSamplingJobFactory {
    private final IndexStatisticsStore indexStatisticsStore;
    private final LogProvider logProvider;
    private final TokenNameLookup nameLookup;
    private final PageCacheTracer pageCacheTracer;

    public OnlineIndexSamplingJobFactory(IndexStatisticsStore indexStatisticsStore, TokenNameLookup nameLookup, LogProvider logProvider, PageCacheTracer pageCacheTracer) {
        this.indexStatisticsStore = indexStatisticsStore;
        this.logProvider = logProvider;
        this.nameLookup = nameLookup;
        this.pageCacheTracer = pageCacheTracer;
    }

    @Override
    public IndexSamplingJob create(long indexId, IndexProxy indexProxy) {
        String indexUserDescription = indexProxy.getDescriptor().userDescription(this.nameLookup);
        String indexName = indexProxy.getDescriptor().getName();
        return new OnlineIndexSamplingJob(indexId, indexProxy, this.indexStatisticsStore, indexUserDescription, indexName, this.logProvider, this.pageCacheTracer);
    }
}

