/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;

public class IndexReaderCache<T extends IndexReader> {
    private final Map<IndexDescriptor, T> indexReaders;
    private final ThrowingFunction<IndexDescriptor, T, IndexNotFoundKernelException> indexSupplier;

    public IndexReaderCache(ThrowingFunction<IndexDescriptor, T, IndexNotFoundKernelException> indexSupplier) {
        this.indexSupplier = indexSupplier;
        this.indexReaders = new HashMap<IndexDescriptor, T>();
    }

    public T getOrCreate(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexReader reader = (IndexReader)this.indexReaders.get(descriptor);
        if (reader == null) {
            reader = (IndexReader)this.indexSupplier.apply((Object)descriptor);
            this.indexReaders.put(descriptor, reader);
        }
        return (T)reader;
    }

    public void close() {
        if (this.indexReaders.isEmpty()) {
            return;
        }
        for (IndexReader indexReader : this.indexReaders.values()) {
            indexReader.close();
        }
        this.indexReaders.clear();
    }
}

