/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.function.Supplier;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootCatchup;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.util.FeatureToggles;

public class TripCountingRootCatchup
implements RootCatchup {
    private static final String MAX_TRIP_COUNT_NAME = "max_trip_count";
    private static final int MAX_TRIP_COUNT_DEFAULT = 10;
    static final int MAX_TRIP_COUNT = FeatureToggles.getInteger(TripCountingRootCatchup.class, (String)"max_trip_count", (int)10);
    private final Supplier<Root> rootSupplier;
    private long lastFromId = 0L;
    private int tripCount;

    TripCountingRootCatchup(Supplier<Root> rootSupplier) {
        this.rootSupplier = rootSupplier;
    }

    @Override
    public Root catchupFrom(long fromId) {
        this.updateTripCount(fromId);
        this.assertTripCount();
        return this.rootSupplier.get();
    }

    private void updateTripCount(long fromId) {
        if (fromId == this.lastFromId) {
            ++this.tripCount;
        } else {
            this.lastFromId = fromId;
            this.tripCount = 1;
        }
    }

    private void assertTripCount() {
        if (this.tripCount >= MAX_TRIP_COUNT) {
            throw new TreeInconsistencyException("Index traversal aborted due to being stuck in infinite loop. This is most likely caused by an inconsistency in the index. Loop occurred when restarting search from root from page %d.", this.lastFromId);
        }
    }
}

