/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.http.cypher.entity.HttpRelationship;
import org.neo4j.server.rest.repr.EntityRepresentation;
import org.neo4j.server.rest.repr.ExtensibleRepresentation;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.PropertiesRepresentation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public final class RelationshipRepresentation
extends ObjectRepresentation
implements ExtensibleRepresentation,
EntityRepresentation {
    private final Relationship rel;

    public RelationshipRepresentation(Relationship rel) {
        super(RepresentationType.RELATIONSHIP);
        this.rel = rel;
    }

    public String getIdentity() {
        return Long.toString(this.rel.getId());
    }

    public long getId() {
        return this.rel.getId();
    }

    @Override
    @ObjectRepresentation.Mapping(value="self")
    public ValueRepresentation selfUri() {
        return ValueRepresentation.uri((String)this.path(""));
    }

    private String path(String path) {
        return "relationship/" + this.rel.getId() + path;
    }

    static String path(Relationship rel) {
        return "relationship/" + rel.getId();
    }

    @ObjectRepresentation.Mapping(value="type")
    public ValueRepresentation getType() {
        return ValueRepresentation.relationshipType((RelationshipType)this.rel.getType());
    }

    @ObjectRepresentation.Mapping(value="start")
    public ValueRepresentation startNodeUri() {
        return ValueRepresentation.uri((String)NodeRepresentation.path(this.rel.getStartNodeId()));
    }

    @ObjectRepresentation.Mapping(value="end")
    public ValueRepresentation endNodeUri() {
        return ValueRepresentation.uri((String)NodeRepresentation.path(this.rel.getEndNodeId()));
    }

    @ObjectRepresentation.Mapping(value="properties")
    public ValueRepresentation propertiesUri() {
        return ValueRepresentation.uri((String)this.path("/properties"));
    }

    @ObjectRepresentation.Mapping(value="property")
    public ValueRepresentation propertyUriTemplate() {
        return ValueRepresentation.template((String)this.path("/properties/{key}"));
    }

    @ObjectRepresentation.Mapping(value="metadata")
    public MapRepresentation metadata() {
        if (this.isDeleted()) {
            return new MapRepresentation(MapUtil.map((Object[])new Object[]{"id", this.rel.getId(), "deleted", Boolean.TRUE}));
        }
        return new MapRepresentation(MapUtil.map((Object[])new Object[]{"id", this.rel.getId(), "type", this.rel.getType().name()}));
    }

    private boolean isDeleted() {
        return ((HttpRelationship)this.rel).isDeleted();
    }

    @Override
    public void extraData(MappingSerializer serializer) {
        if (!this.isDeleted()) {
            MappingWriter properties = serializer.writer.newMapping(RepresentationType.PROPERTIES, "data");
            new PropertiesRepresentation((Entity)this.rel).serialize(properties);
            properties.done();
        }
    }
}

