/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.server.http.cypher.entity.HttpProfilerStatistics;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public class HttpExecutionPlanDescription
implements ExecutionPlanDescription {
    private final String name;
    private final List<ExecutionPlanDescription> children;
    private final Map<String, Object> arguments;
    private final Set<String> identifiers;
    private final ExecutionPlanDescription.ProfilerStatistics profilerStatistics;
    private static final DefaultValueMapper valueMapper = new DefaultValueMapper(null);
    public static ExecutionPlanDescription EMPTY = new ExecutionPlanDescription(){

        public String getName() {
            return "";
        }

        public List<ExecutionPlanDescription> getChildren() {
            return Collections.emptyList();
        }

        public Map<String, Object> getArguments() {
            return Collections.emptyMap();
        }

        public Set<String> getIdentifiers() {
            return Collections.emptySet();
        }

        public boolean hasProfilerStatistics() {
            return false;
        }

        public ExecutionPlanDescription.ProfilerStatistics getProfilerStatistics() {
            return null;
        }
    };

    public HttpExecutionPlanDescription(String name, List<ExecutionPlanDescription> children, Map<String, Object> arguments, Set<String> identifiers, ExecutionPlanDescription.ProfilerStatistics profilerStatistics) {
        this.name = name;
        this.children = children;
        this.arguments = arguments;
        this.identifiers = identifiers;
        this.profilerStatistics = profilerStatistics;
    }

    public static ExecutionPlanDescription fromAnyValue(AnyValue anyValue) {
        if (anyValue == null) {
            return EMPTY;
        }
        MapValue mapValue = (MapValue)anyValue;
        ExecutionPlanDescription.ProfilerStatistics profilerStatistics = HttpProfilerStatistics.fromMapValue(mapValue);
        return new HttpExecutionPlanDescription(((TextValue)mapValue.get("operatorType")).stringValue(), HttpExecutionPlanDescription.extractChildren((ListValue)mapValue.get("children")), HttpExecutionPlanDescription.extractArguments((MapValue)mapValue.get("args")), HttpExecutionPlanDescription.extractIdentifiers((ListValue)mapValue.get("identifiers")), profilerStatistics);
    }

    private static List<ExecutionPlanDescription> extractChildren(ListValue listValue) {
        ArrayList<ExecutionPlanDescription> children = new ArrayList<ExecutionPlanDescription>();
        listValue.forEach(v -> children.add(HttpExecutionPlanDescription.fromAnyValue(v)));
        return children;
    }

    private static Set<String> extractIdentifiers(ListValue identifiers) {
        List identifierList = (List)identifiers.map((ValueMapper)valueMapper);
        return new HashSet<String>(identifierList);
    }

    private static Map<String, Object> extractArguments(MapValue argumentsMapValue) {
        return (Map)argumentsMapValue.map((ValueMapper)valueMapper);
    }

    public String getName() {
        return this.name;
    }

    public List<ExecutionPlanDescription> getChildren() {
        return this.children;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public Set<String> getIdentifiers() {
        return this.identifiers;
    }

    public boolean hasProfilerStatistics() {
        return this.profilerStatistics == null;
    }

    public ExecutionPlanDescription.ProfilerStatistics getProfilerStatistics() {
        return this.profilerStatistics;
    }
}

