/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.lifecycle.LifecycleStatusProvider;

public abstract class SafeLifecycle
implements Lifecycle,
LifecycleStatusProvider {
    private volatile LifecycleStatus state;

    protected SafeLifecycle() {
        this(LifecycleStatus.NONE);
    }

    SafeLifecycle(LifecycleStatus state) {
        this.state = state;
    }

    private void transition(LifecycleStatus expected, LifecycleStatus to, Operation op, boolean force) throws Exception {
        if (this.state != expected) {
            throw new IllegalStateException(String.format("Expected %s but was %s", new Object[]{expected, this.state}));
        }
        if (force) {
            this.state = to;
            op.run();
        } else {
            op.run();
            this.state = to;
        }
    }

    @Override
    public final synchronized void init() throws Exception {
        this.transition(LifecycleStatus.NONE, LifecycleStatus.STOPPED, this::init0, false);
    }

    @Override
    public final synchronized void start() throws Exception {
        this.transition(LifecycleStatus.STOPPED, LifecycleStatus.STARTED, this::start0, false);
    }

    @Override
    public final synchronized void stop() throws Exception {
        if (this.state == LifecycleStatus.STOPPED) {
            return;
        }
        this.transition(LifecycleStatus.STARTED, LifecycleStatus.STOPPED, this::stop0, true);
    }

    @Override
    public final synchronized void shutdown() throws Exception {
        if (this.state == LifecycleStatus.NONE) {
            this.state = LifecycleStatus.NONE;
            return;
        }
        this.transition(LifecycleStatus.STOPPED, LifecycleStatus.SHUTDOWN, this::shutdown0, true);
    }

    public void init0() throws Exception {
    }

    public void start0() throws Exception {
    }

    public void stop0() throws Exception {
    }

    public void shutdown0() throws Exception {
    }

    @Override
    public LifecycleStatus getStatus() {
        return this.state;
    }

    static interface Operation {
        public void run() throws Exception;
    }
}

