/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.helpers.progress.Aggregator;
import org.neo4j.internal.helpers.progress.Indicator;

public interface ProgressListener {
    public static final ProgressListener NONE = new Adapter();

    public void started(String var1);

    public void started();

    public void add(long var1);

    public void done();

    public void failed(Throwable var1);

    public ProgressListener threadLocalReporter(int var1);

    default public ProgressListener threadLocalReporter() {
        return this.threadLocalReporter(1000);
    }

    public static final class MultiPartProgressListener
    extends Adapter {
        public final String part;
        public final long totalCount;
        private final Aggregator aggregator;
        private final AtomicBoolean started = new AtomicBoolean();
        private final AtomicLong progress = new AtomicLong();

        MultiPartProgressListener(Aggregator aggregator, String part, long totalCount) {
            this.aggregator = aggregator;
            this.part = part;
            this.totalCount = totalCount;
        }

        @Override
        public void started(String task) {
            if (this.started.compareAndSet(false, true)) {
                this.aggregator.start(this);
            }
        }

        @Override
        public void add(long delta) {
            this.started();
            long current = this.progress.get();
            if (current + delta > this.totalCount) {
                delta = this.totalCount - current;
            }
            if (delta > 0L) {
                this.progress.addAndGet(delta);
                this.aggregator.update(delta);
            }
        }

        @Override
        public synchronized void done() {
            long delta = this.totalCount - this.progress.get();
            if (delta > 0L) {
                this.add(delta);
            }
            this.aggregator.complete(this);
        }

        @Override
        public void failed(Throwable e) {
            this.aggregator.signalFailure(e);
        }
    }

    public static class SinglePartProgressListener
    extends Adapter {
        private final Indicator indicator;
        private final long totalCount;
        private long value;
        private int lastReported;
        private boolean stared;

        SinglePartProgressListener(Indicator indicator, long totalCount) {
            this.indicator = indicator;
            this.totalCount = totalCount;
        }

        @Override
        public void started(String task) {
            if (!this.stared) {
                this.stared = true;
                this.indicator.startProcess(this.totalCount);
            }
        }

        @Override
        public void add(long progress) {
            this.update(this.value += progress);
        }

        @Override
        public void done() {
            this.value = this.totalCount;
            this.update(this.value);
            this.indicator.completeProcess();
        }

        @Override
        public void failed(Throwable e) {
            this.indicator.failure(e);
        }

        void update(long progress) {
            int current;
            this.started();
            int n = current = this.totalCount == 0L ? 0 : (int)(progress * (long)this.indicator.reportResolution() / this.totalCount);
            if (current > this.lastReported) {
                this.indicator.progress(this.lastReported, current);
                this.lastReported = current;
            }
        }
    }

    public static class ThreadLocalReporter
    extends Adapter {
        private final int threshold;
        private final ProgressListener parent;
        private int localUnreportedProgress;

        ThreadLocalReporter(int threshold, ProgressListener parent) {
            this.threshold = threshold;
            this.parent = parent;
        }

        @Override
        public void add(long progress) {
            this.localUnreportedProgress = (int)((long)this.localUnreportedProgress + progress);
            if (this.localUnreportedProgress >= this.threshold) {
                this.reportToParent();
            }
        }

        @Override
        public void done() {
            this.reportToParent();
        }

        private void reportToParent() {
            this.parent.add(this.localUnreportedProgress);
            this.localUnreportedProgress = 0;
        }

        @Override
        public void failed(Throwable e) {
            this.parent.failed(e);
        }

        @Override
        public ProgressListener threadLocalReporter(int threshold) {
            return this;
        }
    }

    public static class Adapter
    implements ProgressListener {
        @Override
        public void started() {
            this.started(null);
        }

        @Override
        public void started(String task) {
        }

        @Override
        public void add(long progress) {
        }

        @Override
        public void done() {
        }

        @Override
        public void failed(Throwable e) {
        }

        @Override
        public ProgressListener threadLocalReporter(int threshold) {
            return new ThreadLocalReporter(threshold, this);
        }
    }
}

