/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.standard;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.TokenRecord;

public abstract class TokenRecordFormat<RECORD extends TokenRecord>
extends BaseOneByteHeaderRecordFormat<RECORD> {
    static final int BASE_RECORD_SIZE = 5;
    private static final byte INTERNAL_FLAG = 2;

    TokenRecordFormat(int recordSize, int idBits, boolean pageAligned) {
        super(TokenRecordFormat.fixedRecordSize(recordSize), 0, 1, idBits, pageAligned);
    }

    @Override
    public void read(RECORD record, PageCursor cursor, RecordLoad mode, int recordSize, int recordsPerPage) {
        byte headerByte = cursor.getByte();
        boolean inUse = this.isInUse(headerByte);
        ((AbstractBaseRecord)record).setInUse(inUse);
        if (mode.shouldLoad(inUse)) {
            this.readRecordData(cursor, record, inUse);
            ((TokenRecord)record).setInternal(TokenRecordFormat.has(headerByte, 2));
        }
    }

    protected void readRecordData(PageCursor cursor, RECORD record, boolean inUse) {
        ((TokenRecord)record).initialize(inUse, cursor.getInt());
    }

    @Override
    public void write(RECORD record, PageCursor cursor, int recordSize, int recordsPerPage) {
        if (((AbstractBaseRecord)record).inUse()) {
            byte headerByte = Record.IN_USE.byteValue();
            if (((TokenRecord)record).isInternal()) {
                headerByte = (byte)(headerByte + 2);
            }
            cursor.putByte(headerByte);
            this.writeRecordData(record, cursor);
        } else {
            cursor.putByte(Record.NOT_IN_USE.byteValue());
        }
    }

    protected void writeRecordData(RECORD record, PageCursor cursor) {
        cursor.putInt(((TokenRecord)record).getNameId());
    }
}

