/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.cursor;

import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.cursor.AbstractCachedStoreCursors;
import org.neo4j.storageengine.api.cursor.CursorType;

public class CachedStoreCursors
extends AbstractCachedStoreCursors {
    private final NeoStores neoStores;

    public CachedStoreCursors(NeoStores neoStores, CursorContext cursorContext) {
        super(cursorContext, RecordCursorTypes.MAX_TYPE + 1);
        this.neoStores = neoStores;
    }

    public PageCursor writeCursor(CursorType type) {
        switch (CachedStoreCursors.cast(type)) {
            case NODE_CURSOR: {
                return this.neoStores.getNodeStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case GROUP_CURSOR: {
                return this.neoStores.getRelationshipGroupStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case SCHEMA_CURSOR: {
                return this.neoStores.getSchemaStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case RELATIONSHIP_CURSOR: {
                return this.neoStores.getRelationshipStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case PROPERTY_CURSOR: {
                return this.neoStores.getPropertyStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case DYNAMIC_ARRAY_STORE_CURSOR: {
                return this.neoStores.getPropertyStore().getArrayStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case DYNAMIC_STRING_STORE_CURSOR: {
                return this.neoStores.getPropertyStore().getStringStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case DYNAMIC_LABEL_STORE_CURSOR: {
                return this.neoStores.getNodeStore().getDynamicLabelStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case DYNAMIC_REL_TYPE_TOKEN_CURSOR: {
                return this.neoStores.getRelationshipTypeTokenStore().getNameStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case REL_TYPE_TOKEN_CURSOR: {
                return this.neoStores.getRelationshipTypeTokenStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case DYNAMIC_PROPERTY_KEY_TOKEN_CURSOR: {
                return this.neoStores.getPropertyKeyTokenStore().getNameStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case PROPERTY_KEY_TOKEN_CURSOR: {
                return this.neoStores.getPropertyKeyTokenStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case DYNAMIC_LABEL_TOKEN_CURSOR: {
                return this.neoStores.getLabelTokenStore().getNameStore().openPageCursorForWriting(0L, this.cursorContext);
            }
            case LABEL_TOKEN_CURSOR: {
                return this.neoStores.getLabelTokenStore().openPageCursorForWriting(0L, this.cursorContext);
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + type + " of cursor was requested.");
    }

    protected PageCursor createReadCursor(CursorType type) {
        switch (CachedStoreCursors.cast(type)) {
            case NODE_CURSOR: {
                return this.neoStores.getNodeStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case GROUP_CURSOR: {
                return this.neoStores.getRelationshipGroupStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case SCHEMA_CURSOR: {
                return this.neoStores.getSchemaStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case RELATIONSHIP_CURSOR: {
                return this.neoStores.getRelationshipStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case PROPERTY_CURSOR: {
                return this.neoStores.getPropertyStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case DYNAMIC_ARRAY_STORE_CURSOR: {
                return this.neoStores.getPropertyStore().getArrayStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case DYNAMIC_STRING_STORE_CURSOR: {
                return this.neoStores.getPropertyStore().getStringStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case DYNAMIC_LABEL_STORE_CURSOR: {
                return this.neoStores.getNodeStore().getDynamicLabelStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case DYNAMIC_REL_TYPE_TOKEN_CURSOR: {
                return this.neoStores.getRelationshipTypeTokenStore().getNameStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case REL_TYPE_TOKEN_CURSOR: {
                return this.neoStores.getRelationshipTypeTokenStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case DYNAMIC_PROPERTY_KEY_TOKEN_CURSOR: {
                return this.neoStores.getPropertyKeyTokenStore().getNameStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case PROPERTY_KEY_TOKEN_CURSOR: {
                return this.neoStores.getPropertyKeyTokenStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case DYNAMIC_LABEL_TOKEN_CURSOR: {
                return this.neoStores.getLabelTokenStore().getNameStore().openPageCursorForReading(0L, this.cursorContext);
            }
            case LABEL_TOKEN_CURSOR: {
                return this.neoStores.getLabelTokenStore().openPageCursorForReading(0L, this.cursorContext);
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + type + "of cursor was requested.");
    }

    private static RecordCursorTypes cast(CursorType type) {
        if (type instanceof RecordCursorTypes) {
            return (RecordCursorTypes)type;
        }
        throw new IllegalArgumentException(String.format("%s(%s) is of incorrect type. Expected %s.", type, type.getClass().getSimpleName(), RecordCursorTypes.class.getSimpleName()));
    }
}

