/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;

public class SchemaRuleMigrationAccessImpl
implements SchemaRuleMigrationAccess {
    private final NeoStores neoStores;
    private final SchemaStorage schemaStorage;
    private final CursorContext cursorContext;
    private final MemoryTracker memoryTracker;
    private final StoreCursors storeCursors;

    SchemaRuleMigrationAccessImpl(NeoStores neoStores, SchemaStorage schemaStorage, CursorContext cursorContext, MemoryTracker memoryTracker, StoreCursors storeCursors) {
        this.neoStores = neoStores;
        this.schemaStorage = schemaStorage;
        this.cursorContext = cursorContext;
        this.memoryTracker = memoryTracker;
        this.storeCursors = storeCursors;
    }

    public Iterable<SchemaRule> getAll() {
        return this.schemaStorage.getAll(this.storeCursors);
    }

    public void writeSchemaRule(SchemaRule rule) throws KernelException {
        this.schemaStorage.writeSchemaRule(rule, this.cursorContext, this.memoryTracker, this.storeCursors);
    }

    public void close() throws IOException {
        this.storeCursors.close();
        this.neoStores.flush(this.cursorContext);
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.storeCursors, this.neoStores});
    }
}

