/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class ReadOnlyTransactionIdStore
implements TransactionIdStore {
    private final long transactionId;
    private final int transactionChecksum;
    private final LogPosition logPosition;

    public ReadOnlyTransactionIdStore(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, CursorContext cursorContext) throws IOException {
        long id = 0L;
        int checksum = 0;
        long logVersion = 0L;
        long byteOffset = 0L;
        if (NeoStores.isStorePresent(fs, RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout))) {
            Path neoStore = databaseLayout.metadataStore();
            String databaseName = databaseLayout.getDatabaseName();
            id = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID, databaseName, cursorContext);
            checksum = (int)MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, databaseName, cursorContext);
            logVersion = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, databaseName, cursorContext);
            byteOffset = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, databaseName, cursorContext);
        }
        this.transactionId = id;
        this.transactionChecksum = checksum;
        this.logPosition = new LogPosition(logVersion, byteOffset);
    }

    public long nextCommittingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public long committingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public long getLastCommittedTransactionId() {
        return this.transactionId;
    }

    public TransactionId getLastCommittedTransaction() {
        return new TransactionId(this.transactionId, this.transactionChecksum, 0L);
    }

    public TransactionId getUpgradeTransaction() {
        return this.getLastCommittedTransaction();
    }

    public long getLastClosedTransactionId() {
        return this.transactionId;
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        return new ClosedTransactionMetadata(this.transactionId, this.logPosition);
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long logByteOffset, long logVersion, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionClosed(long transactionId, long logVersion, long logByteOffset, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, boolean missingLogs, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void flush(CursorContext cursorContext) {
    }
}

