/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.LogCommandSerializationV4_2;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.util.Bits;

class LogCommandSerializationV4_3_D3
extends LogCommandSerializationV4_2 {
    static final LogCommandSerializationV4_3_D3 INSTANCE = new LogCommandSerializationV4_3_D3();

    LogCommandSerializationV4_3_D3() {
    }

    @Override
    KernelVersion version() {
        return KernelVersion.V4_3_D4;
    }

    @Override
    protected Command readMetaDataCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        MetaDataRecord before = LogCommandSerializationV4_3_D3.readMetaDataRecord(id, channel);
        MetaDataRecord after = LogCommandSerializationV4_3_D3.readMetaDataRecord(id, channel);
        return new Command.MetaDataCommand((LogCommandSerialization)this, before, after);
    }

    private static MetaDataRecord readMetaDataRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        long value = channel.getLong();
        MetaDataRecord record = new MetaDataRecord();
        record.setId(id);
        if (Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue())) {
            record.initialize(true, value);
        }
        return record;
    }

    @Override
    public void writeMetaDataCommand(WritableChannel channel, Command.MetaDataCommand command) throws IOException {
        channel.put((byte)19);
        channel.putLong(command.getKey());
        LogCommandSerializationV4_3_D3.writeMetaDataRecord(channel, (MetaDataRecord)command.getBefore());
        LogCommandSerializationV4_3_D3.writeMetaDataRecord(channel, (MetaDataRecord)command.getAfter());
    }

    private static void writeMetaDataRecord(WritableChannel channel, MetaDataRecord record) throws IOException {
        byte flags = Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue());
        channel.put(flags);
        channel.putLong(record.getValue());
    }

    @Override
    protected Command readGroupDegreeCommand(ReadableChannel channel) throws IOException {
        long key = channel.getLong();
        long delta = channel.getLong();
        return new Command.GroupDegreeCommand(Command.GroupDegreeCommand.groupIdFromCombinedKey(key), Command.GroupDegreeCommand.directionFromCombinedKey(key), delta);
    }

    @Override
    public void writeGroupDegreeCommand(WritableChannel channel, Command.GroupDegreeCommand command) throws IOException {
        channel.put((byte)20);
        channel.putLong(command.getKey());
        channel.putLong(command.delta());
    }

    @Override
    public void writeRelationshipGroupCommand(WritableChannel channel, Command.RelationshipGroupCommand command) throws IOException {
        int relType = Math.max(((RelationshipGroupRecord)command.getBefore()).getType(), ((RelationshipGroupRecord)command.getAfter()).getType());
        if (relType == Record.NULL_REFERENCE.intValue() || relType >>> 16 == 0) {
            channel.put((byte)9);
            channel.putLong(((RelationshipGroupRecord)command.getAfter()).getId());
            LogCommandSerializationV4_3_D3.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)command.getBefore());
            LogCommandSerializationV4_3_D3.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)command.getAfter());
        } else {
            channel.put((byte)21);
            channel.putLong(((RelationshipGroupRecord)command.getAfter()).getId());
            this.writeRelationshipGroupExtendedRecord(channel, (RelationshipGroupRecord)command.getBefore());
            this.writeRelationshipGroupExtendedRecord(channel, (RelationshipGroupRecord)command.getAfter());
        }
    }

    private static void writeRelationshipGroupRecord(WritableChannel channel, RelationshipGroupRecord record) throws IOException {
        byte flags = Bits.bitFlags((int)Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)Bits.bitFlag((boolean)record.isUseFixedReferences(), (int)16), (int)Bits.bitFlag((boolean)record.hasExternalDegreesOut(), (int)32), (int)Bits.bitFlag((boolean)record.hasExternalDegreesIn(), (int)64), (int)Bits.bitFlag((boolean)record.hasExternalDegreesLoop(), (int)128));
        channel.put(flags);
        channel.putShort((short)record.getType());
        channel.putLong(record.getNext());
        channel.putLong(record.getFirstOut());
        channel.putLong(record.getFirstIn());
        channel.putLong(record.getFirstLoop());
        channel.putLong(record.getOwningNode());
        if (record.hasSecondaryUnitId()) {
            channel.putLong(record.getSecondaryUnitId());
        }
    }

    private void writeRelationshipGroupExtendedRecord(WritableChannel channel, RelationshipGroupRecord record) throws IOException {
        byte flags = Bits.bitFlags((int)Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)Bits.bitFlag((boolean)record.isUseFixedReferences(), (int)16), (int)Bits.bitFlag((boolean)record.hasExternalDegreesOut(), (int)32), (int)Bits.bitFlag((boolean)record.hasExternalDegreesIn(), (int)64), (int)Bits.bitFlag((boolean)record.hasExternalDegreesLoop(), (int)128));
        channel.put(flags);
        channel.putShort((short)record.getType());
        channel.put((byte)(record.getType() >>> 16));
        channel.putLong(record.getNext());
        channel.putLong(record.getFirstOut());
        channel.putLong(record.getFirstIn());
        channel.putLong(record.getFirstLoop());
        channel.putLong(record.getOwningNode());
        if (record.hasSecondaryUnitId()) {
            channel.putLong(record.getSecondaryUnitId());
        }
    }

    @Override
    protected Command readRelationshipGroupCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = LogCommandSerializationV4_3_D3.readRelationshipGroupRecord(id, channel);
        RelationshipGroupRecord after = LogCommandSerializationV4_3_D3.readRelationshipGroupRecord(id, channel);
        LogCommandSerializationV4_3_D3.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipGroupRecord readRelationshipGroupRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        boolean hasExternalDegreesOut = Bits.bitFlag((int)flags, (int)32);
        boolean hasExternalDegreesIn = Bits.bitFlag((int)flags, (int)64);
        boolean hasExternalDegreesLoop = Bits.bitFlag((int)flags, (int)128);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setHasExternalDegreesOut(hasExternalDegreesOut);
        record.setHasExternalDegreesIn(hasExternalDegreesIn);
        record.setHasExternalDegreesLoop(hasExternalDegreesLoop);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    @Override
    protected Command readRelationshipGroupExtendedCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = LogCommandSerializationV4_3_D3.readRelationshipGroupExtendedRecord(id, channel);
        RelationshipGroupRecord after = LogCommandSerializationV4_3_D3.readRelationshipGroupExtendedRecord(id, channel);
        LogCommandSerializationV4_3_D3.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipGroupRecord readRelationshipGroupExtendedRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        boolean hasExternalDegreesOut = Bits.bitFlag((int)flags, (int)32);
        boolean hasExternalDegreesIn = Bits.bitFlag((int)flags, (int)64);
        boolean hasExternalDegreesLoop = Bits.bitFlag((int)flags, (int)128);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        type |= Numbers.unsignedByteToInt((byte)channel.get()) << 16;
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setHasExternalDegreesOut(hasExternalDegreesOut);
        record.setHasExternalDegreesIn(hasExternalDegreesIn);
        record.setHasExternalDegreesLoop(hasExternalDegreesLoop);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }
}

