/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.PositionAwareChannel;
import org.neo4j.storageengine.api.CommandReader;

public abstract class LogCommandSerialization
implements CommandReader {
    abstract KernelVersion version();

    public final Command read(ReadableChannel channel) throws IOException {
        byte commandType;
        while ((commandType = channel.get()) == 0) {
        }
        switch (commandType) {
            case 1: {
                return this.readNodeCommand(channel);
            }
            case 2: {
                return this.readPropertyCommand(channel);
            }
            case 5: {
                return this.readPropertyKeyTokenCommand(channel);
            }
            case 3: {
                return this.readRelationshipCommand(channel);
            }
            case 4: {
                return this.readRelationshipTypeTokenCommand(channel);
            }
            case 8: {
                return this.readLabelTokenCommand(channel);
            }
            case 9: {
                return this.readRelationshipGroupCommand(channel);
            }
            case 21: {
                return this.readRelationshipGroupExtendedCommand(channel);
            }
            case 16: {
                return this.readRelationshipCountsCommand(channel);
            }
            case 17: {
                return this.readNodeCountsCommand(channel);
            }
            case 18: {
                return this.readSchemaRuleCommand(channel);
            }
            case 7: {
                return this.readLegacySchemaRuleCommand(channel);
            }
            case 6: {
                return this.readNeoStoreCommand(channel);
            }
            case 19: {
                return this.readMetaDataCommand(channel);
            }
            case 20: {
                return this.readGroupDegreeCommand(channel);
            }
            case 10: {
                return this.readIndexDefineCommand(channel);
            }
            case 11: {
                return this.readIndexAddNodeCommand(channel);
            }
            case 12: {
                return this.readIndexAddRelationshipCommand(channel);
            }
            case 13: {
                return this.readIndexRemoveCommand(channel);
            }
            case 14: {
                return this.readIndexDeleteCommand(channel);
            }
            case 15: {
                return this.readIndexCreateCommand(channel);
            }
        }
        throw LogCommandSerialization.unknownCommandType(commandType, channel);
    }

    protected Command readNeoStoreCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readMetaDataCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readGroupDegreeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readSchemaRuleCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readLegacySchemaRuleCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readNodeCountsCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipCountsCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipGroupCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipGroupExtendedCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readLabelTokenCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipTypeTokenCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readPropertyKeyTokenCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readPropertyCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readNodeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexDefineCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexAddNodeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexAddRelationshipCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexCreateCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexDeleteCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexRemoveCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writePropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeRelationshipGroupCommand(WritableChannel channel, Command.RelationshipGroupCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeRelationshipTypeTokenCommand(WritableChannel channel, Command.RelationshipTypeTokenCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeLabelTokenCommand(WritableChannel channel, Command.LabelTokenCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writePropertyKeyTokenCommand(WritableChannel channel, Command.PropertyKeyTokenCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeSchemaRuleCommand(WritableChannel channel, Command.SchemaRuleCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeNodeCountsCommand(WritableChannel channel, Command.NodeCountsCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeRelationshipCountsCommand(WritableChannel channel, Command.RelationshipCountsCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeNeoStoreCommand(WritableChannel channel, Command.NeoStoreCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeMetaDataCommand(WritableChannel channel, Command.MetaDataCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeGroupDegreeCommand(WritableChannel channel, Command.GroupDegreeCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected static IOException unknownCommandType(byte commandType, ReadableChannel channel) throws IOException {
        String message = "Unknown command type[" + commandType + "]";
        if (channel instanceof PositionAwareChannel) {
            PositionAwareChannel logChannel = (PositionAwareChannel)channel;
            message = message + " near " + logChannel.getCurrentPosition();
        }
        return new IOException(message);
    }

    protected IOException unsupportedInThisVersionException() {
        return new IOException("Unsupported in this version: " + this.getClass().getSimpleName());
    }
}

