/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.GBPTreeGenericCountsStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;

public class GBPTreeRelationshipGroupDegreesStore
extends GBPTreeGenericCountsStore
implements RelationshipGroupDegreesStore {
    private static final String NAME = "Relationship group degrees store";
    static final byte TYPE_DEGREE = 3;
    private static final RelationshipGroupDegreesStore.Updater NO_OP_UPDATER = new RelationshipGroupDegreesStore.Updater(){

        @Override
        public void close() {
        }

        @Override
        public void increment(long groupId, RelationshipDirection direction, long delta) {
        }
    };

    public GBPTreeRelationshipGroupDegreesStore(PageCache pageCache, Path file, FileSystemAbstraction fileSystem, RecoveryCleanupWorkCollector recoveryCollector, DegreesRebuilder rebuilder, DatabaseReadOnlyChecker readOnlyChecker, PageCacheTracer pageCacheTracer, GBPTreeGenericCountsStore.Monitor monitor, String databaseName, int maxCacheSize, LogProvider userLogProvider) throws IOException {
        super(pageCache, file, fileSystem, recoveryCollector, (GBPTreeGenericCountsStore.Rebuilder)new RebuilderWrapper(rebuilder), readOnlyChecker, NAME, pageCacheTracer, monitor, databaseName, maxCacheSize, userLogProvider);
    }

    @Override
    public RelationshipGroupDegreesStore.Updater apply(long txId, CursorContext cursorContext) {
        CountUpdater updater = this.updater(txId, cursorContext);
        return updater != null ? new DegreeUpdater(updater) : NO_OP_UPDATER;
    }

    public RelationshipGroupDegreesStore.Updater directApply(CursorContext cursorContext) throws IOException {
        return new DegreeUpdater(this.directUpdater(true, cursorContext));
    }

    @Override
    public long degree(long groupId, RelationshipDirection direction, CursorContext cursorContext) {
        return this.read(GBPTreeRelationshipGroupDegreesStore.degreeKey(groupId, direction), cursorContext);
    }

    @Override
    public void accept(RelationshipGroupDegreesStore.GroupDegreeVisitor visitor, CursorContext cursorContext) {
        this.visitAllCounts((key, count) -> visitor.degree(GBPTreeRelationshipGroupDegreesStore.groupIdOf(key), GBPTreeRelationshipGroupDegreesStore.directionOf(key), count), cursorContext);
    }

    static CountsKey degreeKey(long groupId, RelationshipDirection direction) {
        return new CountsKey(3, groupId << 2 | (long)direction.id(), 0);
    }

    static String keyToString(CountsKey key) {
        if (key.type == 3) {
            return String.format("Degree[groupId:%d, direction:%s]", GBPTreeRelationshipGroupDegreesStore.groupIdOf(key), GBPTreeRelationshipGroupDegreesStore.directionOf(key));
        }
        throw new IllegalArgumentException("Unknown type " + key.type);
    }

    private static RelationshipDirection directionOf(CountsKey key) {
        return RelationshipDirection.ofId((int)((int)(key.first & 3L)));
    }

    private static long groupIdOf(CountsKey key) {
        return key.first >> 2;
    }

    public static void dump(PageCache pageCache, Path file, PrintStream out, CursorContext cursorContext) throws IOException {
        GBPTreeGenericCountsStore.dump((PageCache)pageCache, (Path)file, (PrintStream)out, (String)"neo4j", (String)NAME, (CursorContext)cursorContext, GBPTreeRelationshipGroupDegreesStore::keyToString);
    }

    public static class EmptyDegreesRebuilder
    implements DegreesRebuilder {
        private final long lastTxId;

        public EmptyDegreesRebuilder(long lastTxId) {
            this.lastTxId = lastTxId;
        }

        @Override
        public void rebuild(RelationshipGroupDegreesStore.Updater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
        }

        @Override
        public long lastCommittedTxId() {
            return this.lastTxId;
        }
    }

    private static class RebuilderWrapper
    implements GBPTreeGenericCountsStore.Rebuilder {
        private final DegreesRebuilder rebuilder;

        RebuilderWrapper(DegreesRebuilder rebuilder) {
            this.rebuilder = rebuilder;
        }

        public void rebuild(CountUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
            this.rebuilder.rebuild(new DegreeUpdater(updater), cursorContext, memoryTracker);
        }

        public long lastCommittedTxId() {
            return this.rebuilder.lastCommittedTxId();
        }
    }

    public static interface DegreesRebuilder {
        public void rebuild(RelationshipGroupDegreesStore.Updater var1, CursorContext var2, MemoryTracker var3);

        public long lastCommittedTxId();
    }

    private static class DegreeUpdater
    implements RelationshipGroupDegreesStore.Updater,
    AutoCloseable {
        private final CountUpdater actual;

        DegreeUpdater(CountUpdater actual) {
            this.actual = actual;
        }

        @Override
        public void increment(long groupId, RelationshipDirection direction, long delta) {
            this.actual.increment(GBPTreeRelationshipGroupDegreesStore.degreeKey(groupId, direction), delta);
        }

        @Override
        public void close() {
            this.actual.close();
        }
    }
}

