/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.PropertyValueLookup;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;

class NodeInputIdPropertyLookup
implements PropertyValueLookup {
    private final PropertyStore propertyStore;
    private final PropertyRecord propertyRecord;
    private final StoreCursors storeCursors;

    NodeInputIdPropertyLookup(PropertyStore propertyStore, StoreCursors storeCursors) {
        this.propertyStore = propertyStore;
        this.propertyRecord = propertyStore.newRecord();
        this.storeCursors = storeCursors;
    }

    public Object lookupProperty(long nodeId) {
        this.propertyStore.getRecordByCursor(nodeId, this.propertyRecord, RecordLoad.CHECK, this.storeCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR));
        if (!this.propertyRecord.inUse()) {
            return null;
        }
        return this.propertyRecord.iterator().next().newPropertyValue(this.propertyStore, this.storeCursors).asObject();
    }
}

