/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import java.nio.ByteBuffer;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.bufferpool.ByteBufferManger;

public class NettyMemoryManagerWrapper
implements ByteBufAllocator {
    private static final int DEFAULT_INITIAL_CAPACITY = 256;
    private static final int DEFAULT_MAX_CAPACITY = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_COMPONENTS = 16;
    private static final int CALCULATE_THRESHOLD = (int)ByteUnit.kibiBytes((long)512L);
    private final ByteBufferManger pooledBufferManger;
    private final boolean delegateForCapacityCalculation;

    public NettyMemoryManagerWrapper(ByteBufferManger pooledBufferManger) {
        this.pooledBufferManger = pooledBufferManger;
        this.delegateForCapacityCalculation = true;
    }

    private NettyMemoryManagerWrapper(ByteBufferManger pooledBufferManger, boolean delegateForCapacityCalculation) {
        this.pooledBufferManger = pooledBufferManger;
        this.delegateForCapacityCalculation = delegateForCapacityCalculation;
    }

    public ByteBuf buffer() {
        return this.directBuffer();
    }

    public ByteBuf buffer(int initialCapacity) {
        return this.directBuffer(initialCapacity);
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.directBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf ioBuffer() {
        return this.directBuffer();
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return this.directBuffer(initialCapacity);
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.directBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf heapBuffer() {
        return this.heapBuffer(256);
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        return this.heapBuffer(initialCapacity, Integer.MAX_VALUE);
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        return new HeapBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf directBuffer() {
        return this.newDirectBuffer(256, false, Integer.MAX_VALUE);
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return this.directBuffer(initialCapacity, Integer.MAX_VALUE);
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.newDirectBuffer(initialCapacity, true, maxCapacity);
    }

    public CompositeByteBuf compositeBuffer() {
        return this.compositeBuffer(16);
    }

    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return this.compositeDirectBuffer(maxNumComponents);
    }

    public CompositeByteBuf compositeHeapBuffer() {
        return this.compositeHeapBuffer(16);
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return new CompositeByteBuf((ByteBufAllocator)new HeapBufferAllocator(this.pooledBufferManger), false, maxNumComponents);
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return this.compositeDirectBuffer(16);
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return new CompositeByteBuf((ByteBufAllocator)this, true, maxNumComponents);
    }

    public boolean isDirectBufferPooled() {
        return true;
    }

    public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
        int newCapacity;
        int capacityFromPool;
        if (this.delegateForCapacityCalculation && (capacityFromPool = this.pooledBufferManger.recommendNewCapacity(minNewCapacity, maxCapacity)) != -1) {
            return capacityFromPool;
        }
        if (minNewCapacity == CALCULATE_THRESHOLD) {
            return CALCULATE_THRESHOLD;
        }
        if (minNewCapacity > CALCULATE_THRESHOLD) {
            newCapacity = minNewCapacity / CALCULATE_THRESHOLD * CALCULATE_THRESHOLD;
            newCapacity = newCapacity > maxCapacity - CALCULATE_THRESHOLD ? maxCapacity : (newCapacity += CALCULATE_THRESHOLD);
            return newCapacity;
        }
        for (newCapacity = 64; newCapacity < minNewCapacity; newCapacity <<= 1) {
        }
        return Math.min(newCapacity, maxCapacity);
    }

    private ByteBuf newDirectBuffer(int initialCapacity, final boolean forceInitialCapacity, int maxCapacity) {
        return new UnpooledDirectByteBuf(this, initialCapacity, maxCapacity){
            private boolean slicingUsed;

            protected ByteBuffer allocateDirect(int initialCapacity) {
                ByteBuffer buffer = NettyMemoryManagerWrapper.this.pooledBufferManger.acquire(initialCapacity);
                if (forceInitialCapacity && buffer.capacity() > initialCapacity) {
                    this.slicingUsed = true;
                    return buffer.slice();
                }
                return buffer;
            }

            protected void freeDirect(ByteBuffer buffer) {
                ByteBuffer original;
                if (this.slicingUsed && (original = UnsafeUtil.getOriginalBufferFromSlice((ByteBuffer)buffer)) != null) {
                    NettyMemoryManagerWrapper.this.pooledBufferManger.release(original);
                    return;
                }
                NettyMemoryManagerWrapper.this.pooledBufferManger.release(buffer);
            }
        };
    }

    private static class HeapBufferAllocator
    extends NettyMemoryManagerWrapper {
        HeapBufferAllocator(ByteBufferManger pooledBufferManger) {
            super(pooledBufferManger, false);
        }
    }

    private class HeapBuffer
    extends UnpooledHeapByteBuf {
        HeapBuffer(int initialCapacity, int maxCapacity) {
            super((ByteBufAllocator)new HeapBufferAllocator(NettyMemoryManagerWrapper.this.pooledBufferManger), initialCapacity, maxCapacity);
        }

        protected byte[] allocateArray(int initialCapacity) {
            NettyMemoryManagerWrapper.this.pooledBufferManger.getHeapBufferMemoryTracker().allocateHeap((long)initialCapacity);
            return super.allocateArray(initialCapacity);
        }

        protected void freeArray(byte[] array) {
            int length = array.length;
            super.freeArray(array);
            NettyMemoryManagerWrapper.this.pooledBufferManger.getHeapBufferMemoryTracker().releaseHeap((long)length);
        }
    }
}

