/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import org.apache.commons.lang3.StringUtils;
import org.neo4j.server.startup.AbstractUnixBootloaderOs;
import org.neo4j.server.startup.BootFailureException;
import org.neo4j.server.startup.BootloaderContext;

class UnixBootloaderOs
extends AbstractUnixBootloaderOs {
    private static final int MIN_ALLOWED_OPEN_FILES = 40000;

    UnixBootloaderOs(BootloaderContext ctx) {
        super(ctx);
    }

    private static int getFileHandleLimit() {
        try {
            String result = UnixBootloaderOs.executeCommand(new String[]{"bash", "-c", "ulimit -n"});
            return StringUtils.isNumeric((CharSequence)result) ? Integer.parseInt(result) : Integer.MAX_VALUE;
        }
        catch (RuntimeException runtimeException) {
            return Integer.MAX_VALUE;
        }
    }

    @Override
    long start() {
        this.checkLimits();
        return super.start();
    }

    @Override
    long console() throws BootFailureException {
        this.checkLimits();
        return super.console();
    }

    private void checkLimits() {
        int limit = UnixBootloaderOs.getFileHandleLimit();
        if (limit < 40000) {
            this.ctx.err.printf("WARNING: Max %s open files allowed, minimum of %s recommended. See the Neo4j manual.%n", limit, 40000);
        }
    }
}

