/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.server.startup.BootFailureException;
import org.neo4j.server.startup.BootProcessFailureException;
import org.neo4j.server.startup.BootloaderContext;
import org.neo4j.server.startup.BootloaderOsAbstraction;
import org.neo4j.time.Stopwatch;

class Bootloader {
    static final int EXIT_CODE_OK = 0;
    static final int EXIT_CODE_RUNNING = 1;
    static final int EXIT_CODE_NOT_RUNNING = 3;
    static final String ENV_NEO4J_HOME = "NEO4J_HOME";
    static final String ENV_NEO4J_CONF = "NEO4J_CONF";
    static final String ENV_NEO4J_SHUTDOWN_TIMEOUT = "NEO4J_SHUTDOWN_TIMEOUT";
    static final String ENV_NEO4J_START_WAIT = "NEO4J_START_WAIT";
    static final String ENV_HEAP_SIZE = "HEAP_SIZE";
    static final String ENV_JAVA_OPTS = "JAVA_OPTS";
    static final String PROP_JAVA_CP = "java.class.path";
    static final String PROP_VM_NAME = "java.vm.name";
    static final String PROP_VM_VENDOR = "java.vm.vendor";
    static final String PROP_BASEDIR = "basedir";
    static final String ARG_EXPAND_COMMANDS = "--expand-commands";
    static final Path DEFAULT_CONFIG_LOCATION = Path.of("conf", new String[0]);
    static final int DEFAULT_NEO4J_SHUTDOWN_TIMEOUT = 120;
    private final BootloaderContext ctx;

    Bootloader(BootloaderContext ctx) {
        this.ctx = ctx;
    }

    int start() {
        BootloaderOsAbstraction os = this.ctx.os();
        this.ctx.validateConfig();
        Long pid = os.getPidIfRunning();
        if (pid != null) {
            this.ctx.out.printf("Neo4j is already running%s.%n", Bootloader.pidIfKnown(pid));
            return 1;
        }
        this.printDirectories();
        this.ctx.out.println("Starting Neo4j.");
        try {
            pid = os.start();
        }
        catch (BootFailureException e) {
            this.ctx.out.println("Unable to start. See user log for details.");
            throw e;
        }
        Configuration config = this.ctx.config();
        Object serverLocation = (Boolean)config.get(HttpsConnector.enabled) != false ? "It is available at https://" + config.get(HttpsConnector.listen_address) : ((Boolean)config.get(HttpConnector.enabled) != false ? "It is available at http://" + config.get(HttpConnector.listen_address) : "Both http & https are disabled.");
        this.ctx.out.printf("Started neo4j%s. %s%n", Bootloader.pidIfKnown(pid), serverLocation);
        this.ctx.out.println("There may be a short delay until the server is ready.");
        return 0;
    }

    private void printDirectories() {
        Configuration config = this.ctx.config();
        this.ctx.out.println("Directories in use:");
        this.ctx.out.println("home:         " + this.ctx.home().toAbsolutePath());
        this.ctx.out.println("config:       " + this.ctx.confDir().toAbsolutePath());
        this.ctx.out.println("logs:         " + ((Path)config.get(GraphDatabaseSettings.logs_directory)).toAbsolutePath());
        this.ctx.out.println("plugins:      " + ((Path)config.get(GraphDatabaseSettings.plugin_dir)).toAbsolutePath());
        this.ctx.out.println("import:       " + ((Path)config.get(GraphDatabaseSettings.load_csv_file_url_root)).toAbsolutePath());
        this.ctx.out.println("data:         " + ((Path)config.get(GraphDatabaseSettings.data_directory)).toAbsolutePath());
        this.ctx.out.println("certificates: " + this.ctx.home().resolve("certificates").toAbsolutePath());
        this.ctx.out.println("licenses:     " + ((Path)config.get(GraphDatabaseSettings.licenses_directory)).toAbsolutePath());
        this.ctx.out.println("run:          " + ((Path)config.get(BootloaderSettings.run_directory)).toAbsolutePath());
    }

    int console(boolean dryRun) {
        boolean alreadyRunning;
        BootloaderOsAbstraction os = this.ctx.os();
        this.ctx.validateConfig();
        Long pid = os.getPidIfRunning();
        boolean bl = alreadyRunning = pid != null;
        if (alreadyRunning) {
            this.ctx.out.printf("Neo4j is already running%s.%n", Bootloader.pidIfKnown(pid));
        }
        if (dryRun) {
            List<String> args = os.buildStandardStartArguments();
            String cmd = args.stream().map(Bootloader::quoteArgument).collect(Collectors.joining(" "));
            this.ctx.out.println(cmd);
            return alreadyRunning ? 1 : 0;
        }
        if (alreadyRunning) {
            return 1;
        }
        this.printDirectories();
        this.ctx.out.println("Starting Neo4j.");
        os.console();
        return 0;
    }

    private static String pidIfKnown(long pid) {
        return pid != Long.MAX_VALUE ? " (pid:" + pid + ")" : "";
    }

    int stop() {
        BootloaderOsAbstraction os = this.ctx.os();
        Long pid = os.getPidIfRunning();
        if (pid == null) {
            this.ctx.out.println("Neo4j is not running.");
            return 0;
        }
        this.ctx.out.print("Stopping Neo4j.");
        int timeout = this.ctx.getEnv(ENV_NEO4J_SHUTDOWN_TIMEOUT, 120, SettingValueParsers.INT);
        Stopwatch stopwatch = Stopwatch.start();
        os.stop(pid);
        int printCount = 0;
        do {
            if (!os.isRunning(pid)) {
                this.ctx.out.println(" stopped.");
                return 0;
            }
            if (stopwatch.hasTimedOut((long)printCount, TimeUnit.SECONDS)) {
                ++printCount;
                this.ctx.out.print(".");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while (!stopwatch.hasTimedOut((long)timeout, TimeUnit.SECONDS));
        this.ctx.out.println(" failed to stop.");
        this.ctx.out.printf("Neo4j%s took more than %d seconds to stop.%n", Bootloader.pidIfKnown(pid), stopwatch.elapsed(TimeUnit.SECONDS));
        this.ctx.out.printf("Please see %s for details.%n", this.ctx.config().get(GraphDatabaseSettings.store_user_log_path));
        return 1;
    }

    int restart() {
        int stopCode = this.stop();
        if (stopCode != 0) {
            return stopCode;
        }
        return this.start();
    }

    int status() {
        Long pid = this.ctx.os().getPidIfRunning();
        if (pid == null) {
            this.ctx.out.println("Neo4j is not running.");
            return 3;
        }
        this.ctx.out.printf("Neo4j is running%s%n", pid != Long.MAX_VALUE ? " at pid " + pid : "");
        return 0;
    }

    int installService() {
        this.ctx.validateConfig();
        if (this.ctx.os().serviceInstalled()) {
            this.ctx.out.println("Neo4j service is already installed");
            return 1;
        }
        this.ctx.os().installService();
        this.ctx.out.println("Neo4j service installed.");
        return 0;
    }

    int uninstallService() {
        if (!this.ctx.os().serviceInstalled()) {
            this.ctx.out.println("Neo4j service is not installed");
            return 0;
        }
        this.ctx.os().uninstallService();
        this.ctx.out.println("Neo4j service uninstalled.");
        return 0;
    }

    int updateService() {
        this.ctx.validateConfig();
        if (!this.ctx.os().serviceInstalled()) {
            this.ctx.out.println("Neo4j service is not installed");
            return 1;
        }
        this.ctx.os().updateService();
        this.ctx.out.println("Neo4j service updated.");
        return 0;
    }

    int admin() {
        this.ctx.err.printf("Selecting JVM - Version:%s, Name:%s, Vendor:%s%n", this.ctx.version(), this.ctx.getProp(PROP_VM_NAME), this.ctx.getProp(PROP_VM_VENDOR));
        try {
            this.ctx.validateConfig();
            this.ctx.os().admin();
            return 0;
        }
        catch (BootProcessFailureException e) {
            return e.getExitCode();
        }
    }

    private static String quoteArgument(String arg) {
        String singleQuote = "'";
        String doubleQuote = "\"";
        arg = ((String)arg).trim();
        while (((String)arg).length() > 2 && (((String)arg).startsWith("'") && ((String)arg).endsWith("'") || ((String)arg).startsWith("\"") && ((String)arg).endsWith("\""))) {
            arg = ((String)arg).substring(1, ((String)arg).length() - 1);
        }
        if (((String)arg).contains("\"")) {
            if (((String)arg).contains("'")) {
                throw new BootFailureException("`" + (String)arg + "` contains both single and double quotes. Can not be correctly quoted for commandline.");
            }
            arg = "'" + (String)arg + "'";
        } else if (((String)arg).contains("'") || ((String)arg).contains(" ")) {
            arg = "\"" + (String)arg + "\"";
        }
        return arg;
    }
}

