/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.annotations.api.IgnoreApiCheck;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseInfoService;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.context.EditionDatabaseComponents;
import org.neo4j.internal.collector.DataCollectorProcedures;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.fs.watcher.FileWatchEventListenerFactory;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.layout.CommonDatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.net.DefaultNetworkConnectionTracker;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.util.watcher.DefaultFileDeletionListenerFactory;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.procedure.builtin.BuiltInDbmsProcedures;
import org.neo4j.procedure.builtin.BuiltInProcedures;
import org.neo4j.procedure.builtin.FulltextProcedures;
import org.neo4j.procedure.builtin.TokenProcedures;
import org.neo4j.procedure.builtin.routing.AbstractRoutingProcedureInstaller;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;
import org.neo4j.procedure.builtin.routing.RoutingOption;
import org.neo4j.procedure.builtin.routing.RoutingTableTTLProvider;
import org.neo4j.procedure.builtin.routing.ServerSideRoutingTableProvider;
import org.neo4j.procedure.builtin.routing.SimpleClientRoutingDomainChecker;
import org.neo4j.procedure.builtin.routing.SingleAddressRoutingTableProvider;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.time.SystemNanoClock;

@IgnoreApiCheck
public abstract class AbstractEditionModule {
    protected NetworkConnectionTracker connectionTracker;
    protected ConstraintSemantics constraintSemantics;
    protected Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory;
    protected SecurityProvider securityProvider;
    protected DefaultDatabaseResolver defaultDatabaseResolver;
    protected DatabaseReferenceRepository databaseReferenceRepo;

    public abstract EditionDatabaseComponents createDatabaseComponents(NamedDatabaseId var1);

    protected static DatabaseLayoutWatcher createDatabaseFileSystemWatcher(FileWatcher watcher, DatabaseLayout databaseLayout, LogService logging, Predicate<String> fileNameFilter) {
        DefaultFileDeletionListenerFactory listenerFactory = new DefaultFileDeletionListenerFactory(databaseLayout, logging, fileNameFilter);
        return new DatabaseLayoutWatcher(watcher, databaseLayout, (FileWatchEventListenerFactory)listenerFactory);
    }

    public void registerProcedures(GlobalProcedures globalProcedures, ProcedureConfig procedureConfig, GlobalModule globalModule, DatabaseManager<?> databaseManager) throws KernelException {
        globalProcedures.registerProcedure(BuiltInProcedures.class);
        globalProcedures.registerProcedure(TokenProcedures.class);
        globalProcedures.registerProcedure(BuiltInDbmsProcedures.class);
        globalProcedures.registerProcedure(FulltextProcedures.class);
        globalProcedures.registerProcedure(DataCollectorProcedures.class);
        TemporalFunction.registerTemporalFunctions((GlobalProcedures)globalProcedures, (ProcedureConfig)procedureConfig);
        this.registerEditionSpecificProcedures(globalProcedures, databaseManager);
        AbstractRoutingProcedureInstaller routingProcedureInstaller = this.createRoutingProcedureInstaller(globalModule, databaseManager, (ClientRoutingDomainChecker)globalModule.getGlobalDependencies().resolveDependency(ClientRoutingDomainChecker.class), this.defaultDatabaseResolver);
        routingProcedureInstaller.install(globalProcedures);
    }

    public ClientRoutingDomainChecker createClientRoutingDomainChecker(GlobalModule globalModule) {
        Config config = globalModule.getGlobalConfig();
        ClientRoutingDomainChecker domainChecker = SimpleClientRoutingDomainChecker.fromConfig((Config)config, (LogProvider)globalModule.getLogService().getInternalLogProvider());
        globalModule.getGlobalDependencies().satisfyDependencies(new Object[]{domainChecker});
        return domainChecker;
    }

    protected abstract void registerEditionSpecificProcedures(GlobalProcedures var1, DatabaseManager<?> var2) throws KernelException;

    protected abstract AbstractRoutingProcedureInstaller createRoutingProcedureInstaller(GlobalModule var1, DatabaseManager<?> var2, ClientRoutingDomainChecker var3, DefaultDatabaseResolver var4);

    protected abstract AuthConfigProvider createAuthConfigProvider(GlobalModule var1);

    public abstract <DB extends DatabaseContext> DatabaseManager<DB> createDatabaseManager(GlobalModule var1);

    public abstract SystemGraphInitializer createSystemGraphInitializer(GlobalModule var1);

    public abstract void registerSystemGraphComponents(SystemGraphComponents var1, GlobalModule var2);

    public abstract void createSecurityModule(GlobalModule var1);

    protected static NetworkConnectionTracker createConnectionTracker() {
        return new DefaultNetworkConnectionTracker();
    }

    public DatabaseTransactionStats createTransactionMonitor() {
        return new DatabaseTransactionStats();
    }

    public ConstraintSemantics getConstraintSemantics() {
        return this.constraintSemantics;
    }

    public Function<DatabaseLayout, DatabaseLayoutWatcher> getWatcherServiceFactory() {
        return this.watcherServiceFactory;
    }

    public NetworkConnectionTracker getConnectionTracker() {
        return this.connectionTracker;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public abstract void createDefaultDatabaseResolver(GlobalModule var1);

    public void setDefaultDatabaseResolver(DefaultDatabaseResolver defaultDatabaseResolver) {
        this.defaultDatabaseResolver = defaultDatabaseResolver;
    }

    public DefaultDatabaseResolver getDefaultDatabaseResolver() {
        return this.defaultDatabaseResolver;
    }

    public abstract QueryEngineProvider getQueryEngineProvider();

    public abstract void bootstrapFabricServices();

    public abstract BoltGraphDatabaseManagementServiceSPI createBoltDatabaseManagementServiceProvider(Dependencies var1, DatabaseManagementService var2, Monitors var3, SystemNanoClock var4, LogService var5);

    public AuthManager getBoltAuthManager(DependencyResolver dependencyResolver) {
        return (AuthManager)dependencyResolver.resolveDependency(AuthManager.class);
    }

    public AuthManager getBoltInClusterAuthManager() {
        return this.securityProvider.inClusterAuthManager();
    }

    public AuthManager getBoltLoopbackAuthManager() {
        return this.securityProvider.loopbackAuthManager();
    }

    public abstract DatabaseStartupController getDatabaseStartupController();

    public abstract Lifecycle createWebServer(DatabaseManagementService var1, Dependencies var2, Config var3, LogProvider var4, DbmsInfo var5);

    public abstract DbmsRuntimeRepository createAndRegisterDbmsRuntimeRepository(GlobalModule var1, DatabaseManager<?> var2, Dependencies var3, DbmsRuntimeSystemGraphComponent var4);

    protected ServerSideRoutingTableProvider serverSideRoutingTableProvider(GlobalModule globalModule) {
        ConnectorPortRegister portRegister = globalModule.getConnectorPortRegister();
        Config config = globalModule.getGlobalConfig();
        LogProvider logProvider = globalModule.getLogService().getInternalLogProvider();
        RoutingTableTTLProvider ttlProvider = RoutingTableTTLProvider.ttlFromConfig((Config)config);
        return new SingleAddressRoutingTableProvider(portRegister, RoutingOption.ROUTE_WRITE_AND_READ, config, logProvider, ttlProvider);
    }

    public abstract DatabaseInfoService createDatabaseInfoService(DatabaseManager<?> var1);

    public abstract ReadOnlyDatabases getReadOnlyChecker();

    protected static Predicate<String> defaultFileWatcherFilter() {
        return Predicates.any((Predicate[])new Predicate[]{TransactionLogFilesHelper.DEFAULT_FILENAME_PREDICATE, filename -> filename.contains(CommonDatabaseFile.LABEL_SCAN_STORE.getName()) || filename.contains(CommonDatabaseFile.RELATIONSHIP_TYPE_SCAN_STORE.getName())});
    }
}

