/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.EnumMap;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV2_3;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV4_0;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV4_3;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV4_4;
import org.neo4j.util.Preconditions;

public class LogEntryParserSets {
    private static final EnumMap<KernelVersion, LogEntryParserSet> PARSER_SETS = new EnumMap(KernelVersion.class);

    public static LogEntryParserSet parserSet(KernelVersion version) {
        LogEntryParserSet parserSet = PARSER_SETS.get(version);
        Preconditions.checkState((parserSet != null ? 1 : 0) != 0, (String)"No log entries version matching %s", (Object[])new Object[]{version});
        return parserSet;
    }

    static {
        PARSER_SETS.put(KernelVersion.V2_3, new LogEntryParserSetV2_3());
        PARSER_SETS.put(KernelVersion.V4_0, new LogEntryParserSetV4_0());
        PARSER_SETS.put(KernelVersion.V4_2, new LogEntryParserSetV4_2());
        PARSER_SETS.put(KernelVersion.V4_3_D4, new LogEntryParserSetV4_3());
        PARSER_SETS.put(KernelVersion.V4_4, new LogEntryParserSetV4_4());
    }
}

