module Msf
module Exploit::Windows_Constants

  ##
  #
  # Access Types
  # winnt.h
  #
  ##

  STANDARD_RIGHTS_REQUIRED = 0x000F0000

  ##
  #
  # SVCCTL Protocol Functions
  # http://msdn.microsoft.com/en-us/library/cc245920.aspxa
  #
  ##

  CLOSE_SERVICE_HANDLE = 0x00
  CONTROL_SERVICE = 0x01
  DELETE_SERVICE = 0x02
  QUERY_SERVICE_STATUS = 0x05
  CHANGE_SERVICE_CONFIG_W = 0x0b
  CREATE_SERVICE_W = 0x0c
  OPEN_SC_MANAGER_W = 0x0f
  OPEN_SERVICE_W = 0x10
  CHANGE_SERVICE_CONFIG2_W = 0x25

  ##
  #
  # Services
  # winsvc.h
  ##

  SERVICE_WIN32_OWN_PROCESS = 0x10
  SERVICE_INTERACTIVE_PROCESS = 0x100

  SERVICE_BOOT_START = 0x00
  SERVICE_SYSTEM_START = 0x01
  SERVICE_AUTO_START = 0x02
  SERVICE_DEMAND_START = 0x03
  SERVICE_DISABLED = 0x04

  SERVICE_ERROR_IGNORE = 0x0

  SERVICE_NO_CHANGE =            0xffffffff
  SERVICE_ACTIVE =               0x00000001
  SERVICE_INACTIVE =             0x00000002
  SERVICE_STATE_ALL =            (SERVICE_ACTIVE   |
                                  SERVICE_INACTIVE)
  SERVICE_CONTROL_STOP =                 0x00000001
  SERVICE_CONTROL_PAUSE =                0x00000002
  SERVICE_CONTROL_CONTINUE =             0x00000003
  SERVICE_CONTROL_INTERROGATE =          0x00000004
  SERVICE_CONTROL_SHUTDOWN =             0x00000005
  SERVICE_CONTROL_PARAMCHANGE =          0x00000006
  SERVICE_CONTROL_NETBINDADD =           0x00000007
  SERVICE_CONTROL_NETBINDREMOVE =        0x00000008
  SERVICE_CONTROL_NETBINDENABLE =        0x00000009
  SERVICE_CONTROL_NETBINDDISABLE =       0x0000000A
  SERVICE_CONTROL_DEVICEEVENT =          0x0000000B
  SERVICE_CONTROL_HARDWAREPROFILECHANGE =0x0000000C
  SERVICE_CONTROL_POWEREVENT =           0x0000000D
  SERVICE_CONTROL_SESSIONCHANGE =        0x0000000E
  SERVICE_CONTROL_PRESHUTDOWN =          0x0000000F
  SERVICE_CONTROL_TIMECHANGE =           0x00000010
  SERVICE_CONTROL_TRIGGEREVENT =         0x00000020
  SERVICE_STOPPED =                      0x00000001
  SERVICE_START_PENDING =                0x00000002
  SERVICE_STOP_PENDING =                 0x00000003
  SERVICE_RUNNING =                      0x00000004
  SERVICE_CONTINUE_PENDING =             0x00000005
  SERVICE_PAUSE_PENDING =                0x00000006
  SERVICE_PAUSED =                       0x00000007
  SERVICE_ACCEPT_STOP =                  0x00000001
  SERVICE_ACCEPT_PAUSE_CONTINUE =        0x00000002
  SERVICE_ACCEPT_SHUTDOWN =              0x00000004
  SERVICE_ACCEPT_PARAMCHANGE =           0x00000008
  SERVICE_ACCEPT_NETBINDCHANGE =         0x00000010
  SERVICE_ACCEPT_HARDWAREPROFILECHANGE = 0x00000020
  SERVICE_ACCEPT_POWEREVENT =            0x00000040
  SERVICE_ACCEPT_SESSIONCHANGE =         0x00000080
  SERVICE_ACCEPT_PRESHUTDOWN =           0x00000100
  SERVICE_ACCEPT_TIMECHANGE =            0x00000200
  SERVICE_ACCEPT_TRIGGEREVENT =          0x00000400
  SC_MANAGER_CONNECT =            0x0001
  SC_MANAGER_CREATE_SERVICE =     0x0002
  SC_MANAGER_ENUMERATE_SERVICE =  0x0004
  SC_MANAGER_LOCK =               0x0008
  SC_MANAGER_QUERY_LOCK_STATUS =  0x0010
  SC_MANAGER_MODIFY_BOOT_CONFIG = 0x0020

  SC_MANAGER_ALL_ACCESS =        (STANDARD_RIGHTS_REQUIRED      |
                                          SC_MANAGER_CONNECT            |
                                          SC_MANAGER_CREATE_SERVICE     |
                                          SC_MANAGER_ENUMERATE_SERVICE  |
                                          SC_MANAGER_LOCK               |
                                          SC_MANAGER_QUERY_LOCK_STATUS  |
                                          SC_MANAGER_MODIFY_BOOT_CONFIG)

  SERVICE_QUERY_CONFIG =         0x0001
  SERVICE_CHANGE_CONFIG =        0x0002
  SERVICE_QUERY_STATUS =         0x0004
  SERVICE_ENUMERATE_DEPENDENTS = 0x0008
  SERVICE_START =                0x0010
  SERVICE_STOP =                 0x0020
  SERVICE_PAUSE_CONTINUE =       0x0040
  SERVICE_INTERROGATE =          0x0080
  SERVICE_USER_DEFINED_CONTROL = 0x0100
  SERVICE_ALL_ACCESS =           (STANDARD_RIGHTS_REQUIRED     | \
                                          SERVICE_QUERY_CONFIG         | \
                                          SERVICE_CHANGE_CONFIG        | \
                                          SERVICE_QUERY_STATUS         | \
                                          SERVICE_ENUMERATE_DEPENDENTS | \
                                          SERVICE_START                | \
                                          SERVICE_STOP                 | \
                                          SERVICE_PAUSE_CONTINUE       | \
                                          SERVICE_INTERROGATE          | \
                                          SERVICE_USER_DEFINED_CONTROL)

  SERVICE_RUNS_IN_SYSTEM_PROCESS =  0x00000001
  SERVICE_CONFIG_DESCRIPTION =              1
  SERVICE_CONFIG_FAILURE_ACTIONS =          2
  SERVICE_CONFIG_DELAYED_AUTO_START_INFO =  3
  SERVICE_CONFIG_FAILURE_ACTIONS_FLAG =     4
  SERVICE_CONFIG_SERVICE_SID_INFO =         5
  SERVICE_CONFIG_REQUIRED_PRIVILEGES_INFO = 6
  SERVICE_CONFIG_PRESHUTDOWN_INFO =         7
  SERVICE_CONFIG_TRIGGER_INFO =             8
  SERVICE_CONFIG_PREFERRED_NODE =           9
  SERVICE_CONFIG_LAUNCH_PROTECTED =         12

end
end
