//start of CRC16.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * CRC16.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.util.zip.Checksum;

//import exceptions

/**
 * CRC16lZo邽߂̃NXB
 * 
 * NX̒萔AA
 * <pre>
 * bɂASYT
 *   F Zp]_ 
 *   ISBN4-87408-414-1 C3055 2400~(w)
 * </pre>
 * ɂB
 * 
 * <pre>
 * -- revision history --
 * $Log: CRC16.java,v $
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [maintanance]
 *     \[X
 *     ^up~
 *     CZX̕ύX
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class CRC16 implements Checksum{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  public static final int CRC_ANSY_POLY
    //  public static final int CRC_ANSY_INIT
    //  public static final int CCITT_POLY
    //  public static final int CCITT_INIT
    //  public static final int DefaultPOLY
    //  public static final int DefaultINIT
    //------------------------------------------------------------------
    /**
     * CRC-ANSY ܂ CRC-16 ƂėL
     *  x^16 + x^15 + x^2 + 1 rbg\ɂ́B
     */
    public static final int CRC_ANSY_POLY = 0xA001;

    /**
     * LHAŎgp crc ̏lB
     * ҂ɐݒ肵lłA
     * CRC-ANSY ł̒llƂ
     * ߂Ă邩͒mȂB
     */
    public static final int CRC_ANSY_INIT = 0x0000;

    /**
     * CCITT  X.25ƂKi
     *  x^16 + x^12 + x^5 + 1 rbg\ɂ́B
     */
    public static final int CCITT_POLY = 0x8408;

    /**
     * CCITT  X.25ƂKi crc ̏lB
     */
    public static final int CCITT_INIT = 0xFFFF;

    /**
     * LHAŒʏgpAƂӖŃftHgCRCB
     * CRC16.CRC_ANSY_POLY ƓłB
     */
    public static final int DefaultPOLY = CRC16.CRC_ANSY_POLY;

    /**
     * LHAŒʏgpAƂӖŃftHgcrc̏lB
     * CRC16.CRC_ANSY_INIT ƓłB
     */
    public static final int DefaultINIT = CRC16.CRC_ANSY_INIT;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  private int crc
    //  private int init
    //  private int[] crcTable
    //------------------------------------------------------------------
    /** 
     * CRC16l 
     */
    private int crc;

    /** 
     * crc ̏l 
     */
    private int init;

    /** 
     * CRC16l̍XVpe[u 
     */
    private int[] crcTable;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  public CRC16()
    //  public CRC16( int poly )
    //  public CRC16( int poly, int init )
    //  public CRC16( int[] crcTable, int init )
    //------------------------------------------------------------------
    /**
     * LHAŎgp Əl CRC16𐶐B
     */
    public CRC16(){
        this( DefaultPOLY, DefaultINIT );
    }

    /**
     * poly Ŏw肳  CRC16𐶐B
     * l poly  CRC16.CCITT_POLY ł
     * CRC16.CCITT_INIT  łȂ 
     * CRC16.DefaultINIT gpB
     * 
     * @param poly CRC16ZoɎgp鑽̃rbg\
     */
    public CRC16( int poly ){
        this( poly, 
              ( poly == CRC16.CCITT_POLY ? 
                        CRC16.CCITT_INIT : 
                        CRC16.DefaultINIT ) );
    }

    /**
     * poly Ŏw肳  initŎw肳鏉l
     * CRC16𐶐B
     * 
     * @param poly CRC16ZoɎgp鑽̃rbg\
     * @param init crc ̏l
     */
    public  CRC16( int poly, int init ){
        this( CRC16.makeCrcTable( poly ), init );
    }

    /**
     * crcTable Ŏw肳 CRCZop\ 
     * initŎw肳鏉l CRC16쐬B
     *
     * @param crcTable CRC16ZoɎgp\
     * @param init     crc ̏l
     */
    public  CRC16( int[] crcTable, int init ){
        final int BYTE_PATTERNS= 256;

        if( crcTable.length == BYTE_PATTERNS ){
            this.crcTable = crcTable;
            this.init     = init;

            this.reset();
        }else{
            throw new IllegalArgumentException( "crcTable.length must equals 256" );
        }
    }


    //------------------------------------------------------------------
    //  method of java.util.zip.Checksum
    //------------------------------------------------------------------
    //  update
    //------------------------------------------------------------------
    //  public void update( int byte8 )
    //  public void update( byte[] buffer )
    //  public void update( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * byte8 Ŏw肳 1oCg̃f[^ crc̒lXVB
     * 
     * @param byte8 crcXV 1oCg̃f[^
     */
    public void update( int byte8 ){
        final int BYTE_BITS = 8;
        this.crc = ( this.crc >> BYTE_BITS )
                    ^ this.crcTable[ ( this.crc ^ byte8 ) & 0xFF ];
    }

    /**
     * buffer Ŏw肵oCgz crc ̒lXVB
     * 
     * @param buffer crcXV f[^oCgz
     */
    public void update( byte[] buffer ){
        this.update( buffer, 0, buffer.length );
    }

    /**
     * buffer Ŏw肵oCgz crc ̒lXVB
     * 
     * @param buffer crcXV f[^oCgz
     * @param index  f[^̊Jnʒu
     * @param length `FbNT̍XVɎgoCg
     */
    public void update( byte[] buffer, int index, int length ){
        final int BYTE_BITS = 8;

        while( 0 < ( index & 0x03 ) && 0 < length-- ){
            this.crc = ( this.crc >> BYTE_BITS )
                       ^ this.crcTable[ ( this.crc ^ buffer[index++] ) & 0xFF ];
        }

        while( 4 <= length ){
            int data =  (   buffer[index++] & 0xFF )
                      | ( ( buffer[index++] & 0xFF ) <<  8 )
                      | ( ( buffer[index++] & 0xFF ) << 16 )
                      | (   buffer[index++]          << 24 );

            this.crc = ( this.crc >> BYTE_BITS )
                       ^ this.crcTable[ ( this.crc ^ data ) & 0xFF ];
            data >>>= BYTE_BITS;
            this.crc = ( this.crc >> BYTE_BITS )
                       ^ this.crcTable[ ( this.crc ^ data ) & 0xFF ];
            data >>>= BYTE_BITS;
            this.crc = ( this.crc >> BYTE_BITS )
                       ^ this.crcTable[ ( this.crc ^ data ) & 0xFF ];
            data >>>= BYTE_BITS;
            this.crc = ( this.crc >> BYTE_BITS )
                       ^ this.crcTable[ ( this.crc ^ data ) & 0xFF ];
            length -= 4;
        }

        while( 0 < length-- ){
            this.crc = ( this.crc >> BYTE_BITS )
                       ^ this.crcTable[ ( this.crc ^ buffer[index++] ) & 0xFF ];
        }
    }


    //------------------------------------------------------------------
    //  method of java.util.zip.Checksum
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void reset()
    //  public long getValue()
    //------------------------------------------------------------------
    /**
     * crc llɐݒ肵ȂB
     */
    public void reset(){
        this.crc = this.init;
    }

    /**
     * crc l𓾂B
     * crc l 2oCg̒lłA 
     * 0x0000`0xFFFFɃ}bvB
     * 
     * @return crc l
     */
    public long getValue(){
        return this.crc & 0xFFFF;
    }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  public static int[] makeCrcTable( int init )
    //------------------------------------------------------------------
    /**
     * CRClZop \쐬B
     * 
     * @param poly CRCZop̑
     */
    public static int[] makeCrcTable( int poly ){
        final int BYTE_PATTERNS = 256;
        final int BYTE_BITS     = 8;
        int[] crcTable = new int[BYTE_PATTERNS];

        for( int i = 0 ; i < BYTE_PATTERNS ; i++ ){
            crcTable[i] = i;

            for( int j = 0 ; j < BYTE_BITS ; j++ ){
                if( ( crcTable[i] & 1 ) != 0 ){
                    crcTable[i] = ( crcTable[i] >> 1 ) ^ poly;
                }else{
                    crcTable[i] >>= 1;
                }
            }
        }

        return crcTable;
    }

}
//end of CRC16.java
