/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"


int do_sound(char *ifenv) {
	char sndprog[1024];
	char cmdline[1024];
	char sndstr[1024];	
	
	if(getenv("modsound_cmd") != NULL) {
		strcpy(sndprog, getenv("modsound_cmd"));
	} else {
		cf.sound = FALSE;
		fprintf(stderr, "\nERROR: modsound_cmd not correct in configfile!\n");
		return -1;
	}
	
	strcpy(sndstr, "modsound_");
	strcat(sndstr, ifenv);
	strcat(sndstr, "snd");
	/* see if we have a sound file in memory for sndstr */
	if(getenv(sndstr) != NULL) {
		strcpy(cmdline, sndprog);
		strcat(cmdline, " ");
		strcat(cmdline, getenv(sndstr));
	} else {
		return 1;
	}
	system(cmdline);
}

int lt_sound() {

	switch(event.pcolor[1]) {
		case 'r':	/* red sound */
			do_sound("red");
			break;
		case 'R':	/* alert sound */
			do_sound("brightred");
			break;
		case 'y':	/* yellow sound */
			do_sound("yellow");
			break;
		case 'Y':	/* bright yellow sound */
			do_sound("brightyellow");
			break;
		case 'g':	/* green sound */
			do_sound("green");
			break;
		case 'G':	/* bright green sound */
			do_sound("brightgreen");
			break;
		case 'b':	/* blue sound */
			do_sound("blue");
			break;
		case 'B':	/* bright blue sound */
			do_sound("brightblue");
			break;
		case 'c':	/* cyan sound */
			do_sound("cyan");
			break;
		case 'C':	/* bright cyan sound */
			do_sound("brightcyan");
			break;
		case 'm':	/* magenta sound */
			do_sound("magenta");
			break;
		case 'M':	/* bright magenta sound */
			do_sound("brightmagenta");
			break;
		default:	/* by default we just break */
			break;

	}
	return 0;
}

