---
title: "GPS"
permalink: /docs/readme/gps/
excerpt: "Kismet can use serial, network, and USB GPS receivers to track the location where signals are seen."
docgroup: "readme"
toc: true
---

## GPS
Kismet can integrate with a GPS device to provide geolocation coordinates for devices.

GPS data is included in the log files, in PPI pcap files, and exported over the REST interface.
​    
Kismet can not use GPS to determine the absolute location of the device; it can only use it to determine the location of the receiver.  The location estimate of a device can be improved by circling the suspected location.
​    
In addition to logging GPS data on a per-packet basis, Kismet maintains a running average of device locations which are exported as the average location in the Kismet UI and in device summaries.  Because the running average can be heavily influenced by the sensor's position, this running average may not be very accurate.

Multiple GPS devices can be defined at once, however only the highest priority active device is used.
​    
GPS is configured via the `gps=` configuration option.  GPS options are passed on the configuration line:
```
gps=type:option1=val1,option2=val2
```

### Supported GPS types
* serial (High priority)
   Locally-connected serial NMEA GPS device.  This supports most USB and Bluetooth (rfcomm/spp) connected GPS devices.  This does not support the few GPS devices which output proprietary binary

   Options:
   * `name=foo`
      Arbitrary name to identify this GPS
   * `device=path/to/device`
      Path to the serial device.  The user Kismet is running as must have read access to this device.
   * `reconnect=true | false`
      Automatically attempt to re-open the serial port if there is a problem or the GPS is not connected.
   * `baud=rate`
      Specify a non-standard baud rate for the serial port.  Most GPS devices operate at 4800, which Kismet uses by default.

   Example:
   ```
   gps=serial:device=/dev/ttyACM0,reconnect=true,name=LaptopSerial
   ```

* tcp (High priority)
   Network-connected raw NMEA stream.  Typically this is served by a smartphone app like "BlueNMEA" on Android or "NMEA GPS" on iPhone.  For GPSD-based network GPS connections, use the "gpsd" GPS in Kismet.

   Options:
   * `name=foo`
      Arbitrary name to identify this GPS
   * `host=ip-or-name`
      IP or hostname of the server running the NMEA TCP server
   * `port=port number`
      Port number the NMEA server is listening on
   * `reconnect=true | false`
      Automatically attempt to re-open the serial port if there is a problem or the GPS is not connected.

   Example:
   ```
   gps=tcp:host=10.10.100.100,port=3999
   ```

* gpsd (High priority)
   A GPSD server.  GPSD (http://www.catb.org/gpsd/) parses GPS data from multiple GPS vendors (including proprietary binary) and makes it available over a standard TCP/IP connection.

   There are multiple GPSD versions with various levels of support and incompatible protocols.  Kismet supports the older-style GPSD text protocol as well as the new GPSD3 JSON protocol.

   Options:
   * `name=foo`
      Arbitrary name to identify this GPS
   * `host=ip-or-name`
      IP or hostname of the server running the GPSD server
   * `port=port number`
      Port number the GPSD server is listening on; GPSD listens on port 2947 by default.
   * `reconnect=true | false`
      Automatically attempt to re-open the serial port if there is a problem or the GPS is not connected.

   Example:
   ```
   gps=gpsd:host=localhost,port=2947,reconnect=true
   ```

* web (Medium priority)
   A web-based client with a modern web browser and location hardware (such as a phone) can supply their GPS location.  This is only available to logged-in users on the Kismet web UI, but can turn a generic phone and web browser into a location source.

   Typically browsers cannot supply speed or other options, and the precision of this GPS source will be reduced because it may not be updated as frequently as a locally-connected GPS.

   Options:
   * `name=foo`
      Arbitrary name to identify this GPS

* virtual (lowest priority)
   A virtual GPS always reports a static location.  The virtual GPS injects location information on a stationary sensor or drone.

   Options:
   * `name=foo`
      Arbitrary name to identify this GPS
   * `lat=coordinate`
      Latitude coordinate.
   * `lon=coordinate`
      Longitude coordinate.
   * `alt=altitude`
      Altitude, in meters.

   Example:
   ```
   gps=virtual:lat=123.4566,lon=40.002,alt=23.45
   ```
