# Using Joplin

For day to day use, you typically create a notebook with a topic name (e.g., "recipes" or "bugs" or "vacation photos") then add individual notes of any length to those notebooks. But on first use, there are a couple things to do to make the most of Joplin. If you had been using another note-taking application and want to migrate those notes into Joplin, then you must first export them from your previous application and import into Joplin (see [Importing and Exporting](https://github.com/laurent22/joplin/blob/dev/readme/apps/import_export.md)).

So now you have a collection of notes on one computer or device; that is, all your notes are stored locally, not "in the cloud". In order to share your notes among multiple devices, then, you need to synchronise the first device with some cloud provider (see [Synchronisation](https://github.com/laurent22/joplin/blob/dev/readme/apps/sync/index.md) for the supported cloud providers). This will upload all your notes to the cloud. You can then install Joplin on any number of other devices, synchronise to the same provider, and then all your notes will be downloaded on each device. After all that synchronisation is done the first time, then moving forward whenever you edit a note on one device it will automatically sync with all your other devices within a few minutes.

**Important:** Make sure all your data has been uploaded from the initial machine via synchronisation **before** setting up synchronisation on any additional machines. Otherwise initially you will not see all your data. So monitor your synchronisation progress in the sidebar (on the left) until it shows complete; only then should you start synchronisation on other machines.
