---
id: grpc-intro
title: gRPC Introduction
sidebar_label: Introduction
---
[gRPC](https://grpc.io) is a popular RPC framework open-sourced by Google, and based on an internal system developed
there named "Stubby". It is based on [Protocol Buffers](https://developers.google.com/protocol-buffers), Google's
language-neutral, platform-neutral extensible mechanism for serializing structured data.

Ent supports the automatic generation of gRPC services from schemas using a plugin available in [ent/contrib](https://github.com/ent/contrib).

On a high-level, the integration between Ent and gRPC works like this:
* A command-line (or code-gen hook) named `entproto` is used to generate protocol buffer definitions and gRPC service
  definitions from an ent schema. The schema is annotated using `entproto` annotations to assist the mapping between
  the domains.
* A protoc (protobuf compiler) plugin, `protoc-gen-entgrpc`, is used to generate an implementation of the gRPC service
  definition generated by `entproto` that uses the project's `ent.Client` to read and write from the database.
* A gRPC server that embeds the generated service implementation is written by the developer.

In this tutorial we will build a fully working gRPC server using the Ent/gRPC integration. 

### Code

The final code for this tutorial can be found in [rotemtam/ent-grpc-example](https://github.com/rotemtam/ent-grpc-example).

