//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvirtualmachineimagebuilder

import "time"

// CloudError - An error response from the Azure VM Image Builder service.
type CloudError struct {
	// Details about the error.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the Azure VM Image Builder service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

type ComponentsVrq145SchemasImagetemplateidentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// ImageTemplate - Image template is an ARM resource managed by Microsoft.VirtualMachineImages provider
type ImageTemplate struct {
	// REQUIRED; The identity of the image template, if configured.
	Identity *ImageTemplateIdentity `json:"identity,omitempty"`

	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties of the image template
	Properties *ImageTemplateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImageTemplateCustomizerClassification provides polymorphic access to related types.
// Call the interface's GetImageTemplateCustomizer() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ImageTemplateCustomizer, *ImageTemplateFileCustomizer, *ImageTemplatePowerShellCustomizer, *ImageTemplateRestartCustomizer,
// - *ImageTemplateShellCustomizer, *ImageTemplateWindowsUpdateCustomizer
type ImageTemplateCustomizerClassification interface {
	// GetImageTemplateCustomizer returns the ImageTemplateCustomizer content of the underlying type.
	GetImageTemplateCustomizer() *ImageTemplateCustomizer
}

// ImageTemplateCustomizer - Describes a unit of image customization
type ImageTemplateCustomizer struct {
	// REQUIRED; The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
	Type *string `json:"type,omitempty"`

	// Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`
}

// GetImageTemplateCustomizer implements the ImageTemplateCustomizerClassification interface for type ImageTemplateCustomizer.
func (i *ImageTemplateCustomizer) GetImageTemplateCustomizer() *ImageTemplateCustomizer { return i }

// ImageTemplateDistributorClassification provides polymorphic access to related types.
// Call the interface's GetImageTemplateDistributor() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ImageTemplateDistributor, *ImageTemplateManagedImageDistributor, *ImageTemplateSharedImageDistributor, *ImageTemplateVhdDistributor
type ImageTemplateDistributorClassification interface {
	// GetImageTemplateDistributor returns the ImageTemplateDistributor content of the underlying type.
	GetImageTemplateDistributor() *ImageTemplateDistributor
}

// ImageTemplateDistributor - Generic distribution object
type ImageTemplateDistributor struct {
	// REQUIRED; The name to be used for the associated RunOutput.
	RunOutputName *string `json:"runOutputName,omitempty"`

	// REQUIRED; Type of distribution.
	Type *string `json:"type,omitempty"`

	// Tags that will be applied to the artifact once it has been created/updated by the distributor.
	ArtifactTags map[string]*string `json:"artifactTags,omitempty"`
}

// GetImageTemplateDistributor implements the ImageTemplateDistributorClassification interface for type ImageTemplateDistributor.
func (i *ImageTemplateDistributor) GetImageTemplateDistributor() *ImageTemplateDistributor { return i }

// ImageTemplateFileCustomizer - Uploads files to VMs (Linux, Windows). Corresponds to Packer file provisioner
type ImageTemplateFileCustomizer struct {
	// REQUIRED; The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
	Type *string `json:"type,omitempty"`

	// The absolute path to a file (with nested directory structures already created) where the file (from sourceUri) will be
	// uploaded to in the VM
	Destination *string `json:"destination,omitempty"`

	// Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`

	// SHA256 checksum of the file provided in the sourceUri field above
	SHA256Checksum *string `json:"sha256Checksum,omitempty"`

	// The URI of the file to be uploaded for customizing the VM. It can be a github link, SAS URI for Azure Storage, etc
	SourceURI *string `json:"sourceUri,omitempty"`
}

// GetImageTemplateCustomizer implements the ImageTemplateCustomizerClassification interface for type ImageTemplateFileCustomizer.
func (i *ImageTemplateFileCustomizer) GetImageTemplateCustomizer() *ImageTemplateCustomizer {
	return &ImageTemplateCustomizer{
		Type: i.Type,
		Name: i.Name,
	}
}

// ImageTemplateIdentity - Identity for the image template.
type ImageTemplateIdentity struct {
	// The type of identity used for the image template. The type 'None' will remove any identities from the image template.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the image template. The user identity dictionary key references will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ComponentsVrq145SchemasImagetemplateidentityPropertiesUserassignedidentitiesAdditionalproperties `json:"userAssignedIdentities,omitempty"`
}

// ImageTemplateInVMValidatorClassification provides polymorphic access to related types.
// Call the interface's GetImageTemplateInVMValidator() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ImageTemplateInVMValidator, *ImageTemplatePowerShellValidator, *ImageTemplateShellValidator
type ImageTemplateInVMValidatorClassification interface {
	// GetImageTemplateInVMValidator returns the ImageTemplateInVMValidator content of the underlying type.
	GetImageTemplateInVMValidator() *ImageTemplateInVMValidator
}

// ImageTemplateInVMValidator - Describes a unit of in-VM validation of image
type ImageTemplateInVMValidator struct {
	// REQUIRED; The type of validation you want to use on the Image. For example, "Shell" can be shell validation
	Type *string `json:"type,omitempty"`

	// Friendly Name to provide context on what this validation step does
	Name *string `json:"name,omitempty"`
}

// GetImageTemplateInVMValidator implements the ImageTemplateInVMValidatorClassification interface for type ImageTemplateInVMValidator.
func (i *ImageTemplateInVMValidator) GetImageTemplateInVMValidator() *ImageTemplateInVMValidator {
	return i
}

// ImageTemplateLastRunStatus - Describes the latest status of running an image template
type ImageTemplateLastRunStatus struct {
	// End time of the last run (UTC)
	EndTime *time.Time `json:"endTime,omitempty"`

	// Verbose information about the last run state
	Message *string `json:"message,omitempty"`

	// State of the last run
	RunState *RunState `json:"runState,omitempty"`

	// Sub-state of the last run
	RunSubState *RunSubState `json:"runSubState,omitempty"`

	// Start time of the last run (UTC)
	StartTime *time.Time `json:"startTime,omitempty"`
}

// ImageTemplateListResult - The result of List image templates operation
type ImageTemplateListResult struct {
	// The continuation token.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of image templates
	Value []*ImageTemplate `json:"value,omitempty"`
}

// ImageTemplateManagedImageDistributor - Distribute as a Managed Disk Image.
type ImageTemplateManagedImageDistributor struct {
	// REQUIRED; Resource Id of the Managed Disk Image
	ImageID *string `json:"imageId,omitempty"`

	// REQUIRED; Azure location for the image, should match if image already exists
	Location *string `json:"location,omitempty"`

	// REQUIRED; The name to be used for the associated RunOutput.
	RunOutputName *string `json:"runOutputName,omitempty"`

	// REQUIRED; Type of distribution.
	Type *string `json:"type,omitempty"`

	// Tags that will be applied to the artifact once it has been created/updated by the distributor.
	ArtifactTags map[string]*string `json:"artifactTags,omitempty"`
}

// GetImageTemplateDistributor implements the ImageTemplateDistributorClassification interface for type ImageTemplateManagedImageDistributor.
func (i *ImageTemplateManagedImageDistributor) GetImageTemplateDistributor() *ImageTemplateDistributor {
	return &ImageTemplateDistributor{
		Type:          i.Type,
		RunOutputName: i.RunOutputName,
		ArtifactTags:  i.ArtifactTags,
	}
}

// ImageTemplateManagedImageSource - Describes an image source that is a managed image in customer subscription. This image
// must reside in the same subscription and region as the Image Builder template.
type ImageTemplateManagedImageSource struct {
	// REQUIRED; ARM resource id of the managed image in customer subscription
	ImageID *string `json:"imageId,omitempty"`

	// REQUIRED; Specifies the type of source image you want to start with.
	Type *string `json:"type,omitempty"`
}

// GetImageTemplateSource implements the ImageTemplateSourceClassification interface for type ImageTemplateManagedImageSource.
func (i *ImageTemplateManagedImageSource) GetImageTemplateSource() *ImageTemplateSource {
	return &ImageTemplateSource{
		Type: i.Type,
	}
}

// ImageTemplatePlatformImageSource - Describes an image source from Azure Gallery Images [https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages].
type ImageTemplatePlatformImageSource struct {
	// REQUIRED; Specifies the type of source image you want to start with.
	Type *string `json:"type,omitempty"`

	// Image offer from the Azure Gallery Images [https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages].
	Offer *string `json:"offer,omitempty"`

	// Optional configuration of purchase plan for platform image.
	PlanInfo *PlatformImagePurchasePlan `json:"planInfo,omitempty"`

	// Image Publisher in Azure Gallery Images [https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages].
	Publisher *string `json:"publisher,omitempty"`

	// Image sku from the Azure Gallery Images [https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages].
	SKU *string `json:"sku,omitempty"`

	// Image version from the Azure Gallery Images [https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages]. If
	// 'latest' is specified here, the version is evaluated when the image build takes
	// place, not when the template is submitted.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; Image version from the Azure Gallery Images [https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages].
	// This readonly field differs from 'version', only if the value specified in
	// 'version' field is 'latest'.
	ExactVersion *string `json:"exactVersion,omitempty" azure:"ro"`
}

// GetImageTemplateSource implements the ImageTemplateSourceClassification interface for type ImageTemplatePlatformImageSource.
func (i *ImageTemplatePlatformImageSource) GetImageTemplateSource() *ImageTemplateSource {
	return &ImageTemplateSource{
		Type: i.Type,
	}
}

// ImageTemplatePowerShellCustomizer - Runs the specified PowerShell on the VM (Windows). Corresponds to Packer powershell
// provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
type ImageTemplatePowerShellCustomizer struct {
	// REQUIRED; The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
	Type *string `json:"type,omitempty"`

	// Array of PowerShell commands to execute
	Inline []*string `json:"inline,omitempty"`

	// Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`

	// If specified, the PowerShell script will be run with elevated privileges using the Local System user. Can only be true
	// when the runElevated field above is set to true.
	RunAsSystem *bool `json:"runAsSystem,omitempty"`

	// If specified, the PowerShell script will be run with elevated privileges
	RunElevated *bool `json:"runElevated,omitempty"`

	// SHA256 checksum of the power shell script provided in the scriptUri field above
	SHA256Checksum *string `json:"sha256Checksum,omitempty"`

	// URI of the PowerShell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
	ScriptURI *string `json:"scriptUri,omitempty"`

	// Valid exit codes for the PowerShell script. [Default: 0]
	ValidExitCodes []*int32 `json:"validExitCodes,omitempty"`
}

// GetImageTemplateCustomizer implements the ImageTemplateCustomizerClassification interface for type ImageTemplatePowerShellCustomizer.
func (i *ImageTemplatePowerShellCustomizer) GetImageTemplateCustomizer() *ImageTemplateCustomizer {
	return &ImageTemplateCustomizer{
		Type: i.Type,
		Name: i.Name,
	}
}

// ImageTemplatePowerShellValidator - Runs the specified PowerShell script during the validation phase (Windows). Corresponds
// to Packer powershell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
type ImageTemplatePowerShellValidator struct {
	// REQUIRED; The type of validation you want to use on the Image. For example, "Shell" can be shell validation
	Type *string `json:"type,omitempty"`

	// Array of PowerShell commands to execute
	Inline []*string `json:"inline,omitempty"`

	// Friendly Name to provide context on what this validation step does
	Name *string `json:"name,omitempty"`

	// If specified, the PowerShell script will be run with elevated privileges using the Local System user. Can only be true
	// when the runElevated field above is set to true.
	RunAsSystem *bool `json:"runAsSystem,omitempty"`

	// If specified, the PowerShell script will be run with elevated privileges
	RunElevated *bool `json:"runElevated,omitempty"`

	// SHA256 checksum of the power shell script provided in the scriptUri field above
	SHA256Checksum *string `json:"sha256Checksum,omitempty"`

	// URI of the PowerShell script to be run for validation. It can be a github link, Azure Storage URI, etc
	ScriptURI *string `json:"scriptUri,omitempty"`

	// Valid exit codes for the PowerShell script. [Default: 0]
	ValidExitCodes []*int32 `json:"validExitCodes,omitempty"`
}

// GetImageTemplateInVMValidator implements the ImageTemplateInVMValidatorClassification interface for type ImageTemplatePowerShellValidator.
func (i *ImageTemplatePowerShellValidator) GetImageTemplateInVMValidator() *ImageTemplateInVMValidator {
	return &ImageTemplateInVMValidator{
		Type: i.Type,
		Name: i.Name,
	}
}

// ImageTemplateProperties - Describes the properties of an image template
type ImageTemplateProperties struct {
	// REQUIRED; The distribution targets where the image output needs to go to.
	Distribute []ImageTemplateDistributorClassification `json:"distribute,omitempty"`

	// REQUIRED; Specifies the properties used to describe the source image.
	Source ImageTemplateSourceClassification `json:"source,omitempty"`

	// Maximum duration to wait while building the image template (includes all customizations, validations, and distributions).
	// Omit or specify 0 to use the default (4 hours).
	BuildTimeoutInMinutes *int32 `json:"buildTimeoutInMinutes,omitempty"`

	// Specifies the properties used to describe the customization steps of the image, like Image source etc
	Customize []ImageTemplateCustomizerClassification `json:"customize,omitempty"`

	// The staging resource group id in the same subscription as the image template that will be used to build the image. If this
	// field is empty, a resource group with a random name will be created. If the
	// resource group specified in this field doesn't exist, it will be created with the same name. If the resource group specified
	// exists, it must be empty and in the same region as the image template. The
	// resource group created will be deleted during template deletion if this field is empty or the resource group specified
	// doesn't exist, but if the resource group specified exists the resources created
	// in the resource group will be deleted during template deletion and the resource group itself will remain.
	StagingResourceGroup *string `json:"stagingResourceGroup,omitempty"`

	// Describes how virtual machine is set up to build images
	VMProfile *ImageTemplateVMProfile `json:"vmProfile,omitempty"`

	// Configuration options and list of validations to be performed on the resulting image.
	Validate *ImageTemplatePropertiesValidate `json:"validate,omitempty"`

	// READ-ONLY; The staging resource group id in the same subscription as the image template that will be used to build the
	// image. This read-only field differs from 'stagingResourceGroup' only if the value specified
	// in the 'stagingResourceGroup' field is empty.
	ExactStagingResourceGroup *string `json:"exactStagingResourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; State of 'run' that is currently executing or was last executed.
	LastRunStatus *ImageTemplateLastRunStatus `json:"lastRunStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning error, if any
	ProvisioningError *ProvisioningError `json:"provisioningError,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ImageTemplatePropertiesValidate - Configuration options and list of validations to be performed on the resulting image.
type ImageTemplatePropertiesValidate struct {
	// If validation fails and this field is set to false, output image(s) will not be distributed. This is the default behavior.
	// If validation fails and this field is set to true, output image(s) will still
	// be distributed. Please use this option with caution as it may result in bad images being distributed for use. In either
	// case (true or false), the end to end image run will be reported as having failed
	// in case of a validation failure. [Note: This field has no effect if validation succeeds.]
	ContinueDistributeOnFailure *bool `json:"continueDistributeOnFailure,omitempty"`

	// List of validations to be performed.
	InVMValidations []ImageTemplateInVMValidatorClassification `json:"inVMValidations,omitempty"`

	// If this field is set to true, the image specified in the 'source' section will directly be validated. No separate build
	// will be run to generate and then validate a customized image.
	SourceValidationOnly *bool `json:"sourceValidationOnly,omitempty"`
}

// ImageTemplateRestartCustomizer - Reboots a VM and waits for it to come back online (Windows). Corresponds to Packer windows-restart
// provisioner
type ImageTemplateRestartCustomizer struct {
	// REQUIRED; The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
	Type *string `json:"type,omitempty"`

	// Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`

	// Command to check if restart succeeded [Default: '']
	RestartCheckCommand *string `json:"restartCheckCommand,omitempty"`

	// Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
	RestartCommand *string `json:"restartCommand,omitempty"`

	// Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
	RestartTimeout *string `json:"restartTimeout,omitempty"`
}

// GetImageTemplateCustomizer implements the ImageTemplateCustomizerClassification interface for type ImageTemplateRestartCustomizer.
func (i *ImageTemplateRestartCustomizer) GetImageTemplateCustomizer() *ImageTemplateCustomizer {
	return &ImageTemplateCustomizer{
		Type: i.Type,
		Name: i.Name,
	}
}

// ImageTemplateSharedImageDistributor - Distribute via Shared Image Gallery.
type ImageTemplateSharedImageDistributor struct {
	// REQUIRED; Resource Id of the Shared Image Gallery image
	GalleryImageID *string `json:"galleryImageId,omitempty"`

	// REQUIRED; A list of regions that the image will be replicated to
	ReplicationRegions []*string `json:"replicationRegions,omitempty"`

	// REQUIRED; The name to be used for the associated RunOutput.
	RunOutputName *string `json:"runOutputName,omitempty"`

	// REQUIRED; Type of distribution.
	Type *string `json:"type,omitempty"`

	// Tags that will be applied to the artifact once it has been created/updated by the distributor.
	ArtifactTags map[string]*string `json:"artifactTags,omitempty"`

	// Flag that indicates whether created image version should be excluded from latest. Omit to use the default (false).
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty"`

	// Storage account type to be used to store the shared image. Omit to use the default (Standard_LRS).
	StorageAccountType *SharedImageStorageAccountType `json:"storageAccountType,omitempty"`
}

// GetImageTemplateDistributor implements the ImageTemplateDistributorClassification interface for type ImageTemplateSharedImageDistributor.
func (i *ImageTemplateSharedImageDistributor) GetImageTemplateDistributor() *ImageTemplateDistributor {
	return &ImageTemplateDistributor{
		Type:          i.Type,
		RunOutputName: i.RunOutputName,
		ArtifactTags:  i.ArtifactTags,
	}
}

// ImageTemplateSharedImageVersionSource - Describes an image source that is an image version in a shared image gallery.
type ImageTemplateSharedImageVersionSource struct {
	// REQUIRED; ARM resource id of the image version in the shared image gallery
	ImageVersionID *string `json:"imageVersionId,omitempty"`

	// REQUIRED; Specifies the type of source image you want to start with.
	Type *string `json:"type,omitempty"`
}

// GetImageTemplateSource implements the ImageTemplateSourceClassification interface for type ImageTemplateSharedImageVersionSource.
func (i *ImageTemplateSharedImageVersionSource) GetImageTemplateSource() *ImageTemplateSource {
	return &ImageTemplateSource{
		Type: i.Type,
	}
}

// ImageTemplateShellCustomizer - Runs a shell script during the customization phase (Linux). Corresponds to Packer shell
// provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
type ImageTemplateShellCustomizer struct {
	// REQUIRED; The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
	Type *string `json:"type,omitempty"`

	// Array of shell commands to execute
	Inline []*string `json:"inline,omitempty"`

	// Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`

	// SHA256 checksum of the shell script provided in the scriptUri field
	SHA256Checksum *string `json:"sha256Checksum,omitempty"`

	// URI of the shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
	ScriptURI *string `json:"scriptUri,omitempty"`
}

// GetImageTemplateCustomizer implements the ImageTemplateCustomizerClassification interface for type ImageTemplateShellCustomizer.
func (i *ImageTemplateShellCustomizer) GetImageTemplateCustomizer() *ImageTemplateCustomizer {
	return &ImageTemplateCustomizer{
		Type: i.Type,
		Name: i.Name,
	}
}

// ImageTemplateShellValidator - Runs the specified shell script during the validation phase (Linux). Corresponds to Packer
// shell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
type ImageTemplateShellValidator struct {
	// REQUIRED; The type of validation you want to use on the Image. For example, "Shell" can be shell validation
	Type *string `json:"type,omitempty"`

	// Array of shell commands to execute
	Inline []*string `json:"inline,omitempty"`

	// Friendly Name to provide context on what this validation step does
	Name *string `json:"name,omitempty"`

	// SHA256 checksum of the shell script provided in the scriptUri field
	SHA256Checksum *string `json:"sha256Checksum,omitempty"`

	// URI of the shell script to be run for validation. It can be a github link, Azure Storage URI, etc
	ScriptURI *string `json:"scriptUri,omitempty"`
}

// GetImageTemplateInVMValidator implements the ImageTemplateInVMValidatorClassification interface for type ImageTemplateShellValidator.
func (i *ImageTemplateShellValidator) GetImageTemplateInVMValidator() *ImageTemplateInVMValidator {
	return &ImageTemplateInVMValidator{
		Type: i.Type,
		Name: i.Name,
	}
}

// ImageTemplateSourceClassification provides polymorphic access to related types.
// Call the interface's GetImageTemplateSource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ImageTemplateManagedImageSource, *ImageTemplatePlatformImageSource, *ImageTemplateSharedImageVersionSource, *ImageTemplateSource
type ImageTemplateSourceClassification interface {
	// GetImageTemplateSource returns the ImageTemplateSource content of the underlying type.
	GetImageTemplateSource() *ImageTemplateSource
}

// ImageTemplateSource - Describes a virtual machine image source for building, customizing and distributing
type ImageTemplateSource struct {
	// REQUIRED; Specifies the type of source image you want to start with.
	Type *string `json:"type,omitempty"`
}

// GetImageTemplateSource implements the ImageTemplateSourceClassification interface for type ImageTemplateSource.
func (i *ImageTemplateSource) GetImageTemplateSource() *ImageTemplateSource { return i }

// ImageTemplateUpdateParameters - Parameters for updating an image template.
type ImageTemplateUpdateParameters struct {
	// The identity of the image template, if configured.
	Identity *ImageTemplateIdentity `json:"identity,omitempty"`

	// The user-specified tags associated with the image template.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ImageTemplateVMProfile - Describes the virtual machines used to build and validate images
type ImageTemplateVMProfile struct {
	// Size of the OS disk in GB. Omit or specify 0 to use Azure's default OS disk size.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// Optional array of resource IDs of user assigned managed identities to be configured on the build VM and validation VM.
	// This may include the identity of the image template.
	UserAssignedIdentities []*string `json:"userAssignedIdentities,omitempty"`

	// Size of the virtual machine used to build, customize and capture images. Omit or specify empty string to use the default
	// (StandardD1v2 for Gen1 images and StandardD2dsv4 for Gen2 images).
	VMSize *string `json:"vmSize,omitempty"`

	// Optional configuration of the virtual network to use to deploy the build VM and validation VM in. Omit if no specific virtual
	// network needs to be used.
	VnetConfig *VirtualNetworkConfig `json:"vnetConfig,omitempty"`
}

// ImageTemplateVhdDistributor - Distribute via VHD in a storage account.
type ImageTemplateVhdDistributor struct {
	// REQUIRED; The name to be used for the associated RunOutput.
	RunOutputName *string `json:"runOutputName,omitempty"`

	// REQUIRED; Type of distribution.
	Type *string `json:"type,omitempty"`

	// Tags that will be applied to the artifact once it has been created/updated by the distributor.
	ArtifactTags map[string]*string `json:"artifactTags,omitempty"`
}

// GetImageTemplateDistributor implements the ImageTemplateDistributorClassification interface for type ImageTemplateVhdDistributor.
func (i *ImageTemplateVhdDistributor) GetImageTemplateDistributor() *ImageTemplateDistributor {
	return &ImageTemplateDistributor{
		Type:          i.Type,
		RunOutputName: i.RunOutputName,
		ArtifactTags:  i.ArtifactTags,
	}
}

// ImageTemplateWindowsUpdateCustomizer - Installs Windows Updates. Corresponds to Packer Windows Update Provisioner (https://github.com/rgl/packer-provisioner-windows-update)
type ImageTemplateWindowsUpdateCustomizer struct {
	// REQUIRED; The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
	Type *string `json:"type,omitempty"`

	// Array of filters to select updates to apply. Omit or specify empty array to use the default (no filter). Refer to above
	// link for examples and detailed description of this field.
	Filters []*string `json:"filters,omitempty"`

	// Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`

	// Criteria to search updates. Omit or specify empty string to use the default (search all). Refer to above link for examples
	// and detailed description of this field.
	SearchCriteria *string `json:"searchCriteria,omitempty"`

	// Maximum number of updates to apply at a time. Omit or specify 0 to use the default (1000)
	UpdateLimit *int32 `json:"updateLimit,omitempty"`
}

// GetImageTemplateCustomizer implements the ImageTemplateCustomizerClassification interface for type ImageTemplateWindowsUpdateCustomizer.
func (i *ImageTemplateWindowsUpdateCustomizer) GetImageTemplateCustomizer() *ImageTemplateCustomizer {
	return &ImageTemplateCustomizer{
		Type: i.Type,
		Name: i.Name,
	}
}

// Operation - A REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// The flag that indicates whether the operation applies to data plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// This is of the format {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// The intended executor of the operation.
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// The friendly name of the operation
	Description *string `json:"description,omitempty"`

	// For example: read, write, delete, or listKeys/action
	Operation *string `json:"operation,omitempty"`

	// Friendly name of the resource provider.
	Provider *string `json:"provider,omitempty"`

	// The resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list REST API operations. It contains a list of operations and a URL nextLink
// to get the next set of results.
type OperationListResult struct {
	// The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of operations supported by the resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PlatformImagePurchasePlan - Purchase plan configuration for platform image.
type PlatformImagePurchasePlan struct {
	// REQUIRED; Name of the purchase plan.
	PlanName *string `json:"planName,omitempty"`

	// REQUIRED; Product of the purchase plan.
	PlanProduct *string `json:"planProduct,omitempty"`

	// REQUIRED; Publisher of the purchase plan.
	PlanPublisher *string `json:"planPublisher,omitempty"`
}

// ProvisioningError - Describes the error happened when create or update an image template
type ProvisioningError struct {
	// Verbose error message about the provisioning failure
	Message *string `json:"message,omitempty"`

	// Error code of the provisioning failure
	ProvisioningErrorCode *ProvisioningErrorCode `json:"provisioningErrorCode,omitempty"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RunOutput - Represents an output that was created by running an image template.
type RunOutput struct {
	// The properties of the run output
	Properties *RunOutputProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RunOutputCollection - The result of List run outputs operation
type RunOutputCollection struct {
	// The continuation token.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of run outputs
	Value []*RunOutput `json:"value,omitempty"`
}

// RunOutputProperties - Describes the properties of a run output
type RunOutputProperties struct {
	// The resource id of the artifact.
	ArtifactID *string `json:"artifactId,omitempty"`

	// The location URI of the artifact.
	ArtifactURI *string `json:"artifactUri,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineImageTemplatesClientBeginCancelOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.BeginCancel
// method.
type VirtualMachineImageTemplatesClientBeginCancelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineImageTemplatesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.BeginCreateOrUpdate
// method.
type VirtualMachineImageTemplatesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineImageTemplatesClientBeginDeleteOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.BeginDelete
// method.
type VirtualMachineImageTemplatesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineImageTemplatesClientBeginRunOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.BeginRun
// method.
type VirtualMachineImageTemplatesClientBeginRunOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineImageTemplatesClientBeginUpdateOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.BeginUpdate
// method.
type VirtualMachineImageTemplatesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineImageTemplatesClientGetOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.Get
// method.
type VirtualMachineImageTemplatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImageTemplatesClientGetRunOutputOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.GetRunOutput
// method.
type VirtualMachineImageTemplatesClientGetRunOutputOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImageTemplatesClientListByResourceGroupOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.ListByResourceGroup
// method.
type VirtualMachineImageTemplatesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImageTemplatesClientListOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.List
// method.
type VirtualMachineImageTemplatesClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImageTemplatesClientListRunOutputsOptions contains the optional parameters for the VirtualMachineImageTemplatesClient.ListRunOutputs
// method.
type VirtualMachineImageTemplatesClientListRunOutputsOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkConfig - Virtual Network configuration.
type VirtualNetworkConfig struct {
	// Size of the proxy virtual machine used to pass traffic to the build VM and validation VM. Omit or specify empty string
	// to use the default (StandardA1v2).
	ProxyVMSize *string `json:"proxyVmSize,omitempty"`

	// Resource id of a pre-existing subnet.
	SubnetID *string `json:"subnetId,omitempty"`
}
