//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcdn

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AFDDomainUpdateParameters.
func (a AFDDomainUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AFDEndpoint.
func (a AFDEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AFDEndpointUpdateParameters.
func (a AFDEndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginGroupUpdateParameters.
func (a AFDOriginGroupUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginUpdateParameters.
func (a AFDOriginUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AfdPurgeParameters.
func (a AfdPurgeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentPaths", a.ContentPaths)
	populate(objectMap, "domains", a.Domains)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirstPartyManagedCertificateParameters.
func (a AzureFirstPartyManagedCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["type"] = SecretTypeAzureFirstPartyManagedCertificate
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirstPartyManagedCertificateParameters.
func (a *AzureFirstPartyManagedCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientPortMatchConditionParameters.
func (c ClientPortMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", c.MatchValues)
	populate(objectMap, "negateCondition", c.NegateCondition)
	populate(objectMap, "operator", c.Operator)
	populate(objectMap, "transforms", c.Transforms)
	populate(objectMap, "typeName", c.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems.
func (c *Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTime":
			err = unpopulateTimeRFC3339(val, "DateTime", &c.DateTime)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems.
func (c *Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTime":
			err = unpopulateTimeRFC3339(val, "DateTime", &c.DateTime)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CompressionSettings.
func (c CompressionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentTypesToCompress", c.ContentTypesToCompress)
	populate(objectMap, "isCompressionEnabled", c.IsCompressionEnabled)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CookiesMatchConditionParameters.
func (c CookiesMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", c.MatchValues)
	populate(objectMap, "negateCondition", c.NegateCondition)
	populate(objectMap, "operator", c.Operator)
	populate(objectMap, "selector", c.Selector)
	populate(objectMap, "transforms", c.Transforms)
	populate(objectMap, "typeName", c.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomainProperties.
func (c CustomDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customHttpsParameters", c.CustomHTTPSParameters)
	populate(objectMap, "customHttpsProvisioningState", c.CustomHTTPSProvisioningState)
	populate(objectMap, "customHttpsProvisioningSubstate", c.CustomHTTPSProvisioningSubstate)
	populate(objectMap, "hostName", c.HostName)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "resourceState", c.ResourceState)
	populate(objectMap, "validationData", c.ValidationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomainProperties.
func (c *CustomDomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customHttpsParameters":
			c.CustomHTTPSParameters, err = unmarshalCustomDomainHTTPSParametersClassification(val)
			delete(rawMsg, key)
		case "customHttpsProvisioningState":
			err = unpopulate(val, "CustomHTTPSProvisioningState", &c.CustomHTTPSProvisioningState)
			delete(rawMsg, key)
		case "customHttpsProvisioningSubstate":
			err = unpopulate(val, "CustomHTTPSProvisioningSubstate", &c.CustomHTTPSProvisioningSubstate)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &c.HostName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &c.ResourceState)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &c.ValidationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRule.
func (c CustomRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", c.Action)
	populate(objectMap, "enabledState", c.EnabledState)
	populate(objectMap, "matchConditions", c.MatchConditions)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "priority", c.Priority)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CustomRuleList.
func (c CustomRuleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "rules", c.Rules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CustomerCertificateParameters.
func (c CustomerCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "certificateAuthority", c.CertificateAuthority)
	populate(objectMap, "expirationDate", c.ExpirationDate)
	populate(objectMap, "secretSource", c.SecretSource)
	populate(objectMap, "secretVersion", c.SecretVersion)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "subjectAlternativeNames", c.SubjectAlternativeNames)
	populate(objectMap, "thumbprint", c.Thumbprint)
	objectMap["type"] = SecretTypeCustomerCertificate
	populate(objectMap, "useLatestVersion", c.UseLatestVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerCertificateParameters.
func (c *CustomerCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateAuthority":
			err = unpopulate(val, "CertificateAuthority", &c.CertificateAuthority)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulate(val, "ExpirationDate", &c.ExpirationDate)
			delete(rawMsg, key)
		case "secretSource":
			err = unpopulate(val, "SecretSource", &c.SecretSource)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &c.SecretVersion)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "subjectAlternativeNames":
			err = unpopulate(val, "SubjectAlternativeNames", &c.SubjectAlternativeNames)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "useLatestVersion":
			err = unpopulate(val, "UseLatestVersion", &c.UseLatestVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeepCreatedOriginGroupProperties.
func (d DeepCreatedOriginGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "healthProbeSettings", d.HealthProbeSettings)
	populate(objectMap, "origins", d.Origins)
	populate(objectMap, "responseBasedOriginErrorDetectionSettings", d.ResponseBasedOriginErrorDetectionSettings)
	populate(objectMap, "trafficRestorationTimeToHealedOrNewEndpointsInMinutes", d.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRule.
func (d DeliveryRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", d.Actions)
	populate(objectMap, "conditions", d.Conditions)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "order", d.Order)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRule.
func (d *DeliveryRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			d.Actions, err = unmarshalDeliveryRuleActionAutoGeneratedClassificationArray(val)
			delete(rawMsg, key)
		case "conditions":
			d.Conditions, err = unmarshalDeliveryRuleConditionClassificationArray(val)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &d.Order)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleCacheExpirationAction.
func (d DeliveryRuleCacheExpirationAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = DeliveryRuleActionCacheExpiration
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleCacheExpirationAction.
func (d *DeliveryRuleCacheExpirationAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleCacheKeyQueryStringAction.
func (d DeliveryRuleCacheKeyQueryStringAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = DeliveryRuleActionCacheKeyQueryString
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleCacheKeyQueryStringAction.
func (d *DeliveryRuleCacheKeyQueryStringAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleClientPortCondition.
func (d DeliveryRuleClientPortCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableClientPort
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleClientPortCondition.
func (d *DeliveryRuleClientPortCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleCookiesCondition.
func (d DeliveryRuleCookiesCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableCookies
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleCookiesCondition.
func (d *DeliveryRuleCookiesCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleHTTPVersionCondition.
func (d DeliveryRuleHTTPVersionCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableHTTPVersion
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleHTTPVersionCondition.
func (d *DeliveryRuleHTTPVersionCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleHostNameCondition.
func (d DeliveryRuleHostNameCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableHostName
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleHostNameCondition.
func (d *DeliveryRuleHostNameCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleIsDeviceCondition.
func (d DeliveryRuleIsDeviceCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableIsDevice
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleIsDeviceCondition.
func (d *DeliveryRuleIsDeviceCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRulePostArgsCondition.
func (d DeliveryRulePostArgsCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariablePostArgs
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRulePostArgsCondition.
func (d *DeliveryRulePostArgsCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleQueryStringCondition.
func (d DeliveryRuleQueryStringCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableQueryString
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleQueryStringCondition.
func (d *DeliveryRuleQueryStringCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRemoteAddressCondition.
func (d DeliveryRuleRemoteAddressCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableRemoteAddress
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRemoteAddressCondition.
func (d *DeliveryRuleRemoteAddressCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestBodyCondition.
func (d DeliveryRuleRequestBodyCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableRequestBody
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestBodyCondition.
func (d *DeliveryRuleRequestBodyCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestHeaderAction.
func (d DeliveryRuleRequestHeaderAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = DeliveryRuleActionModifyRequestHeader
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestHeaderAction.
func (d *DeliveryRuleRequestHeaderAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestHeaderCondition.
func (d DeliveryRuleRequestHeaderCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableRequestHeader
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestHeaderCondition.
func (d *DeliveryRuleRequestHeaderCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestMethodCondition.
func (d DeliveryRuleRequestMethodCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableRequestMethod
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestMethodCondition.
func (d *DeliveryRuleRequestMethodCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestSchemeCondition.
func (d DeliveryRuleRequestSchemeCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableRequestScheme
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestSchemeCondition.
func (d *DeliveryRuleRequestSchemeCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestURICondition.
func (d DeliveryRuleRequestURICondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableRequestURI
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestURICondition.
func (d *DeliveryRuleRequestURICondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleResponseHeaderAction.
func (d DeliveryRuleResponseHeaderAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = DeliveryRuleActionModifyResponseHeader
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleResponseHeaderAction.
func (d *DeliveryRuleResponseHeaderAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRouteConfigurationOverrideAction.
func (d DeliveryRuleRouteConfigurationOverrideAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = DeliveryRuleActionRouteConfigurationOverride
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRouteConfigurationOverrideAction.
func (d *DeliveryRuleRouteConfigurationOverrideAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleSSLProtocolCondition.
func (d DeliveryRuleSSLProtocolCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableSSLProtocol
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleSSLProtocolCondition.
func (d *DeliveryRuleSSLProtocolCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleServerPortCondition.
func (d DeliveryRuleServerPortCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableServerPort
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleServerPortCondition.
func (d *DeliveryRuleServerPortCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleSocketAddrCondition.
func (d DeliveryRuleSocketAddrCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableSocketAddr
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleSocketAddrCondition.
func (d *DeliveryRuleSocketAddrCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleURLFileExtensionCondition.
func (d DeliveryRuleURLFileExtensionCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableURLFileExtension
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleURLFileExtensionCondition.
func (d *DeliveryRuleURLFileExtensionCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleURLFileNameCondition.
func (d DeliveryRuleURLFileNameCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableURLFileName
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleURLFileNameCondition.
func (d *DeliveryRuleURLFileNameCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleURLPathCondition.
func (d DeliveryRuleURLPathCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = MatchVariableURLPath
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleURLPathCondition.
func (d *DeliveryRuleURLPathCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdgeNodeProperties.
func (e EdgeNodeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ipAddressGroups", e.IPAddressGroups)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Endpoint.
func (e Endpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EndpointProperties.
func (e EndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentTypesToCompress", e.ContentTypesToCompress)
	populate(objectMap, "customDomains", e.CustomDomains)
	populate(objectMap, "defaultOriginGroup", e.DefaultOriginGroup)
	populate(objectMap, "deliveryPolicy", e.DeliveryPolicy)
	populate(objectMap, "geoFilters", e.GeoFilters)
	populate(objectMap, "hostName", e.HostName)
	populate(objectMap, "isCompressionEnabled", e.IsCompressionEnabled)
	populate(objectMap, "isHttpAllowed", e.IsHTTPAllowed)
	populate(objectMap, "isHttpsAllowed", e.IsHTTPSAllowed)
	populate(objectMap, "optimizationType", e.OptimizationType)
	populate(objectMap, "originGroups", e.OriginGroups)
	populate(objectMap, "originHostHeader", e.OriginHostHeader)
	populate(objectMap, "originPath", e.OriginPath)
	populate(objectMap, "origins", e.Origins)
	populate(objectMap, "probePath", e.ProbePath)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "queryStringCachingBehavior", e.QueryStringCachingBehavior)
	populate(objectMap, "resourceState", e.ResourceState)
	populate(objectMap, "urlSigningKeys", e.URLSigningKeys)
	populate(objectMap, "webApplicationFirewallPolicyLink", e.WebApplicationFirewallPolicyLink)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EndpointPropertiesUpdateParameters.
func (e EndpointPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentTypesToCompress", e.ContentTypesToCompress)
	populate(objectMap, "defaultOriginGroup", e.DefaultOriginGroup)
	populate(objectMap, "deliveryPolicy", e.DeliveryPolicy)
	populate(objectMap, "geoFilters", e.GeoFilters)
	populate(objectMap, "isCompressionEnabled", e.IsCompressionEnabled)
	populate(objectMap, "isHttpAllowed", e.IsHTTPAllowed)
	populate(objectMap, "isHttpsAllowed", e.IsHTTPSAllowed)
	populate(objectMap, "optimizationType", e.OptimizationType)
	populate(objectMap, "originHostHeader", e.OriginHostHeader)
	populate(objectMap, "originPath", e.OriginPath)
	populate(objectMap, "probePath", e.ProbePath)
	populate(objectMap, "queryStringCachingBehavior", e.QueryStringCachingBehavior)
	populate(objectMap, "urlSigningKeys", e.URLSigningKeys)
	populate(objectMap, "webApplicationFirewallPolicyLink", e.WebApplicationFirewallPolicyLink)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EndpointPropertiesUpdateParametersDeliveryPolicy.
func (e EndpointPropertiesUpdateParametersDeliveryPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", e.Description)
	populate(objectMap, "rules", e.Rules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EndpointUpdateParameters.
func (e EndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GeoFilter.
func (g GeoFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", g.Action)
	populate(objectMap, "countryCodes", g.CountryCodes)
	populate(objectMap, "relativePath", g.RelativePath)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type HTTPVersionMatchConditionParameters.
func (h HTTPVersionMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", h.MatchValues)
	populate(objectMap, "negateCondition", h.NegateCondition)
	populate(objectMap, "operator", h.Operator)
	populate(objectMap, "transforms", h.Transforms)
	populate(objectMap, "typeName", h.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type HostNameMatchConditionParameters.
func (h HostNameMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", h.MatchValues)
	populate(objectMap, "negateCondition", h.NegateCondition)
	populate(objectMap, "operator", h.Operator)
	populate(objectMap, "transforms", h.Transforms)
	populate(objectMap, "typeName", h.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IPAddressGroup.
func (i IPAddressGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deliveryRegion", i.DeliveryRegion)
	populate(objectMap, "ipv4Addresses", i.IPv4Addresses)
	populate(objectMap, "ipv6Addresses", i.IPv6Addresses)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IsDeviceMatchConditionParameters.
func (i IsDeviceMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", i.MatchValues)
	populate(objectMap, "negateCondition", i.NegateCondition)
	populate(objectMap, "operator", i.Operator)
	populate(objectMap, "transforms", i.Transforms)
	populate(objectMap, "typeName", i.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LoadParameters.
func (l LoadParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentPaths", l.ContentPaths)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedCertificateParameters.
func (m ManagedCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "expirationDate", m.ExpirationDate)
	populate(objectMap, "subject", m.Subject)
	objectMap["type"] = SecretTypeManagedCertificate
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedCertificateParameters.
func (m *ManagedCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulate(val, "ExpirationDate", &m.ExpirationDate)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &m.Subject)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedHTTPSParameters.
func (m ManagedHTTPSParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["certificateSource"] = CertificateSourceCdn
	populate(objectMap, "certificateSourceParameters", m.CertificateSourceParameters)
	populate(objectMap, "minimumTlsVersion", m.MinimumTLSVersion)
	populate(objectMap, "protocolType", m.ProtocolType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedHTTPSParameters.
func (m *ManagedHTTPSParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateSource":
			err = unpopulate(val, "CertificateSource", &m.CertificateSource)
			delete(rawMsg, key)
		case "certificateSourceParameters":
			err = unpopulate(val, "CertificateSourceParameters", &m.CertificateSourceParameters)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &m.MinimumTLSVersion)
			delete(rawMsg, key)
		case "protocolType":
			err = unpopulate(val, "ProtocolType", &m.ProtocolType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleGroupDefinition.
func (m ManagedRuleGroupDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", m.Description)
	populate(objectMap, "ruleGroupName", m.RuleGroupName)
	populate(objectMap, "rules", m.Rules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleGroupOverride.
func (m ManagedRuleGroupOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ruleGroupName", m.RuleGroupName)
	populate(objectMap, "rules", m.Rules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSet.
func (m ManagedRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "anomalyScore", m.AnomalyScore)
	populate(objectMap, "ruleGroupOverrides", m.RuleGroupOverrides)
	populate(objectMap, "ruleSetType", m.RuleSetType)
	populate(objectMap, "ruleSetVersion", m.RuleSetVersion)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetDefinitionProperties.
func (m ManagedRuleSetDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "ruleGroups", m.RuleGroups)
	populate(objectMap, "ruleSetType", m.RuleSetType)
	populate(objectMap, "ruleSetVersion", m.RuleSetVersion)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetList.
func (m ManagedRuleSetList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "managedRuleSets", m.ManagedRuleSets)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MatchCondition.
func (m MatchCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValue", m.MatchValue)
	populate(objectMap, "matchVariable", m.MatchVariable)
	populate(objectMap, "negateCondition", m.NegateCondition)
	populate(objectMap, "operator", m.Operator)
	populate(objectMap, "selector", m.Selector)
	populate(objectMap, "transforms", m.Transforms)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricsResponse.
func (m *MetricsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTimeBegin":
			err = unpopulateTimeRFC3339(val, "DateTimeBegin", &m.DateTimeBegin)
			delete(rawMsg, key)
		case "dateTimeEnd":
			err = unpopulateTimeRFC3339(val, "DateTimeEnd", &m.DateTimeEnd)
			delete(rawMsg, key)
		case "granularity":
			err = unpopulate(val, "Granularity", &m.Granularity)
			delete(rawMsg, key)
		case "series":
			err = unpopulate(val, "Series", &m.Series)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupOverrideAction.
func (o OriginGroupOverrideAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = DeliveryRuleActionOriginGroupOverride
	populate(objectMap, "parameters", o.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginGroupOverrideAction.
func (o *OriginGroupOverrideAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &o.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupProperties.
func (o OriginGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "healthProbeSettings", o.HealthProbeSettings)
	populate(objectMap, "origins", o.Origins)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	populate(objectMap, "resourceState", o.ResourceState)
	populate(objectMap, "responseBasedOriginErrorDetectionSettings", o.ResponseBasedOriginErrorDetectionSettings)
	populate(objectMap, "trafficRestorationTimeToHealedOrNewEndpointsInMinutes", o.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupUpdateParameters.
func (o OriginGroupUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupUpdatePropertiesParameters.
func (o OriginGroupUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "healthProbeSettings", o.HealthProbeSettings)
	populate(objectMap, "origins", o.Origins)
	populate(objectMap, "responseBasedOriginErrorDetectionSettings", o.ResponseBasedOriginErrorDetectionSettings)
	populate(objectMap, "trafficRestorationTimeToHealedOrNewEndpointsInMinutes", o.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OriginUpdateParameters.
func (o OriginUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PostArgsMatchConditionParameters.
func (p PostArgsMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", p.MatchValues)
	populate(objectMap, "negateCondition", p.NegateCondition)
	populate(objectMap, "operator", p.Operator)
	populate(objectMap, "selector", p.Selector)
	populate(objectMap, "transforms", p.Transforms)
	populate(objectMap, "typeName", p.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProfileUpdateParameters.
func (p ProfileUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PurgeParameters.
func (p PurgeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentPaths", p.ContentPaths)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type QueryStringMatchConditionParameters.
func (q QueryStringMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", q.MatchValues)
	populate(objectMap, "negateCondition", q.NegateCondition)
	populate(objectMap, "operator", q.Operator)
	populate(objectMap, "transforms", q.Transforms)
	populate(objectMap, "typeName", q.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RankingsResponse.
func (r *RankingsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTimeBegin":
			err = unpopulateTimeRFC3339(val, "DateTimeBegin", &r.DateTimeBegin)
			delete(rawMsg, key)
		case "dateTimeEnd":
			err = unpopulateTimeRFC3339(val, "DateTimeEnd", &r.DateTimeEnd)
			delete(rawMsg, key)
		case "tables":
			err = unpopulate(val, "Tables", &r.Tables)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RateLimitRule.
func (r RateLimitRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", r.Action)
	populate(objectMap, "enabledState", r.EnabledState)
	populate(objectMap, "matchConditions", r.MatchConditions)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "priority", r.Priority)
	populate(objectMap, "rateLimitDurationInMinutes", r.RateLimitDurationInMinutes)
	populate(objectMap, "rateLimitThreshold", r.RateLimitThreshold)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RateLimitRuleList.
func (r RateLimitRuleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "rules", r.Rules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RemoteAddressMatchConditionParameters.
func (r RemoteAddressMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RequestBodyMatchConditionParameters.
func (r RequestBodyMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RequestHeaderMatchConditionParameters.
func (r RequestHeaderMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "selector", r.Selector)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RequestMethodMatchConditionParameters.
func (r RequestMethodMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RequestSchemeMatchConditionParameters.
func (r RequestSchemeMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RequestURIMatchConditionParameters.
func (r RequestURIMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResponseBasedOriginErrorDetectionParameters.
func (r ResponseBasedOriginErrorDetectionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "httpErrorRanges", r.HTTPErrorRanges)
	populate(objectMap, "responseBasedDetectedErrorTypes", r.ResponseBasedDetectedErrorTypes)
	populate(objectMap, "responseBasedFailoverThresholdPercentage", r.ResponseBasedFailoverThresholdPercentage)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RouteProperties.
func (r RouteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cacheConfiguration", r.CacheConfiguration)
	populate(objectMap, "customDomains", r.CustomDomains)
	populate(objectMap, "deploymentStatus", r.DeploymentStatus)
	populate(objectMap, "enabledState", r.EnabledState)
	populate(objectMap, "endpointName", r.EndpointName)
	populate(objectMap, "forwardingProtocol", r.ForwardingProtocol)
	populate(objectMap, "httpsRedirect", r.HTTPSRedirect)
	populate(objectMap, "linkToDefaultDomain", r.LinkToDefaultDomain)
	populate(objectMap, "originGroup", r.OriginGroup)
	populate(objectMap, "originPath", r.OriginPath)
	populate(objectMap, "patternsToMatch", r.PatternsToMatch)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "ruleSets", r.RuleSets)
	populate(objectMap, "supportedProtocols", r.SupportedProtocols)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RouteUpdateParameters.
func (r RouteUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RouteUpdatePropertiesParameters.
func (r RouteUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cacheConfiguration", r.CacheConfiguration)
	populate(objectMap, "customDomains", r.CustomDomains)
	populate(objectMap, "enabledState", r.EnabledState)
	populate(objectMap, "endpointName", r.EndpointName)
	populate(objectMap, "forwardingProtocol", r.ForwardingProtocol)
	populate(objectMap, "httpsRedirect", r.HTTPSRedirect)
	populate(objectMap, "linkToDefaultDomain", r.LinkToDefaultDomain)
	populate(objectMap, "originGroup", r.OriginGroup)
	populate(objectMap, "originPath", r.OriginPath)
	populate(objectMap, "patternsToMatch", r.PatternsToMatch)
	populate(objectMap, "ruleSets", r.RuleSets)
	populate(objectMap, "supportedProtocols", r.SupportedProtocols)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RuleProperties.
func (r RuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", r.Actions)
	populate(objectMap, "conditions", r.Conditions)
	populate(objectMap, "deploymentStatus", r.DeploymentStatus)
	populate(objectMap, "matchProcessingBehavior", r.MatchProcessingBehavior)
	populate(objectMap, "order", r.Order)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "ruleSetName", r.RuleSetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleProperties.
func (r *RuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			r.Actions, err = unmarshalDeliveryRuleActionAutoGeneratedClassificationArray(val)
			delete(rawMsg, key)
		case "conditions":
			r.Conditions, err = unmarshalDeliveryRuleConditionClassificationArray(val)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &r.DeploymentStatus)
			delete(rawMsg, key)
		case "matchProcessingBehavior":
			err = unpopulate(val, "MatchProcessingBehavior", &r.MatchProcessingBehavior)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &r.Order)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "ruleSetName":
			err = unpopulate(val, "RuleSetName", &r.RuleSetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleUpdateParameters.
func (r RuleUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RuleUpdatePropertiesParameters.
func (r RuleUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", r.Actions)
	populate(objectMap, "conditions", r.Conditions)
	populate(objectMap, "matchProcessingBehavior", r.MatchProcessingBehavior)
	populate(objectMap, "order", r.Order)
	populate(objectMap, "ruleSetName", r.RuleSetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleUpdatePropertiesParameters.
func (r *RuleUpdatePropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			r.Actions, err = unmarshalDeliveryRuleActionAutoGeneratedClassificationArray(val)
			delete(rawMsg, key)
		case "conditions":
			r.Conditions, err = unmarshalDeliveryRuleConditionClassificationArray(val)
			delete(rawMsg, key)
		case "matchProcessingBehavior":
			err = unpopulate(val, "MatchProcessingBehavior", &r.MatchProcessingBehavior)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &r.Order)
			delete(rawMsg, key)
		case "ruleSetName":
			err = unpopulate(val, "RuleSetName", &r.RuleSetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSLProtocolMatchConditionParameters.
func (s SSLProtocolMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", s.MatchValues)
	populate(objectMap, "negateCondition", s.NegateCondition)
	populate(objectMap, "operator", s.Operator)
	populate(objectMap, "transforms", s.Transforms)
	populate(objectMap, "typeName", s.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecretProperties.
func (s SecretProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deploymentStatus", s.DeploymentStatus)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "profileName", s.ProfileName)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretProperties.
func (s *SecretProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &s.DeploymentStatus)
			delete(rawMsg, key)
		case "parameters":
			s.Parameters, err = unmarshalSecretParametersClassification(val)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &s.ProfileName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyProperties.
func (s SecurityPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deploymentStatus", s.DeploymentStatus)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "profileName", s.ProfileName)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyProperties.
func (s *SecurityPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &s.DeploymentStatus)
			delete(rawMsg, key)
		case "parameters":
			s.Parameters, err = unmarshalSecurityPolicyPropertiesParametersClassification(val)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &s.ProfileName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyUpdateParameters.
func (s SecurityPolicyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyUpdateProperties.
func (s SecurityPolicyUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "parameters", s.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyUpdateProperties.
func (s *SecurityPolicyUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			s.Parameters, err = unmarshalSecurityPolicyPropertiesParametersClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyWebApplicationFirewallAssociation.
func (s SecurityPolicyWebApplicationFirewallAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "domains", s.Domains)
	populate(objectMap, "patternsToMatch", s.PatternsToMatch)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyWebApplicationFirewallParameters.
func (s SecurityPolicyWebApplicationFirewallParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "associations", s.Associations)
	objectMap["type"] = SecurityPolicyTypeWebApplicationFirewall
	populate(objectMap, "wafPolicy", s.WafPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyWebApplicationFirewallParameters.
func (s *SecurityPolicyWebApplicationFirewallParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associations":
			err = unpopulate(val, "Associations", &s.Associations)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "wafPolicy":
			err = unpopulate(val, "WafPolicy", &s.WafPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerPortMatchConditionParameters.
func (s ServerPortMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", s.MatchValues)
	populate(objectMap, "negateCondition", s.NegateCondition)
	populate(objectMap, "operator", s.Operator)
	populate(objectMap, "transforms", s.Transforms)
	populate(objectMap, "typeName", s.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SocketAddrMatchConditionParameters.
func (s SocketAddrMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", s.MatchValues)
	populate(objectMap, "negateCondition", s.NegateCondition)
	populate(objectMap, "operator", s.Operator)
	populate(objectMap, "transforms", s.Transforms)
	populate(objectMap, "typeName", s.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type URLFileExtensionMatchConditionParameters.
func (u URLFileExtensionMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", u.MatchValues)
	populate(objectMap, "negateCondition", u.NegateCondition)
	populate(objectMap, "operator", u.Operator)
	populate(objectMap, "transforms", u.Transforms)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type URLFileNameMatchConditionParameters.
func (u URLFileNameMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", u.MatchValues)
	populate(objectMap, "negateCondition", u.NegateCondition)
	populate(objectMap, "operator", u.Operator)
	populate(objectMap, "transforms", u.Transforms)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type URLPathMatchConditionParameters.
func (u URLPathMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchValues", u.MatchValues)
	populate(objectMap, "negateCondition", u.NegateCondition)
	populate(objectMap, "operator", u.Operator)
	populate(objectMap, "transforms", u.Transforms)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type URLRedirectAction.
func (u URLRedirectAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = DeliveryRuleActionURLRedirect
	populate(objectMap, "parameters", u.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLRedirectAction.
func (u *URLRedirectAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &u.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLRewriteAction.
func (u URLRewriteAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = DeliveryRuleActionURLRewrite
	populate(objectMap, "parameters", u.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLRewriteAction.
func (u *URLRewriteAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &u.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLSigningAction.
func (u URLSigningAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["name"] = DeliveryRuleActionURLSigning
	populate(objectMap, "parameters", u.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLSigningAction.
func (u *URLSigningAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &u.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLSigningActionParameters.
func (u URLSigningActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "algorithm", u.Algorithm)
	populate(objectMap, "parameterNameOverride", u.ParameterNameOverride)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type URLSigningKeyParameters.
func (u URLSigningKeyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyId", u.KeyID)
	populate(objectMap, "secretSource", u.SecretSource)
	populate(objectMap, "secretVersion", u.SecretVersion)
	objectMap["type"] = SecretTypeURLSigningKey
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLSigningKeyParameters.
func (u *URLSigningKeyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyId":
			err = unpopulate(val, "KeyID", &u.KeyID)
			delete(rawMsg, key)
		case "secretSource":
			err = unpopulate(val, "SecretSource", &u.SecretSource)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &u.SecretVersion)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserManagedHTTPSParameters.
func (u UserManagedHTTPSParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["certificateSource"] = CertificateSourceAzureKeyVault
	populate(objectMap, "certificateSourceParameters", u.CertificateSourceParameters)
	populate(objectMap, "minimumTlsVersion", u.MinimumTLSVersion)
	populate(objectMap, "protocolType", u.ProtocolType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserManagedHTTPSParameters.
func (u *UserManagedHTTPSParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateSource":
			err = unpopulate(val, "CertificateSource", &u.CertificateSource)
			delete(rawMsg, key)
		case "certificateSourceParameters":
			err = unpopulate(val, "CertificateSourceParameters", &u.CertificateSourceParameters)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &u.MinimumTLSVersion)
			delete(rawMsg, key)
		case "protocolType":
			err = unpopulate(val, "ProtocolType", &u.ProtocolType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WafMetricsResponse.
func (w *WafMetricsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTimeBegin":
			err = unpopulateTimeRFC3339(val, "DateTimeBegin", &w.DateTimeBegin)
			delete(rawMsg, key)
		case "dateTimeEnd":
			err = unpopulateTimeRFC3339(val, "DateTimeEnd", &w.DateTimeEnd)
			delete(rawMsg, key)
		case "granularity":
			err = unpopulate(val, "Granularity", &w.Granularity)
			delete(rawMsg, key)
		case "series":
			err = unpopulate(val, "Series", &w.Series)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WafRankingsResponse.
func (w *WafRankingsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &w.Data)
			delete(rawMsg, key)
		case "dateTimeBegin":
			err = unpopulateTimeRFC3339(val, "DateTimeBegin", &w.DateTimeBegin)
			delete(rawMsg, key)
		case "dateTimeEnd":
			err = unpopulateTimeRFC3339(val, "DateTimeEnd", &w.DateTimeEnd)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &w.Groups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicy.
func (w WebApplicationFirewallPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", w.Etag)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicyPatchParameters.
func (w WebApplicationFirewallPolicyPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", w.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicyProperties.
func (w WebApplicationFirewallPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customRules", w.CustomRules)
	populate(objectMap, "endpointLinks", w.EndpointLinks)
	populate(objectMap, "managedRules", w.ManagedRules)
	populate(objectMap, "policySettings", w.PolicySettings)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "rateLimitRules", w.RateLimitRules)
	populate(objectMap, "resourceState", w.ResourceState)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
