/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.*;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ReferenceSymbolInternals.ReferenceSymbolInternals2;

/**
 * This class represents the Annotation Reference symbol.
 * <P>
 * Note: we do not necessarily understand each of these symbol type classes.  Refer to the
 *  base class for more information.
 */
// TODO: Consider removing 'implements NameMsSymbol' and change getName() method to something
//  like getAnnotation().  Just because the 'ReferenceSymbolInternals2' has a getName(), which is
//  a String, doesn't really mean it should be a 'name' here.  Even consider changing that
//  internals class to have a 'string' instead of 'name' with getString().
public class AnnotationReferenceMsSymbol extends AbstractReferenceMsSymbol implements NameMsSymbol {

	public static final int PDB_ID = 0x1128;

	/**
	 * Constructor for this symbol.
	 * @param pdb {@link AbstractPdb} to which this symbol belongs.
	 * @param reader {@link PdbByteReader} from which this symbol is deserialized.
	 * @throws PdbException upon error parsing a field.
	 */
	public AnnotationReferenceMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
		super(pdb, reader, ReferenceSymbolInternals.parse2(pdb, reader));
	}

	@Override
	public int getPdbId() {
		return PDB_ID;
	}

	/**
	 * Returns the name field of this symbol.
	 * @return the name.
	 */
	@Override
	public String getName() {
		return ((ReferenceSymbolInternals2) internals).getName();
	}

	@Override
	protected String getSymbolTypeName() {
		return "ANNOTATIONREF";
	}

}
